-----------------------------------
-- ID: 5899
-- shadescale_femur
-- Used for: Weakens Apocalyptic Beast, locks Heavy Stomp and Body Slam.
-- Used for: Weakens Arch Apocalyptic Beast, reduces Heavy Stomp and Body Slam use.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("shadescale_femur")

xi.module.ensureTable("xi.items.shadescale_femur")

m:addOverride("xi.items.shadescale_femur.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Apocalyptic_Beast" and target:getName() ~= "Arch_Apocalyptic_Beast" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.shadescale_femur.onItemUse", function(target)
    target:addStatusEffect(xi.effect.AGI_BOOST, 0, 0, 3600)
end)

return m
