-----------------------------------
-- ID: 5897
-- redolent_root
-- Used for: Weakens Cirrate Christelle, remove Extremely Bad Breath mobskill.
-- Used for: Weakens Arch Christelle, reduces Extremely Bad Breath mobskill use.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("redolent_root")

xi.module.ensureTable("xi.items.redolent_root")

m:addOverride("xi.items.redolent_root.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Cirrate_Christelle" and target:getName() ~= "Arch_Christelle" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.redolent_root.onItemUse", function(target)
    target:addStatusEffect(xi.effect.DEX_BOOST, 0, 0, 3600)
end)

return m
