require("modules/module_utils")
--------------------------------------------
local m = Module:new("cw_provenance_ring")

xi.module.ensureTable("xi.items.provenance_ring")

m:addOverride("xi.items.provenance_ring.onItemCheck", function(target)
    if not target:isCrystalWarrior() then
        target:printToPlayer("Only Crystal Warriors are allowed to use this ring.")
        return xi.msg.basic.ITEM_UNABLE_TO_USE
    end

    if target:getCharVar("[CW]INTRO") < 9 then
        target:printToPlayer("You cannot return to Provenance yet.")
        return xi.msg.basic.ITEM_UNABLE_TO_USE
    end

    return 0
end)

m:addOverride("xi.items.provenance_ring.onItemUse", function(target)
    target:timer(5500, function(playerArg)
        target:setPos(497.090, 27.500, -467.008, 203, 222) -- Provenance
    end)
end)

return m
