--------------------------------------------
-- ID: 6537
-- Pungent Powder III
-- Enchantment: 60Min, Costume -
-- Baby Adamantoise (2925)
-- Baby Behemoth (2937)
-- Baby Fafnir (2944)
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("pinch_of_pungent_powder_iii")

xi.module.ensureTable("xi.items.pinch_of_pungent_powder_iii")

m:addOverride("xi.items.pinch_of_pungent_powder_iii.onItemCheck", function(target)
    if not target:canUseMisc(xi.zoneMisc.COSTUME) then
        return xi.msg.basic.CANT_BE_USED_IN_AREA
    end

    return 0
end)

m:addOverride("xi.items.pinch_of_pungent_powder_iii.onItemUse", function(target)
    local costumes = { 2925, 2937, 2944 }
    local randomCostume = costumes[math.random(1, #costumes)]

    target:addStatusEffect(xi.effect.COSTUME, randomCostume, 0, 3600)
end)

return m
