--------------------------------------------
-- ID: 5724
-- Pungent Powder
-- Enchantment: 60Min, Costume -
-- Baby Buffalo (2920)
-- Baby Coeurl (2921)
-- Baby Bugard (2927)
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("pinch_of_pungent_powder")

xi.module.ensureTable("xi.items.pinch_of_pungent_powder")

m:addOverride("xi.items.pinch_of_pungent_powder.onItemCheck", function(target)
    if not target:canUseMisc(xi.zoneMisc.COSTUME) then
        return xi.msg.basic.CANT_BE_USED_IN_AREA
    end

    return 0
end)

m:addOverride("xi.items.pinch_of_pungent_powder.onItemUse", function(target)
    local costumes = { 2920, 2921, 2927 }
    local randomCostume = costumes[math.random(1, #costumes)]

    target:addStatusEffect(xi.effect.COSTUME, randomCostume, 0, 3600)
end)

return m
