-----------------------------------
-- ID: 5904
-- perforated_wing
-- Used for: Weakens Antaeus, removes critical hit rate and attack boost.
-- Used for: Weakens Arch Antaeus, removes critical hit rate and attack boost.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("perforated_wing")

xi.module.ensureTable("xi.items.perforated_wing")

m:addOverride("xi.items.perforated_wing.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Antaeus" and target:getName() ~= "Arch_Antaeus" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.perforated_wing.onItemUse", function(target)
    target:addStatusEffect(xi.effect.DEX_BOOST, 0, 0, 3600)
end)

return m
