-----------------------------------
-- ID: 5895
-- Odorless Fungus
-- Used for: Weakens Cirrate Christelle, remove miasmic breath mobskill and adds weight effect.
-- Used for: Weakens Arch Christelle, reduces miasmic breath mobskill use and adds weight effect..
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("odorless_fungus")

xi.module.ensureTable("xi.items.odorless_fungus")

m:addOverride("xi.items.odorless_fungus.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Cirrate_Christelle" and target:getName() ~= "Arch_Christelle" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.odorless_fungus.onItemUse", function(target)
    target:addStatusEffect(xi.effect.VIT_BOOST, 0, 0, 3600)
end)

return m
