-----------------------------------
-- Allows Mythic Weaponskills to be used while weapon is equipped
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("nyzul_mythic_weaponskills")

local nyzulWeapons =
{
    'double_axe',
    'dancing_dagger',
    'radiant_lance',
    'sasuke_katana',
    'sturdy_axe',
    'mages_staff',
    'elder_staff',
    'scepter_staff',
    'killer_bow',
    'quicksilver',
    'burning_fists',
    'inferno_claws',
    'death_sickle',
    'main_gauche',
}

for _, weapon in ipairs(nyzulWeapons) do
    local weaponPath = 'xi.items.' .. weapon

    xi.module.ensureTable(weaponPath)

    m:addOverride(weaponPath .. '.onItemEquip', function(target, item)
        xi.equipment.baseNyzulTemporarilyUnlockWS(target)

        target:addListener('WEAPONSKILL_STATE_EXIT', 'MYTHIC_WS_UNLOCK', function(playerArg, wsIdArg)
            xi.equipment.baseNyzulTemporarilyUnlockWS(playerArg)
        end)
    end)

    m:addOverride(weaponPath .. 'onItemUnequip', function(target, item)
        target:removeListener('MYTHIC_WS_UNLOCK')
    end)
end

return m
