-----------------------------------
-- ID: 5265
-- Mistmelt
-- Used for: Bringing Ouryu down from the sky during Promathia Mission 4-2: The Savage and Ouryu Cometh.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("mistmelt")

xi.module.ensureTable("xi.items.mistmelt")

m:addOverride("xi.items.mistmelt.onItemCheck", function(target)
    local result = 0

    if target:getName() ~= "Ouryu" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.mistmelt.onItemUse", function(target)
    if target:getAnimationSub() == 1 then
        target:delStatusEffect(xi.effect.ALL_MISS)
        target:SetMobSkillAttack(0)
        target:setAnimationSub(2)
        target:setLocalVar("changeTime", target:getBattleTime())
    end
end)

return m
