-----------------------------------
-- Kraken Club (21104), Kraken Club +1 (17440), Octave Club (18852)
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_kraken_club")

local clubs =
{
    { id = xi.item.KRAKEN_CLUB,    name = "kraken_club"    },
    { id = xi.item.KRAKEN_CLUB_P1, name = "kraken_club_+1" },
    { id = xi.item.OCTAVE_CLUB,    name = "octave_club"    },
}

local clubIDs = set {
    xi.item.KRAKEN_CLUB,
    xi.item.KRAKEN_CLUB_P1,
    xi.item.OCTAVE_CLUB,
}

for _, club in pairs(clubs) do
    local path = fmt("xi.items.{}", club.name)
    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemEquip", function(target)
        if
            target:getGMLevel() > 2 or
            not clubIDs[target:getEquipID(xi.slot.MAIN)]
        then
            return 0
        end

        target:unequipItem(xi.slot.SUB)
        target:messageBasic(xi.msg.basic.ITEM_UNABLE_TO_USE)
    end)
end

return m
