--------------------------------------------
-- Item: Forgotten Pouches
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("forgotten_pouches")

local pouches =
{
    [3493] = "pouch_of_forgotten_thoughts",
    [3494] = "pouch_of_forgotten_hopes",
    [3495] = "pouch_of_forgotten_touches",
    [3496] = "pouch_of_forgotten_journeys",
    [3497] = "pouch_of_forgotten_steps",
}

for forgotten, pouch in pairs(pouches) do
    local itemPath = string.format("xi.items.%s", pouch)
    xi.module.ensureTable(itemPath)

    m:addOverride(itemPath .. ".onItemCheck", function(target)
        return xi.itemUtils.itemBoxOnItemCheck(target)
    end)

    m:addOverride(itemPath .. ".onItemUse", function(target)
        local amount = math.random(3,15)
        target:addItem(forgotten, amount)
    end)
end

return m
