--------------------------------------------
-- Item: Domain Ring
-- Grants "Elvorseal" Effect
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_domain_ring")

xi.module.ensureTable("xi.items.domain_ring")

local domains =
{
    [xi.zone.CEIZAK_BATTLEGROUNDS]  = 1,
    [xi.zone.FORET_DE_HENNETIEL]    = 1,
    [xi.zone.MORIMAR_BASALT_FIELDS] = 1,
    [xi.zone.YORCIA_WEALD]          = 1,
    [xi.zone.MARJAMI_RAVINE]        = 1,
    [xi.zone.KAMIHR_DRIFTS]         = 1,
    [xi.zone.RAKAZNAR_TURRIS]       = 1,
}

m:addOverride("xi.items.domain_ring.onItemCheck", function(target)
    local zoneID = target:getZoneID()
    local result = 0

    if domains[zoneID] == nil then
        target:printToPlayer("You cannot use this outside of Domain Invasion.", xi.msg.channel.SYSTEM_3)
        result = xi.msg.basic.CANT_BE_USED_IN_AREA
    end

    if target:hasStatusEffect(xi.effect.ELVORSEAL) then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    end

    return result
end)

m:addOverride("xi.items.domain_ring.onItemUse", function(target)
    target:addStatusEffect(xi.effect.ELVORSEAL, 1, 0, 3600)
end)

return m
