--------------------------------------------
-- Item: Domain Coffer/+1
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_domain_coffer")

local equipment =
{
    28271, -- Adsilio Boots
    27598, -- Dew Silk Cape
    11579, -- Fylgja Torque
    16052, -- Incubus Earring
    11581, -- Ire Torque
    11583, -- Lmg. Medallion
    15949, -- Pythia Sash
    15951, -- Toxon Belt
    15839, -- Antica Ring
    11484, -- Antica Band
    28529, -- Setae Ring
    28488, -- Megasco Earring
}

local items =
{
    {
        name = "domain_coffer",
        roll = { 6, 12 },
        pts  = { 500, 1000 },
        pop  = 1, -- Adoulin Letter (1%)
        loot =
        {
            1255, -- Fire Ore
            1256, -- Ice Ore
            1257, -- Wind Ore
            1258, -- Earth Ore
            1259, -- Lightning Ore
            1260, -- Water Ore
            1261, -- Light Ore
            1262, -- Dark Ore
        },
        rare =
        {
            3980, -- Bztavian Stinger
            3979, -- Rockfin Tooth
            3977, -- Gabbrath Horn
            4014, -- Yggdreant Bole
            4012, -- Waktza Rostrum
            8752, -- Cehuetzi Claw
        },
        trash =
        {
            3297, -- Flame Geode
            3298, -- Snow Geode
            3299, -- Breeze Geode
            3300, -- Soil Geode
            3301, -- Thunder Geode
            3302, -- Aqua Geode
            3303, -- Light Geode
            3304, -- Shadow Geode
            4026, -- Akaso
            3926, -- Urunday Log
            8707, -- Raaz Hide
            3934, -- Matamata Shell
        },
    },
    {
        name = "domain_coffer_+1",
        roll = { 15, 30 },
        pts  = { 2000, 3000 },
        pop  = 10, -- Adoulin Letter (10%)
        loot =
        {
            3980, -- Bztavian Stinger
            3979, -- Rockfin Tooth
            3977, -- Gabbrath Horn
            4014, -- Yggdreant Bole
            4012, -- Waktza Rostrum
            8752, -- Cehuetzi Claw
        },
        rare =
        {
            3981, -- Bztavian Wing
            3978, -- Rockfin Fin
            6068, -- Gabbrath Meat
            4015, -- Yggdreant Root
            4013, -- Waktza Crest
            8754, -- Cehuetzi Pelt
        },
        trash =
        {
            1255, -- Fire Ore
            1256, -- Ice Ore
            1257, -- Wind Ore
            1258, -- Earth Ore
            1259, -- Lightning Ore
            1260, -- Water Ore
            1261, -- Light Ore
            1262, -- Dark Ore
            4026, -- Akaso
            3926, -- Urunday Log
            8707, -- Raaz Hide
            3934, -- Matamata Shell
        },
    },
}

local function openBox(target, itemInfo)
    local msgID = zones[target:getZoneID()].text.ITEM_OBTAINED + 9

    local shards = math.random(itemInfo.pts[1], itemInfo.pts[2])
    target:incrementCharVar("[Domain]Shards", shards)
    target:sys("{} gains {} domain shards.", target:getName(), shards)

    local bayld = math.random(itemInfo.roll[1], itemInfo.roll[2])
    target:addItem(8798, bayld) -- H-P Bayld
    target:messageSpecial(msgID, 8798, bayld)

    local item = itemInfo.loot[math.random(1, #itemInfo.loot)]
    target:addItem(item) -- Material
    target:messageSpecial(msgID, item, 1)

    local rare = itemInfo.trash[math.random(1, #itemInfo.trash)]

    if math.random(0, 100) < 15 then
        rare = itemInfo.rare[math.random(1, #itemInfo.rare)]
    end

    target:addItem(rare) -- Rare or trash
    target:messageSpecial(msgID, rare, 1)

    -- Chance to roll NQ accessories (5%)
    if math.random(0, 100) < 5 then
        local item = equipment[math.random(1, #equipment)]

        if target:canObtainItem(item) then
            target:addItem(item) -- Rare Equipment
            target:messageSpecial(msgID, item, 1)
        end
    else
        -- Chance to roll Adoulin Letter pop item (1% / 10%)
        if math.random(0, 100) < itemInfo.pop then
            -- TODO: Fix this for full rebuild
            -- if target:canObtainItem(xi.item.ADOULIN_LETTER) then
                target:addItem(xi.item.ADOULIN_LETTER)
                target:messageSpecial(msgID, xi.item.ADOULIN_LETTER, 1)
            --end
        end
    end
end

for _, itemInfo in pairs(items) do
    local path = fmt("xi.items.{}", itemInfo.name)
    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemCheck", function(target)
        if target:getFreeSlotsCount() < 4 then
            return xi.msg.basic.ITEM_NO_USE_INVENTORY
        end
    end)

    m:addOverride(path .. ".onItemUse", function(target)
        openBox(target, itemInfo)
    end)
end

return m
