-----------------------------------
-- ID: 18231
-- Death Chakram
-----------------------------------
require('modules/module_utils')
--------------------------------------------

local m = Module:new('death_chakram')

xi.module.ensureTable('xi.items.death_chakram')

m:addOverride('xi.items.death_chakram.onItemCheck', function(target)
    local effect = target:getStatusEffect(xi.effect.ENCHANTMENT)

    if effect ~= nil and effect:getSubType() == 18231 then
        target:delStatusEffect(xi.effect.ENCHANTMENT)
    end

    return 0
end)

m:addOverride('xi.items.death_chakram.onItemUse', function(target, player, item)
    target:addStatusEffect(xi.effect.ENCHANTMENT, 0, 0, 180, item:getID())
end)

m:addOverride('xi.items.death_chakram.onEffectGain', function(target, effect)
    target:addMod(xi.mod.MPP, 5)
end)

m:addOverride('xi.items.death_chakram.onEffectLose', function(target, effect)
    target:delMod(xi.mod.MPP, 5)
end)

return m
