-----------------------------------
-- Crystal Warrior Ammo Quivers
-- FLAME_QUIVER        = 6420;
-- FROST_QUIVER        = 6417;
-- THUNDER_BOLT_QUIVER = 6429;
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_cw_quivers")

local quivers =
{
    flame_quiver        = 22289,
    frost_quiver        = 21300,
    thunder_bolt_quiver = 22290,
}

for quiver, ammo in pairs(quivers) do
    local path = string.format("xi.items.%s", quiver)

    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemCheck", function(target)
        local result = 0

        if target:getFreeSlotsCount() == 0 then
            result = xi.msg.basic.ITEM_NO_USE_INVENTORY
        end

        return result
    end)

    m:addOverride(path .. ".onItemUse", function(target)
        target:addItem(ammo, 99)
    end)

end

return m
