--------------------------------------------
-- Custom Food
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_custom_food")

local foodList =
{
    {
        name = "dragon_fruit_pie",
        item = 6517,
        time = 10800,
        mods =
        {
            [xi.mod.MP]     = 30,
            [xi.mod.INT]    = 4,
            [xi.mod.MPHEAL] = 8,
            [xi.mod.MATT]   = 4,
        },
    },
    {
        name = "rolanberry_cheesecake",
        item = 6518,
        time = 10800,
        mods =
        {
            [xi.mod.MP]           = 40,
            [xi.mod.MND]          = 4,
            [xi.mod.MPHEAL]       = 8,
            [xi.mod.CURE_POTENCY] = 4,
        },
    },
}

for _, food in pairs(foodList) do
    local path = fmt("xi.items.{}", food.name)
    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemCheck", function(target)
        return xi.itemUtils.foodOnItemCheck(target, xi.foodType.BASIC)
    end)

    m:addOverride(path .. ".onItemUse", function(target)
        target:addStatusEffect(xi.effect.FOOD, 0, 0, food.time, food.item)
    end)

    m:addOverride(path .. ".onEffectGain", function(target, effect)
        for modID, modValue in pairs(food.mods) do
            target:addMod(modID, modValue)
        end
    end)

    m:addOverride(path .. ".onEffectLose", function(target, effect)
        for modID, modValue in pairs(food.mods) do
            target:delMod(modID, modValue)
        end
    end)
end

return m
