-----------------------------------
-- Crystal Pouch
-- ID: 6546
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_crystal_pouch")

xi.module.ensureTable("xi.items.pouch_of_crystal_fragments")

m:addOverride("xi.items.pouch_of_crystal_fragments.onItemCheck", function(target)
    local result = 0

    if target:getFreeSlotsCount() == 0 then
        result = xi.msg.basic.ITEM_NO_USE_INVENTORY
    end

    return result
end)

m:addOverride("xi.items.pouch_of_crystal_fragments.onItemUse", function(target)
    local amount = math.random(6, 12)
    target:addItem(8966, amount) -- x6-12 Crystal Fragments
    target:PrintToPlayer(string.format("You find %u crystal fragments.", amount))
end)

return m
