--------------------------------------------
-- Item: Crab Cap +1
-- !additem 25669
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_crab_cap_+1")

xi.module.ensureTable("xi.items.crab_cap_+1")

m:addOverride("xi.items.crab_cap_+1.onItemCheck", function(target)
    if not target:canUseMisc(xi.zoneMisc.COSTUME) then
        return xi.msg.basic.CANT_BE_USED_IN_AREA
    end

    return 0
end)

m:addOverride("xi.items.crab_cap_+1.onItemUse", function(target)
    local costumes =
    {
         355, -- Red    (Tiny)
         356, -- Blue   (Large)
         357, -- Red    (Large)
         360, -- Carrie (Small)
        2965, -- Gold   (Small)
    }
    local randomCostume = costumes[math.random(1, #costumes)]

    target:addStatusEffect(xi.effect.COSTUME, randomCostume, 0, 3600)
end)

return m
