-----------------------------------
-- ID: 6547
-- Commendation Bag
-- Contains 4-12 Goblin Commendations
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_commendation_bag")

xi.module.ensureTable("xi.items.commendation_bag")

m:addOverride("xi.items.commendation_bag.onItemCheck", function(target)
    local result = 0

    if target:getFreeSlotsCount() == 0 then
        result = xi.msg.basic.ITEM_NO_USE_INVENTORY
    end

    return result
end)

m:addOverride("xi.items.commendation_bag.onItemUse", function(target)
    local qty = math.random(4, 12)
    target:addItem(xi.item.GOBLIN_COMMENDATION, qty)
    target:messageSpecial(zones[target:getZoneID()].text.ITEM_OBTAINED + 9, xi.item.GOBLIN_COMMENDATION, qty)
end)

return m
