-----------------------------------
-- ID: 5896
-- clump_of_absorbent_moss
-- Used for: Weakens Cirrate Christelle, remove fragrant breath.
-- Used for: Weakens Arch Christelle, reduces fragrant breath use.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("clump_of_absorbent_moss")

xi.module.ensureTable("xi.items.clump_of_absorbent_moss")

m:addOverride("xi.items.clump_of_absorbent_moss.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Cirrate_Christelle" and target:getName() ~= "Arch_Christelle" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.clump_of_absorbent_moss.onItemUse", function(target)
    target:addStatusEffect(xi.effect.STR_BOOST, 0, 0, 3600)
end)

return m
