-----------------------------------
-- Brutal Earring / +1
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_brutal_earring")

local exclusive =
{
    { "brutal_earring_+1", xi.item.BRUTAL_EARRING    },
    { "brutal_earring",    xi.item.BRUTAL_EARRING_P1 },
}

for _, itemInfo in pairs(exclusive) do
    local path = string.format("xi.items.%s", itemInfo[1])

    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemEquip", function(target)
        if target:getGMLevel() > 2 then
            return 0
        end

        if target:getEquipID(xi.slot.EAR1) == itemInfo[2] then
            target:unequipItem(xi.slot.EAR2)
            target:messageBasic(xi.msg.basic.ITEM_UNABLE_TO_USE)

        elseif target:getEquipID(xi.slot.EAR2) == itemInfo[2] then
            target:unequipItem(xi.slot.EAR1)
            target:messageBasic(xi.msg.basic.ITEM_UNABLE_TO_USE)

        else
            return 0
        end
    end)
end

return m
