-----------------------------------
-- Update Zalsuhn to require scaling ws points based on nyzul climb (pre 2014)
-- Also update the required WS points for all Vigil weapons latent ability
-----------------------------------
require('modules/module_utils')
-----------------------------------
local m = Module:new('unlocking_a_myth')

m:addOverride('xi.equipment.baseNyzulWeaponRequiredWsPoints', function(player)
    local nyzulFloorProgress = player:getCharVar('NyzulFloorProgress')
    -- Wings players were allowed to reset their runic disc to get a reward, this charvar counts how mnay times they did it
    -- If this is > 0 then they have climbed to 100, and should only require 250 ws points
    if nyzulFloorProgress == 100 or player:getCharVar("NyzulClimbNumber") > 0 then
        return 250
    elseif nyzulFloorProgress >= 80 then
        return 500 + 20 * (99 - nyzulFloorProgress)
    elseif nyzulFloorProgress >= 60 then
        return 1000 + 40 * (79 - nyzulFloorProgress)
    elseif nyzulFloorProgress >= 40 then
        return 2000 + 80 * (59 - nyzulFloorProgress)
    elseif nyzulFloorProgress >= 20 then
        return 4000 + 160 * (39 - nyzulFloorProgress)
    elseif nyzulFloorProgress > 0 then
        return 8000 + 320 * (19 - nyzulFloorProgress)
    else
        return 16000
    end
end)

return m
