--------------------------------------------
-- Remove out of era spells from magic shops
--------------------------------------------
require("scripts/globals/utils")
require("modules/module_utils")
require("scripts/globals/shop")
require("scripts/globals/npc_util")

local m = Module:new("magic_shops")

m:addOverride("xi.zones.Nashmau.npcs.Chichiroon.onTrigger", function(player, npc)
    local ID = require("scripts/zones/Nashmau/IDs")
    local stock =
    {
        5504,  95800,    -- Companion's Die
        6368,  69288,    -- Geomancer Die
        6369,  73920,    -- Rune Fencer Die
    }

    player:showText(npc, ID.text.CHICHIROON_SHOP_DIALOG)
    player:printToPlayer('Chichiroon: I heard Captain Farrell across the way holds the secret to other exclusive die...', xi.msg.channel.NS_SAY)
    xi.shop.general(player, stock)
end)

-----------------------------------
-- Replace 99 Jug Pets with 75 ones
-----------------------------------
m:addOverride("xi.zones.Upper_Jeuno.npcs.Theraisie.onTrigger", function(player, npc)
    local ID = require("scripts/zones/Upper_Jeuno/IDs")
    local stock =
    {
        -- Custom Items
        17860,  500,   -- jug_of_carrot_broth
        17876,  500,   -- jug_of_fish_broth
        17864,  500,   -- jug_of_herbal_broth
        17905,  500,   -- jug_of_wormy_broth
        17885,  500,   -- jug_of_grass._broth
        17870, 5000,   -- jug_of_meat_broth
        17862,  500,   -- jug_of_bug_broth
        17866,  500,   -- jug_of_carrion_broth
        17887, 1000,   -- jug_of_mole_broth
        17880, 1000,   -- jug_of_seedbed_soil
        17891, 4000,   -- jug_of_antica_broth
        17872, 2000,   -- jug_of_tree_sap
        17889, 5000,   -- jug_of_blood_broth
        17016,  300,   -- pet_food_alpha
        17017,  600,   -- pet_food_beta
        17018,  900,   -- pet_food_gamma
        17019, 1000,   -- pet_food_delta
        17020, 1500,   -- pet_food_epsilon
        17021, 5000,   -- pet_food_zeta
        19251, 2000,   -- pet_roborant
        19252, 1500,   -- pet_poultice
    }

    player:showText(npc, ID.text.MP_SHOP_DIALOG)
    xi.shop.general(player, stock)
end)

return m
