-----------------------------------
-- Reactive Shield (Ability)
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-----------------------------------
local m = Module:new("reactive_shield_ability")
local path = "xi.actions.abilities.pets.automaton.reactive_shield"

m:addOverride(path .. ".onAutomatonAbility", function(target, automaton, skill, master, action)
    automaton:addRecast(xi.recast.ABILITY, skill:getID(), 65)
    local pMod = math.max(automaton:getSkillLevel(xi.skill.AUTOMATON_MELEE), automaton:getSkillLevel(xi.skill.AUTOMATON_RANGED), automaton:getSkillLevel(xi.skill.AUTOMATON_MAGIC))
    local duration = 60
    local power = math.floor((pMod / 56)^3 * 0.8) + 4

    if target:addStatusEffect(xi.effect.BLAZE_SPIKES, power, 0, duration) then
        skill:setMsg(xi.msg.basic.SKILL_GAIN_EFFECT)
    else
        skill:setMsg(xi.msg.basic.SKILL_NO_EFFECT)
    end

    return xi.effect.BLAZE_SPIKES
end)

return m
