-----------------------------------
-- Ranged Attack (Ability)
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-----------------------------------
local m = Module:new("ranged_attack_ability")
local path = "xi.actions.abilities.pets.automaton.ranged_attack"

m:addOverride(path .. ".onAutomatonAbility", function(target, automaton, skill, master, action)
    local dmg
    if not automaton:hasStatusEffect(xi.effect.DOUBLE_SHOT) then
        dmg = super(target, automaton, skill, master, action)
    else
        local targetLvl = target:getMainLvl()
        local numhits = 1
        local accmod = 1
        local dmgmod = 2

        dmgmod = dmgmod + math.floor(targetLvl / 40)

        local rate = automaton:getMod(xi.mod.DOUBLE_SHOT_RATE)
        local chance = math.random(1,100)
        if chance <= rate then
            numhits = 2
        end

        local originalTP = automaton:getTP()
        
        local info = xi.mobskills.mobRangedMove(automaton, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.RANGED)
        dmg = xi.mobskills.mobFinalAdjustments(info.dmg, automaton, skill, target, xi.attackType.RANGED, xi.damageType.PIERCING, info.hitslanded)
        dmg = dmg * (1 + automaton:getMod(xi.mod.AUTO_RANGED_DAMAGEP) / 100)
        target:takeDamage(dmg, automaton, xi.attackType.RANGED, xi.damageType.PIERCING)

        local actualHits = info.hitslanded

        if actualHits > 1 then
            automaton:addTP(((automaton:getTP() - originalTP - (10 * (actualHits - 1))) * (actualHits - 1)) - (10 * (actualHits - 1)))
        end
    end

    return dmg
end)

return m
