-----------------------------------
-- Mana Channeler
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-----------------------------------
local m = Module:new("mana_channeler")
local path = "xi.actions.abilities.pets.attachments.mana_channeler"

m:addOverride(path .. ".onEquip", function(pet, attachment)
    xi.automaton.onAttachmentEquip(pet, attachment)
end)

m:addOverride(path .. ".onUnequip", function(pet, attachment)
    xi.automaton.onAttachmentUnequip(pet, attachment)
end)

m:addOverride(path .. ".onManeuverGain", function(pet, attachment, maneuvers)
    xi.automaton.onManeuverGain(pet, attachment, maneuvers)
end)

m:addOverride(path .. ".onManeuverLose", function(pet, attachment, maneuvers)
    xi.automaton.onManeuverLose(pet, attachment, maneuvers)
end)

m:addOverride(path .. ".onUpdate", function(pet, attachment, maneuvers)
    xi.automaton.updateAttachmentModifier(pet, attachment, maneuvers)
end)

return m
