-----------------------------------
-- Disruptor
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-----------------------------------
local m = Module:new("disruptor")
local path = "xi.actions.abilities.pets.attachments.disruptor"

m:addOverride(path .. ".onEquip", function(pet)
    pet:addListener('AUTOMATON_ATTACHMENT_CHECK', 'ATTACHMENT_DISRUPTOR', function(automaton, target)
        local master = automaton:getMaster()
        if
            master and
            master:countEffect(xi.effect.DARK_MANEUVER) > 0 and
            target:hasStatusEffectByFlag(xi.effectFlag.DISPELABLE) and
            (automaton:checkDistance(target) - target:getModelSize()) < 18
        then
            automaton:useMobAbility(xi.automaton.abilities.DISRUPTOR)
        end
    end)
end)

m:addOverride(path .. ".onUnequip", function(pet)
    pet:removeListener('ATTACHMENT_DISRUPTOR')
end)

return m
