-----------------------------------
-- Barrage Turbine (Ability)
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-----------------------------------
local m = Module:new("barrage_turbine_ability")
local path = "xi.actions.abilities.pets.automaton.barrage_turbine"

xi.module.ensureTable(path)

m:addOverride(path .. ".onAutomatonAbilityCheck", function(target, automaton, skill)
    return 0
end)

m:addOverride(path .. ".onAutomatonAbility", function(target, automaton, skill, master, action)
    local duration = math.random(60, 180)
    automaton:addRecast(xi.recast.ABILITY, skill:getID(), duration)

    local targetLvl = target:getMainLvl()
    local numhits = 2 + master:countEffect(xi.effect.WIND_MANEUVER)
    local accmod = 1
    local dmgmod = 2
    
    dmgmod = dmgmod + math.floor(targetLvl / 40)

    local originalTP = automaton:getTP()

    local info = xi.mobskills.mobRangedMove(automaton, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.RANGED)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, automaton, skill, target, xi.attackType.RANGED, xi.damageType.PIERCING, info.hitslanded)
    dmg = dmg * (1 + automaton:getMod(xi.mod.AUTO_RANGED_DAMAGEP) / 100)
    target:takeDamage(dmg, automaton, xi.attackType.RANGED, xi.damageType.PIERCING)

    local actualHits = info.hitslanded
    
    if actualHits > 1 then
        automaton:addTP(((automaton:getTP() - originalTP - (10 * (actualHits - 1))) * (actualHits - 1)) - (10 * (actualHits - 1)))
    end

    return dmg
end)

return m
