-----------------------------------
-- Barrage Turbine
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-----------------------------------
local m = Module:new("barrage_turbine")
local path = "xi.actions.abilities.pets.attachments.barrage_turbine"

xi.module.ensureTable(path)

m:addOverride(path .. ".onEquip", function(pet)
    pet:addListener('AUTOMATON_ATTACHMENT_CHECK', 'ATTACHMENT_BARRAGE_TURBINE', function(automaton, target)
        local master = automaton:getMaster()
        if
            not automaton:hasRecast(xi.recast.ABILITY, xi.automaton.abilities.BARRAGE_TURBINE) and
            master and
            master:countEffect(xi.effect.WIND_MANEUVER) > 0 and
            (automaton:checkDistance(target) - target:getModelSize()) <= 25
        then
            automaton:useMobAbility(xi.automaton.abilities.BARRAGE_TURBINE, automaton:getTarget())
        end
    end)
end)

m:addOverride(path .. ".onUnequip", function(pet)
    pet:removeListener('ATTACHMENT_BARRAGE_TURBINE')
end)

m:addOverride(path .. ".onManeuverGain", function(pet, maneuvers)
end)

m:addOverride(path .. ".onManeuverLose", function(pet, maneuvers)
end)

return m
