-----------------------------------
-- Attuner
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-----------------------------------
local m = Module:new("attuner")
local path = "xi.actions.abilities.pets.attachments.attuner"

local resetMod = function(pet)
    local currentBonus = pet:getLocalVar('attuner')
    pet:delMod(xi.mod.ATTP, currentBonus)
    pet:delMod(xi.mod.RATTP, currentBonus)
    pet:setLocalVar('attuner', 0)
end

local applyMod = function(pet)
    local maneuvers = pet:getMaster():countEffect(xi.effect.FIRE_MANEUVER)
    local newBonus = 5
    if maneuvers == 1 then
        newBonus = 15
    elseif maneuvers == 2 then
        newBonus = 30
    elseif maneuvers == 3 then
        newBonus = 45
    end
    pet:setLocalVar("attuner", newBonus)
    pet:addMod(xi.mod.ATTP, newBonus)
    pet:addMod(xi.mod.RATTP, newBonus)
end

m:addOverride(path .. ".onEquip", function(pet)
    pet:addListener('ENGAGE', 'AUTO_ATTUNER_ENGAGE', function(auto, target)
        resetMod(auto)

        if auto:getMainLvl() < target:getMainLvl() then
            applyMod(auto)
        end
    end)

    pet:addListener('DISENGAGE', 'AUTO_ATTUNER_DISENGAGE', function(auto)
        resetMod(auto)
    end)
end)

m:addOverride(path .. ".onUnequip", function(pet)
    pet:removeListener('AUTO_ATTUNER_ENGAGE')
    pet:removeListener('AUTO_ATTUNER_DISENGAGE')
end)

m:addOverride(path .. ".onManeuverGain", function(pet, maneuvers)
    if pet:getLocalVar('attuner') > 0 then
        resetMod(pet)
        local targ = pet:getTarget()
        if targ ~= nil then
            if pet:getMainLvl() < targ:getMainLvl() then
                applyMod(pet)
            end
        end
    end
end)

m:addOverride(path .. ".onManeuverLose", function(pet, maneuvers)
    if pet:getLocalVar('attuner') > 0 then
        resetMod(pet)
        local targ = pet:getTarget()
        if targ ~= nil then
            if pet:getMainLvl() < targ:getMainLvl() then
                applyMod(pet)
            end
        end
    end
end)

return m
