-----------------------------------
-- Access to post-75 movement speed buffs
-- Fleet wind: originally lvl 86 bp:ward from garuda
-- Bolter's roll: originally lvl 76 phantom roll
--                  Adjusted to drop effect on combat
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("movement_ability_qols")

xi.module.ensureTable("xi.actions.abilities.pets.fleet_wind")

m:addOverride("xi.actions.abilities.pets.fleet_wind.onAbilityCheck", function(player, target, ability)
    return 0, 0
end)

m:addOverride("xi.actions.abilities.pets.fleet_wind.onPetAbility", function(target, pet, skill, master, action)
    local typeEffect = xi.effect.QUICKENING
    local duration = 90
    local bonus = math.floor(xi.summon.getSummoningSkillOverCap(pet) * duration / 30)
    duration = utils.clamp(duration + bonus, duration, 180)

    target:delStatusEffect(typeEffect)
    target:addStatusEffect(typeEffect, 20, 0, duration)
    skill:setMsg(xi.msg.basic.JA_GAIN_EFFECT)

    return typeEffect
end)

return m
