-----------------------------------
-- Ability: Mijin Gakure
-- Mobs: Sacrifices user's life to deal damage to an enemy.
-- Players: Also reduces HP to (1) and grants 3 Utsusemi Shadows.
-- Obtained: Ninja Level 1
-- Recast Time: 1:00:00
-- Duration: Instant
-----------------------------------
require("scripts/globals/mobskills")
-----------------------------------

local m = Module:new("custom_job_abilities")

m:addOverride("xi.actions.abilities.mijin_gakure.onUseAbility", function(player, target, ability)
    if player:isPC() then
        local targetEffect = player:hasStatusEffect(xi.effect.COPY_IMAGE)
        local dmg          = player:getHP() * 0.8 + player:getMainLvl() / 0.5
        local resist       = xi.mobskills.applyPlayerResistance(player, nil, target, player:getStat(xi.mod.INT)-target:getStat(xi.mod.INT), 0, xi.element.NONE)

        if player:hasStatusEffect(xi.effect.THIRD_EYE) then
            player:delStatusEffect(xi.effect.THIRD_EYE)
        end

        -- Has shadows.
        if targetEffect then
            local effectPower = player:getStatusEffect(xi.effect.COPY_IMAGE):getPower()

            -- Power is low.
            if effectPower < 3 then
                player:delStatusEffectSilent(xi.effect.COPY_IMAGE)
                player:addStatusEffectEx(xi.effect.COPY_IMAGE, 446, 2, 0, 900, 0, 3)
            end

        -- Doesn't have shadows.
        else
            player:addStatusEffectEx(xi.effect.COPY_IMAGE, 446, 2, 0, 900, 0, 3)
        end

        -- Reduce HP to 1, no matter what.
        player:setHP(1)

        -- Apply damage to target.
        dmg = dmg * resist
        dmg = utils.stoneskin(target, dmg)

        target:takeDamage(dmg, player, xi.attackType.SPECIAL, xi.damageType.ELEMENTAL)

        return dmg

    -- Not players.
    else
        super(player, target, ability)
    end
end)

return m
