-----------------------------------
-- Geomancer - Cardinal Chant
-- Bonus elemental affinity for cardinal direction
-----------------------------------
require('modules/module_utils')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new('geo_cardinal_chant')

local directions =
{
    { xi.element.ICE,    240, 256 }, -- E  (  0)
    { xi.element.ICE,      0,  16 }, -- E  (  0)
    { xi.element.WIND,    16,  48 }, -- SE ( 32)
    { xi.element.EARTH,   48,  80 }, -- S  ( 64)
    { xi.element.THUNDER, 80, 112 }, -- SW ( 96)
    { xi.element.WATER,  112, 144 }, -- W  (128)
    { xi.element.FIRE,   144, 176 }, -- NW (160)
    { xi.element.LIGHT,  176, 208 }, -- N  (192)
    { xi.element.DARK,   208, 240 }, -- NE (224)
}

local tierBonus =
{
    { dmg = 0.05, macc =  5 }, -- Cardinal Chant I   (GEO 25)
    { dmg = 0.10, macc = 10 }, -- Cardinal Chant II  (GEO 45)
    { dmg = 0.15, macc = 15 }, -- Cardinal Chant III (GEO 65)
}

function getGeoDirectionBonus(caster, target, spellElement, bonusAmount)
    local angle = utils.getWorldRotation(caster:getPos(), target:getPos())

    for k, element in pairs(directions) do
        if
            element[1] == spellElement and
            angle > element[2] and
            angle < element[3]
        then

            if caster:hasStatusEffect(xi.effect.COLLIMATED_FERVOR) then
                -- Can't be deleted immediately, as the function is called multiple times (?)
                caster:timer(300, function(casterArg)
                    casterArg:delStatusEffect(xi.effect.COLLIMATED_FERVOR)
                end)

                return bonusAmount * 1.5
            else
                return bonusAmount
            end
        end
    end

    return 0
end

m:addOverride("xi.spells.damage.calculateMagicBonusDiff", function(caster, target, spellId, skillType, spellElement)
    local total = super(caster, target, spellId, skillType, spellElement)

    if caster:getMainJob() == xi.job.GEO then
        local tier = caster:getMod(xi.mod.CARDINAL_CHANT)

        if tier > 0 then
            total = total + getGeoDirectionBonus(caster, target, spellElement, tierBonus[tier].dmg)
        end
    end

    return total
end)

m:addOverride("xi.combat.magicHitRate.calculateActorMagicAccuracy", function(actor, target, spellGroup, skillType, spellElement, statUsed, bonusMacc)
    local total = super(actor, target, spellGroup, skillType, spellElement, statUsed, bonusMacc)

    if actor:getMainJob() == xi.job.GEO then
        local tier = actor:getMod(xi.mod.CARDINAL_CHANT)

        if tier > 0 then
            total = total + getGeoDirectionBonus(actor, target, spellElement, tierBonus[tier].macc)
        end
    end

    return total
end)

xi.module.ensureTable("xi.actions.abilities.collimated_fervor")

m:addOverride("xi.actions.abilities.collimated_fervor.onAbilityCheck", function(player, target, ability)
    return 0, 0
end)

m:addOverride("xi.actions.abilities.collimated_fervor.onUseAbility", function(player, target, ability)
    player:addStatusEffect(xi.effect.COLLIMATED_FERVOR, 1, 0, 60)
end)

return m
