-----------------------------------
-- Exudation
-- Custom WS - mimics Mythic Boon weapon skill
-- Exclusive to Idris
-----------------------------------
require('scripts/globals/aftermath')
require('scripts/globals/weaponskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('exudation_ws')

xi.module.ensureTable('xi.actions.weaponskills.exudation')

m:addOverride ('xi.actions.weaponskills.exudation.onUseWeaponSkill', function(player, target, wsID, tp, primary, action, taChar)
    local weaponskill_object = {}
    local params = {}
    params.numHits = 1
    params.ftpMod = { 5.5, 5.6, 5.7 }
    params.int_wsc = 0.95
    params.mnd_wsc = 0.95
    params.atkVaries = { 1.25, 1.25, 1.25 }

    if xi.settings.main.USE_ADOULIN_WEAPON_SKILL_CHANGES then
        params.ftpMod = { 2.5, 4.0, 7.0 }
        params.mnd_wsc = 0.7
    end

    xi.aftermath.addStatusEffect(player, tp, xi.slot.MAIN, xi.aftermath.type.MYTHIC)

    local damage, criticalHit, tpHits, extraHits = xi.weaponskills.doPhysicalWeaponskill(player, target, wsID, params, tp, action, primary, taChar)

    local mpRestorePercentage = 0.15
    if tp >= 2000 and tp < 3000 then
        mpRestorePercentage = 0.20
    elseif tp >= 3000 then
        mpRestorePercentage = 0.25
    end

    player:addMP(damage * mpRestorePercentage)

    return tpHits, extraHits, criticalHit, damage
end)

return m
