-----------------------------------
-- Custom items for Job Abilities
-----------------------------------
require("modules/module_utils")
require("scripts/globals/job_utils/dragoon")
-----------------------------------
local m = Module:new("custom_ja_items")

local items =
{
    VERUTUM = 22281,
}

local angonItems =
{
    [xi.item.ANGON] =
    {
        duration = 15,   -- Base: 30 seconds (1 merit)
        consumed = true, -- Is consumable ammo
        amount   = 20,   -- Debuff power applied
    },

    [items.VERUTUM] =
    {
        duration = 45,    -- Base: 60 seconds (1 merit)
        consumed = false, -- Is not consumable ammo
        amount   = 20,    -- Debuff power applied
        bonus    =
        {
            -- Effect, power, duration
            target = { xi.effect.WEIGHT, 20, 30 },
            player = { xi.effect.FLEE,   40, 15 },
        }
    },
}

m:addOverride("xi.job_utils.dragoon.abilityCheckAngon", function(player, target, ability)
    local equippedID = player:getEquipID(xi.slot.AMMO)

    for itemID, item in pairs(angonItems) do
        if equippedID == itemID then
            return 0, 0
        end
    end

    return xi.msg.basic.CANNOT_PERFORM, 0
end)

m:addOverride("xi.job_utils.dragoon.useAngon", function(player, target, ability)
    local equippedID = player:getEquipID(xi.slot.AMMO)
    local angonType  = angonItems[equippedID]
    local typeEffect = xi.effect.DEFENSE_DOWN
    local duration   = angonType.duration + player:getMerit(xi.merit.ANGON) -- Merits provide +15

    if not target:addStatusEffect(typeEffect, 20, 0, duration) then
        ability:setMsg(xi.msg.basic.MAGIC_NO_EFFECT)
    end

    if angonType.bonus ~= nil then
        -- Apply bonus effect to target if defined
        if angonType.bonus.target ~= nil then
            target:addStatusEffect(angonType.bonus.target[1], angonType.bonus.target[2], 0, angonType.bonus.target[3])
        end

        -- Apply bonus effect to player if defined
        if angonType.bonus.player ~= nil then
            player:addStatusEffect(angonType.bonus.player[1], angonType.bonus.player[2], 0, angonType.bonus.player[3])
        end
    end

    target:updateClaim(player)

    if angonType.consumed then
        player:removeAmmo()
    end

    return typeEffect
end)

return m
