-----------------------------------
-- HELM Ventures
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_ventures_helm")

cexi                              = cexi or {}
cexi.ventures                     = cexi.ventures or {}
cexi.ventures.harvesting          = cexi.ventures.harvesting or {}
cexi.ventures.excavation          = cexi.ventures.excavation or {}
cexi.ventures.logging             = cexi.ventures.logging or {}
cexi.ventures.mining              = cexi.ventures.mining or {}
cexi.ventures.helm                =
{
    "harvesting",
    "excavation",
    "logging",
    "mining",
}

cexi.ventures.harvesting.ventures =
{
    {
        name = "Low Tier",
        exp  = 1000,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "West_Sarutabaruta",
                {
                    {   833, "Moko Grass",      1 },
                    {  2713, "Dyer's Woad",     2 },
                    {  1845, "Red Moko Grass",  3 },
                    {   951, "Wijnruit",        5 },
                    {  1524, "Fresh Mugwort",  10 },
                },
            },
            {
                "Giddeus",
                {
                    {  2713, "Dyer's Woad",     1 },
                    {   834, "Saruta Cotton",   2 },
                    {  1522, "Fresh Marjoram",  3 },
                    {  1982, "King Locust",     5 },
                    {  1524, "Fresh Mugwort",  10 },
                },
            },
        },
    },
    {
        name = "Mid Tier",
        exp  = 1250,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "West_Sarutabaruta_[S]",
                {
                    {  1522, "Fresh Marjoram",  1 },
                    {  5651, "Burdock",         2 },
                    {  1845, "Red Moko Grass",  3 },
                    {  1524, "Fresh Mugwort",   5 },
                    {  1982, "King Locust",     5 },
                },
            },
            {
                "Pashhow_Marshlands",
                {
                    {  846, "Insect Wing",      1 },
                    {  920, "Malboro Vine",     2 },
                    {  930, "Beastman Blood",   3 },
                    {  949, "Rain Lily",        5 },
                    { 4515, "Copper Frog",     10 },
                },
            },
            {
                "Crawlers_Nest",
                {
                    {   839, "Crawler Cocoon",  1 },
                    {   912, "Beehive Chip",    2 },
                    {   846, "Insect Wing",     3 },
                    {  4357, "Crawler Egg",     5 },
                    {  4508, "Royal Jelly",    10 },
                },
            },
        },
    },
    {
        name = "High Tier",
        exp  = 1500,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "Bhaflau_Thickets",
                {
                    {  2295, "Mohbwa Grass",     1 },
                    {  2270, "Coffee Cherries",  2 },
                    {  2236, "Simsim",           3 },
                    {  2645, "Eastern Ginger",   5 },
                    {  4388, "Eggplant",         5 },
                },
            },
            {
                "Wajaom_Woodlands",
                {
                    {  1522, "Fresh Marjoram",   1 },
                    {  2164, "Peph. Hive Chip",  2 },
                    {  2156, "Imp. Tea Leaves",  3 },
                    {  1524, "Fresh Mugwort",    5 },
                    {   951, "Wijnruit",         5 },
                },
            },
            {
                "Grauberg_[S]",
                {
                    {  5651, "Burdock",          1 },
                    {   833, "Moko Grass",       2 },
                    {   573, "Vegetable Seeds",  3 },
                    {   575, "Grain Seeds",      3 },
                    {  5907, "Winterflower",     3 },
                },
            },
        },
    },
}

cexi.ventures.excavation.ventures =
{
    {
        name = "Low Tier",
        exp  = 1000,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "Tahrongi_Canyon",
                {
                    {   880, "Bone Chip",       1 },
                    {   898, "Chicken Bone",    2 },
                    {   891, "Bat Fang",        3 },
                    {   885, "Turtle Shell",    5 },
                    {   896, "Scorpion Shell",  5 },
                },
            },
            {
                "Korroloka_Tunnel",
                {
                    {   864, "Fish Scales",     1 },
                    {  1985, "Helmet Mole",     2 },
                    { 17395, "Lugworm",         3 },
                    {   881, "Crab Shell",      5 },
                    {   887, "Coral Fragment", 10 },
                },
            },
        },
    },
    {
        name = "Mid Tier",
        exp  = 1250,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "Maze_of_Shakhrami",
                {
                    { 17396, "Little Worm",     1 },
                    {   891, "Bat Fang",        2 },
                    {   893, "Giant Femur",     3 },
                    {   897, "Scorpion Claw",   5 },
                    {  1888, "Silica",         10 },
                },
            },
            {
                "FeiYin",
                {
                    { 17296, "Pebble",          1 },
                    {   954, "Magic Pot Shard", 2 },
                    {   955, "Golem Shard",     3 },
                    {   914, "Mercury",         5 },
                    {   931, "Cermet Chunk",   10 },
                },
            },
            {
                "Aydeewa_Subterrane",
                {
                    { 17296, "Pebble",          1 },
                    {  2171, "Colibri Beak",    2 },
                    {  1307, "Silver Leaf",     3 },
                    {  2147, "Marid Tusk",      5 },
                    {  1196, "Qiqirn Cape",    10 },
                },
            },
        },
    },
    {
        name = "High Tier",
        exp  = 1500,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "Attohwa_Chasm",
                {
                    {   880, "Bone Chip",       1 },
                    {   898, "Chicken Bone",    2 },
                    {   891, "Bat Fang",        3 },
                    { 17396, "Little Worm",     5 },
                    {  1236, "Cactus Stems",   10 },
                },
            },
            {
                "Arrapago_Reef",
                {
                    { 18235, "Corsair Bullet",  1 },
                    {  2157, "Imp Horn",        2 },
                    {   947, "Firesand",        3 },
                    {  5284, "Old Bullet Box",  5 },
                    {  2154, "Orobon Lure",    10 },
                },
            },
            {
                "Labyrinth_of_Onzozo",
                {
                    {   880, "Bone Chip",       1 },
                    {   897, "Scorpion Claw",   2 },
                    {  1123, "Manticore Fang",  3 },
                    {   927, "Coeurl Whisker",  5 },
                    {  1122, "Wyvern Skin",    10 },
                },
            },
        },
    },
}

cexi.ventures.logging.ventures =
{
    {
        name = "Low Tier",
        exp  = 1000,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "East_Ronfaure",
                {
                    {   698, "Ash Log",         1 },
                    {   691, "Maple Log",       2 },
                    {   696, "Yew Log",         3 },
                    {   639, "Chestnut",        5 },
                    {   694, "Chestnut Log",    5 },
                },
            },
            {
                "Ghelsba_Outpost",
                {
                    {   688, "Arrowwood Log",   1 },
                    {   698, "Ash Log",         2 },
                    {   691, "Maple Log",       2 },
                    {   695, "Willow Log",      3 },
                    {   697, "Holly Log",       5 },
                },
            },
            {
                "Buburimu_Peninsula",
                {
                    {   689, "Lauan Log",       1 },
                    {  4445, "Yagudo Cherry",   2 },
                    {  4503, "Buburimu Grape",  3 },
                    {   574, "Fruit Seeds",     5 },
                    {   701, "Rosewood Log",   10 },
                },
            },
            {
                "Bibiki_Bay",
                {
                    {   697, "Holly Log",        1 },
                    {   689, "Lauan Log",        2 },
                    {   701, "Rosewood Log",     3 },
                    {   702, "Ebony Log",        5 },
                    {   844, "Phoenix Feather", 10 },
                },
            },
        },
    },
    {
        name = "Mid Tier",
        exp  = 1250,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "East_Ronfaure_[S]",
                {
                    {   691, "Maple Log",       1 },
                    {   698, "Ash Log",         2 },
                    {  5661, "Walnut",          3 },
                    {   574, "Fruit Seeds",     5 },
                    {  2532, "Teak Log",       10 },
                },
            },
            {
                "Jugner_Forest",
                {
                    {   688, "Arrowwood Log",   1 },
                    {   693, "Walnut Log",      2 },
                    {   698, "Ash Log",         3 },
                    {   695, "Willow Log",      5 },
                    {   923, "Dryad Root",     10 },
                },
            },
            {
                "Yuhtunga_Jungle",
                {
                    {   688, "Arrowwood Log",   1 },
                    {   721, "Rattan Lumber",   2 },
                    {   689, "Lauan Log",       3 },
                    {   912, "Beehive Chip",    5 },
                    {  5662, "Dragon Fruit",   10 },
                },
            },
            {
                "Yhoator_Jungle",
                {
                    {   721, "Rattan Lumber",   1 },
                    {   688, "Arrowwood Log",   2 },
                    {   940, "Revival Root",    3 },
                    {   731, "Aquilaria Log",   5 },
                    {   700, "Mahogany Log",   10 },
                },
            },
        },
    },
    {
        name = "High Tier",
        exp  = 1500,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "Grauberg_[S]",
                {
                    {   696, "Yew Log",         1 },
                    {   694, "Chestnut Log",    1 },
                    {   690, "Elm Log",         2 },
                    {   698, "Ash Log",         3 },
                    {  4363, "Faerie Apple",    5 },
                },
            },
            {
                "Jugner_Forest_[S]",
                {
                    {   698, "Ash Log",         1 },
                    {  5661, "Walnut",          2 },
                    {   693, "Walnut Log",      3 },
                    {   699, "Oak Log",         5 },
                    {  2534, "Jacaranda Log",  10 },
                },
            },
            {
                "Caedarva_Mire",
                {
                    {   727, "Dogwood Log",     1 },
                    {  2213, "Pine Nuts",       2 },
                    {  2503, "Almond",          3 },
                    {   702, "Ebony Log",       5 },
                    {   729, "Bloodwood Log",  10 },
                },
            },
            {
                "Mamook",
                {
                    {   688, "Arrowwood Log",   1 },
                    {   727, "Dogwood Log",     2 },
                    {  2213, "Pine Nuts",       3 },
                    {  5566, "Date",            5 },
                    {   694, "Chestnut Log",   10 },
                },
            },
        },
    },
}

cexi.ventures.mining.ventures =
{
    {
        name = "Low Tier",
        exp  = 1000,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "Zeruhn_Mines",
                {
                    { 17296, "Pebble",          1 },
                    {   640, "Copper Ore",      2 },
                    {   641, "Tin Ore",         3 },
                    {  1984, "Snapping Mole",   5 },
                    {   736, "Silver Ore",     10 },
                },
            },
            {
                "Palborough_Mines",
                {
                    {   640, "Copper Ore",      1 },
                    {   642, "Zinc Ore",        2 },
                    { 17296, "Pebble",          3 },
                    {   643, "Iron Ore",        3 },
                    {   738, "Platinum Ore",    5 },
                },
            },
            {
                "Yughott_Grotto",
                {
                    {   642, "Zinc Ore",        1 },
                    {   641, "Tin Ore",         2 },
                    {   768, "Flint Stone",     3 },
                    {   736, "Silver Ore",      5 },
                    {   737, "Gold Ore",       10 },
                },
            },
            {
                "Ordelles_Caves",
                {
                    {   736, "Silver Ore",        1 },
                    {   928, "Bomb Ash",          2 },
                    {   750, "Silver Beastcoin",  3 },
                    {   936, "Rock Salt",         5 },
                    {   748, "Gold Beastcoin",    5 },
                },
            },
        },
    },
    {
        name = "Mid Tier",
        exp  = 1250,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "North_Gustaberg_[S]",
                {
                    {   642, "Zinc Ore",        1 },
                    {   640, "Copper Ore",      2 },
                    {   736, "Silver Ore",      3 },
                    {   644, "Mythril Ore",     5 },
                    {   738, "Platinum Ore",   10 },
                },
            },
            {
                "Gusgen_Mines",
                {
                    { 17296, "Pebble",          1 },
                    {   640, "Copper Ore",      2 },
                    {   642, "Zinc Ore",        3 },
                    {   645, "Darksteel Ore",   5 },
                    {   737, "Gold Ore",       10 },
                },
            },
            {
                "Oldton_Movalpolos",
                {
                    {  1654, "Igneous Rock",    1 },
                    {   643, "Iron Ore",        2 },
                    {   641, "Tin Ore",         3 },
                    {   568, "Goblin Die",      5 },
                    {   644, "Mythril Ore",    10 },
                },
            },
            {
                "Newton_Movalpolos",
                {
                    {   641, "Tin Ore",         1 },
                    {  1654, "Igneous Rock",    2 },
                    {   736, "Silver Ore",      3 },
                    {   642, "Zinc Ore",        5 },
                    {   678, "Aluminum Ore",   10 },
                },
            },
            {
                "Garlaige_Citadel_[S]",
                {
                    {   768, "Flint Stone",      1 },
                    {   928, "Bomb Ash",         1 },
                    {   678, "Aluminum Ore",     2 },
                    { 17316, "Bomb Arm",         5 },
                    {   896, "Scorpion Shell",   5 },
                },
            },
        },
    },
    {
        name = "High Tier",
        exp  = 1500,
        pts  = { 35, 50 },
        qty  = 40,
        list =
        {
            {
                "Grauberg_[S]",
                {
                    { 17296, "Pebble",          1 },
                    {  1155, "Iron Sand",       2 },
                    {  1124, "Wyvern Wing",     3 },
                    {   866, "Wyvern Scales",   5 },
                    {  3924, "Scholar Stone",  10 },
                },
            },
            {
                "Mount_Zhayolm",
                {
                    {   643, "Iron Ore",        1 },
                    {  1155, "Iron Sand",       2 },
                    {  2860, "Plumbago",        3 },
                    {  2160, "Troll Pauldron",  5 },
                    {  2161, "Troll Vambrace",  5 },
                },
            },
            {
                "Halvung",
                {
                    {  2417, "Aht Urhgan Brass",  1 },
                    {  2860, "Plumbago",          2 },
                    {  1108, "Sulfur",            3 },
                    {  2160, "Troll Pauldron",    5 },
                    {  2161, "Troll Vambrace",    5 },
                },
            },
            {
                "Ifrits_Cauldron",
                {
                    {   768, "Flint Stone",     1 },
                    {  2126, "Orpiment",        2 },
                    {   928, "Bomb Ash",        3 },
                    { 17316, "Bomb Arm",        5 },
                    {   645, "Darksteel Ore",  10 },
                },
            },
        },
    },
}

local helmCategories =
{
    { "(Low Tier)",  1 },
    { "(Mid Tier)",  2 },
    { "(High Tier)", 3 },
}

for _, helmName in pairs(cexi.ventures.helm) do
    local index = 1

    cexi.ventures[helmName].mapping    = cexi.ventures[helmName].mapping or {}
    cexi.ventures[helmName].categories = helmCategories

    for tierIndex, helmTier in pairs(cexi.ventures[helmName].ventures) do
        helmTier.box = 6345 -- goblin_gatherbox

        for areaIndex, areaInfo in pairs(helmTier.list) do
            cexi.ventures[helmName].mapping[index] = { tierIndex, areaIndex }
            areaInfo[3] = index
            index = index + 1
        end
    end
end

return m
