-----------------------------------
-- Ventures
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_ventures_fishing")

cexi                           = cexi or {}
cexi.ventures                  = cexi.ventures or {}
cexi.ventures.fishing          = cexi.ventures.fishing or {}
cexi.ventures.fishing.ventures =
{
    {
        name = "(0-19)",
        exp  = 500,
        lvl  = 10,
        pts  = { 15, 30 },
        box  = 5110, -- tiny_tacklebox
        list =
        {
            {  4443, "Cobalt Jellyfish", 22,  5 },
            {  5447, "Denizansi",        20,  5 },
            {  4360, "Bastore Sardine",  22,  9 },
            {  5449, "Hamsi",            20,  9 },
            {  4472, "Crayfish",         18,  7 },
            {  4401, "Moat Carp",        24, 11 },
            {  4500, "Greedie",          18, 14 },
            {  4403, "Yellow Globe",     20, 17 },
            {  4514, "Quus",             24, 19 },
        },
    },
    {
        name = "(20-39)",
        exp  = 750,
        lvl  = 20,
        pts  = { 25, 40 },
        box  = 5110, -- tiny_tacklebox
        list =
        {

            {  4289, "Forest Carp",     24, 20 },
            {  4379, "Cheval Salmon",   20, 21 },
            {  4361, "Nebimonite",      22, 27 },
            {  4426, "Tricolored Carp", 18, 27 },
            {  4464, "Pipira",          18, 29 },
            {  4483, "Tiger Cod",       20, 29 },
            {  4469, "Giant Catfish",   16, 31 },
            {  4428, "Dark Bass",       18, 33 },
            {  4481, "Ogre Eel",        20, 35 },
            {  4354, "Shining Trout",   22, 37 },
            {  4482, "Nosteau Herring", 18, 39 },
        },
    },
    {
        name = "(40-59)",
        exp  = 1000,
        lvl  = 40,
        pts  = { 35, 50 },
        box  = 5112, -- titanic_tacklebox
        list =
        {
            {  4385, "Zafmlug Bass",  20, 43 },
            {  4383, "Gold Lobster",  16, 46 },
            {  4429, "Black Eel",     18, 47 },
            {  5128, "Cone Calamary", 16, 48 },
            {  4470, "Icefish",       28, 49 },
            {  4291, "Sandfish",      28, 50 },
            {  4306, "Giant Donko",   16, 50 },
            {  4484, "Shall Shell",   24, 53 },
            {  4399, "Bluetail",      22, 55 },
            {  4427, "Gold Carp",     18, 56 },
            {  5459, "Sazanbaligi",   16, 56 },
        },
    },
    {
        name = "(60-79)",
        exp  = 1250,
        lvl  = 50,
        pts  = { 45, 60 },
        box  = 5112, -- titanic_tacklebox
        list =
        {
            {  4579, "Elshimo Newt",   22, 60 },
            {  4479, "Bhefhel Marlin", 18, 61 },
            {  4485, "Noble Lady",     20, 66 },
            {  4473, "Crescent Fish",  16, 69 },
            {  4288, "Zebra Eel",      16, 70 },
            {  4471, "Bladefish",      16, 71 },
            {  5130, "Tavnazian Goby", 24, 75 },
            {  5460, "Kayabaligi",     22, 75 },
            {  4451, "Silver Shark",   24, 76 },
        },
    },
    {
        name = "(80-99)",
        exp  = 1500,
        lvl  = 60,
        pts  = { 55, 70 },
        box  = 5112, -- titanic_tacklebox
        list =
        {
            {  4477, "Gavial Fish",    22, 81 },
            {  4461, "Bastore Bream",  24, 86 },
            {  5454, "Mercanbaligi",   24, 86 },
            {  4304, "Grimmonite",     18, 90 },
            {  5455, "Ahtapot",        18, 90 },
            {  4474, "Gigant Squid",   20, 91 },
            {  4454, "Emperor Fish",   18, 91 },
            {  5462, "Morinabaligi",   18, 91 },
            {  4384, "Black Sole",     18, 96 },
            {  5457, "Dil",            18, 96 },
            {  5817, "Tiger Shark",    16, 99 },
        },
    },
    {
        name = "(100+)",
        exp  = 1500,
        lvl  = 70,
        pts  = { 65, 80 },
        box  = 5112, -- titanic_tacklebox TODO: New box
        list =
        {
            {  4463, "Takitaro",          22, 101 }, -- Misareaux Coast (Cascade Edellaine)
            {  4475, "Sea Zombie",        14, 101 }, -- Ferry - Mhaura/Selbina - (Pirates Only)
            {  4476, "Titanictus",        18, 101 }, -- Ferry - Mhaura/Selbina (No Pirates)
            {  5140, "Kalkanbaligi",      20, 105 }, -- Ferry - Nashmau/Al Zahbi
            {  5137, "Turnabaligi",       22, 100 }, -- Wajaom Woodlands/Bhaflau Thickets
            {  4316, "Armored Pisces",    18, 108 }, -- Oldton Movalpolos (H-11) Center Pond
            {  4308, "Giant Chirai",      16, 110 }, -- The Boyahda Tree
            {  4309, "Cave Cherax",       16, 110 }, -- Kuftal Tunnel (I-6) Map 4 / Quicksand Caves (G-14) Fountain of Kings
            {  5134, "Mola Mola",         16, 110 }, -- Ferry - Mhaura/Al Zahbi
            {  5471, "Gerrothorax",       16, 110 }, -- Pashhow Marshlands (S) (E-5, Hoaxmarsh)
            {  5127, "Gugrusaurus",       16, 110 }, -- Ferry - Mhaura/Al Zahbi / Ferry - Mhaura/Selbina (Pirates) / Manaclipper (Purgonorgo Isle<->Sunset Docks)
            {  5129, "Lik",               16, 110 }, -- Lufaise Meadows (Leremieu Lagoon) / Phomiuna Aqueducts Map 2 (K-5)
            {  4305, "Ryugu Titan",       16, 110 }, -- Ferry - Mhaura/Selbina
            {  6371, "Quicksilver Blade", 16, 110 }, -- Ferry - Nashmau/Al Zahbi

            -- Unknown (Not Implemented)
            -- [5539] = "Hakuryu",           -- Beaucedine Glacier (Sea)

            -- Manaclipper (Not Implemented)
            -- [5120] = "Titanic Sawfish",   -- Manaclipper (Maliyakaleya Reef Route)

            -- WotG (Not Implemented)
            -- [5476] = "Abaia",             -- Jugner Forest (S) - Lake
            -- [5446] = "Red Bubble-Eye",    -- La Vaule (S) (L-9)
            -- [5468] = "Matsya",            -- Vunkerl Inlet (S) (east bridges only!)

            -- Abyssea (Not Implemented)
            -- [5540] = "Kokuryu",           -- Abyssea - Vunkerl
            -- [5538] = "Sekiryu",           -- Abyssea - Altepa
            -- [5537] = "Soryu",             -- Abyssea - Misareaux
            -- [6375] = "Phantom Serpent",   -- Abyssea - Misareaux
            -- [5814] = "Crocodilos",        -- Abyssea - La Theine (H-7) Conflux #4 Large Pond

            -- Adoulin (Not Implemented)
            -- [5997] = "Shen",              -- Yahse Hunting Grounds
            -- [6338] = "Cameroceras",       -- Sih Gates
            -- [6373] = "Ancient Carp",      -- Moh Gates
            -- [6376] = "Tusoteuthis Longa", -- Dho Gates (F/G-12)
            -- [6146] = "Remora",            -- Woh Gates (I-11)
            -- [6372] = "Lord of Ulbuka",    -- Cirdas Caverns (I-7)

            -- Escha (Not Implemented)
            -- [6489] = "Far East Puffer",   -- Reisenjima
        },
    },
}

cexi.ventures.fishing.categories =
{
    { "(0-19)",  1, 5110 }, -- Lv10+
    { "(20-39)", 2, 5110 }, -- Lv20+
    { "(40-59)", 3, 5112 }, -- Lv40+
    { "(60-79)", 4, 5112 }, -- Lv50+
    { "(80-99)", 5, 5112 }, -- Lv60+
    { "(100+)",  6, 5112 }, -- 100+
}

cexi.ventures.fishing.mapping = {}
cexi.ventures.fishing.list    = {}
cexi.ventures.fishing.fish    = {}

local index = 1

for tierIndex, venture in pairs(cexi.ventures.fishing.ventures) do
    for itemIndex, item in pairs(venture.list) do
        cexi.ventures.fishing.mapping[index] = { tierIndex, itemIndex }

        item[5] = item[4]
        item[4] = index
        index = index + 1

        -- Store fish ID in sequential list and store name for lookup by ID
        table.insert(cexi.ventures.fishing.list, item[1])
        cexi.ventures.fishing.fish[item[1]] = item[2]
    end
end

return m
