-----------------------------------
-- Ventures
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_ventures_exp")

cexi                       = cexi or {}
cexi.ventures              = cexi.ventures or {}
cexi.ventures.exp          = cexi.ventures.exp or {}
cexi.ventures.exp.ventures =
{
    -- (10-19)
    {
        {
            area = "Valkurm_Dunes",
            qty  = 15,
            exp  = 2800,
            pts  = { 45, 60 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Sand_Bats",           -- 12-15
                "Sand_Hare",           -- 15-18
                "Hill_Lizard",         -- 15-19
                "Goblin_Ambusher",     -- 17-20
                "Goblin_Butcher",      -- 17-20
                "Goblin_Tinkerer",     -- 17-20
                "Snipper",             -- 18-22
                "Ghoul",               -- 18-24
                "Brutal_Sheep",        -- 20-23
                "Damselfly",           -- 20-23
                "Thread_Leech",        -- 21-25
                --[[
                "Goblin_Gambler",      -- 22-25
                "Goblin_Leecher",      -- 22-25
                ]]
                "Goblin_Mugger",       -- 22-25
                "Beach_Pugil",         -- 23-26
            },
        },
        {
            area = "Buburimu_Peninsula",
            qty  = 15,
            exp  = 3000,
            pts  = { 45, 60 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Mighty_Rarab",        -- 15-18
                "Sylvestre",           -- 15-19
                "Goblin_Ambusher",     -- 17-20
                "Goblin_Butcher",      -- 17-20
                "Goblin_Tinkerer",     -- 17-20
                "Snipper",             -- 18-22
                "Carnivorous_Crawler", -- 20-23
                "Zu",                  -- 20-24
                "Bull_Dhalmel",        -- 20-24
                "Ghoul",               -- 20-24
                "Goblin_Gambler",      -- 22-25
                "Goblin_Leecher",      -- 22-25
                "Goblin_Mugger",       -- 22-25
            },
        },
        {
            area = "Meriphataud_Mountains",
            qty  = 15,
            exp  = 3000,
            pts  = { 45, 60 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Night_Bats",           -- 13-16
                "Wandering_Sapling",    -- 13-16
                "Black_Bat",            -- 15-18
                "Jubjub",               -- 15-18
                "Goblin_Ambusher",      -- 16-20
                "Goblin_Butcher",       -- 16-20
                "Goblin_Tinkerer",      -- 16-20
                "Crane_Fly",            -- 18-21
                "Hill_Lizard",          -- 19-22
                "Stag_Beetle",          -- 20-23
                "Goblin_Leecher",       -- 21-25
                "Goblin_Mugger",        -- 21-25
                "Goblin_Gambler",       -- 21-25
                --[[
                "Yagudo_Priest",        -- 21-25
                "Yagudo_Theologist",    -- 21-25
                "Yagudo_Votary",        -- 21-25
                ]]
                "Raptor",               -- 21-25
                "Coeurl",               -- 22-25
                "Boggart",              -- 25-27
                "Axe_Beak",             -- 25-28
            },
        },
        {
            area = "Pashhow_Marshlands",
            qty  = 15,
            exp  = 3000,
            pts  = { 45, 60 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Bog_Bunny",           -- 13-16
                "Night_Bats",          -- 13-16
                "Black_Bat",           -- 15-18
                "Water_Wasp",          -- 15-18
                "Goblin_Ambusher",     -- 16-20
                "Goblin_Butcher",      -- 16-20
                "Goblin_Tinkerer",     -- 16-20
                "Greater_Quadav",      -- 16-20
                "Onyx_Quadav",         -- 16-20
                "Veteran_Quadav",      -- 16-20
                "Land_Pugil",          -- 17-20
                "Snipper",             -- 17-20
                "Gadfly",              -- 18-21
                "Thread_Leech",        -- 19-22
                "Carnivorous_Crawler", -- 20-23
                --[[
                "Brass_Quadav",        -- 20-26
                "Copper_Quadav",       -- 20-26
                "Old_Quadav",          -- 20-26
                ]]
                "Goblin_Gambler",      -- 21-25
                "Goblin_Leecher",      -- 21-25
                "Goblin_Mugger",       -- 21-25
                "Marsh_Funguar",       -- 21-25
                "Goobbue",             -- 22-25
            },
        },
        {
            area = "West_Sarutabaruta_[S]",
            qty  = 15,
            exp  = 2500,
            pts  = { 45, 60 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Tiny_Lycopodium",           -- 10-12
                "Savanna_Rarab",             -- 13-15
                "Bumblebee",                 -- 15-17
                "Crawler",                   -- 18-21
                "Carrion_Crow",              -- 22-25
                "River_Crab",                -- 22-25
            },
        },
        {
            area = "East_Ronfaure_[S]",
            qty  = 15,
            exp  = 2500,
            pts  = { 45, 60 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Carrion_Worm",           -- 10-13
                "Forest_Hare",            -- 11-15
                "Ding_Bats",              -- 12-14
                "River_Crab",             -- 12-14
                "Mouse_Bat",              -- 12-15
                "Pugil",                  -- 14-17
                "Wild_Sheep",             -- 16-18
                "Scarab_Beetle",          -- 21-23
            },
        },
    },

    -- (20-29)
    {
        {
            area = "Batallia_Downs",
            qty  = 20,
            exp  = 4000,
            pts  = { 50, 65 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Stalking_Sapling",     -- 20-24
                "May_Fly",              -- 22-26
                "Clipper",              -- 23-25
                "Ba",                   -- 25-28
                "Goblin_Bounty_Hunter", -- 25-28
                "Goblin_Gambler",       -- 26-30
                "Goblin_Mugger",        -- 26-30
                "Orcish_Cursemaker",    -- 26-30
                "Orcish_Fighter",       -- 26-30
                "Orcish_Serjeant",      -- 26-30
                "Sabertooth_Tiger",     -- 28-32
                "Goblin_Furrier",       -- 28-36
                "Goblin_Pathfinder",    -- 28-36
                "Goblin_Shaman",        -- 28-36
                "Goblin_Smithy",        -- 28-36
                "Orcish_Brawler",       -- 30-36
                "Orcish_Impaler",       -- 30-36
                "Orcish_Nightraider",   -- 30-36
                "Evil_Weapon",          -- 36-38
            },
        },
        {
            area = "Korroloka_Tunnel",
            qty  = 20,
            exp  = 3500,
            pts  = { 50, 65 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Land_Worm",        -- 20-25
                "Seeker_Bats",      -- 22-26
                "Combat",           -- 27-30
                "Huge_Spider",      -- 28-31
                "Thread_Leech",     -- 28-31
                "Clipper",          -- 29-32
                "Greater_Pugil",    -- 30-33
                "Lacerator",        -- 32
                "Spool_Leech",      -- 32
            },
        },
        {
            area = "Rolanberry_Fields",
            qty  = 20,
            exp  = 3800,
            pts  = { 50, 65 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Death_Wasp",        -- 22-26
                "Clipper",           -- 23-25
                "Moon_Bat",          -- 23-25
                "Poison_Leech",      -- 24-26
                "Berry_Grub",        -- 25-28
                "Thread_Leech",      -- 28-31
                "Brass_Quadav",      -- 26-30
                "Copper_Quadav",     -- 26-30
                "Goblin_Gambler",    -- 26-30
                "Goblin_Mugger",     -- 26-30
                "Old_Quadav",        -- 26-30
                "Wight",             -- 26-32
                "Goobbue_Farmer",    -- 28-32
                "Bronze_Quadav",     -- 30-36
                "Garnet_Quadav",     -- 30-36
                "Goblin_Furrier",    -- 30-36
                "Goblin_Pathfinder", -- 30-36
                "Goblin_Shaman",     -- 30-36
                "Goblin_Smithy",     -- 30-36
                "Silver_Quadav",     -- 30-36
                "Zircon_Quadav",     -- 30-36
                "Ochu",              -- 34-37
                "Evil_Weapon",       -- 36-38
            },
        },
        {
            area = "Sauromugue_Champaign",
            qty  = 20,
            exp  = 4000,
            pts  = { 50, 65 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Hill_Lizard",         -- 22-26
                "Moon_Bat",            -- 23-26
                "Diving_Beetle",       -- 25-28
                "Goblin_Gambler",      -- 26-30
                "Goblin_Leecher",      -- 26-30
                "Goblin_Mugger",       -- 26-30
                "Yagudo_Priest",       -- 26-30
                "Yagudo_Theologist",   -- 26-30
                "Yagudo_Votary",       -- 26-30
                "Sauromugue_Skink",    -- 28-32
                "Champaign_Coeurl",    -- 30-34
                "Goblin_Furrier",      -- 30-36 v
                "Goblin_Pathfinder",   -- 30-36 v
                "Goblin_Shaman",       -- 30-36 v
                "Goblin_Smithy",       -- 30-36 v
                "Yagudo_Drummer",      -- 30-36 v
                "Yagudo_Herald",       -- 30-36 v
                "Yagudo_Interrogator", -- 30-36 v
                "Tabar_Beak",          -- 34-37
                "Evil_Weapon",         -- 36-38
            },
        },
        {
            area = "Qufim_Island",
            qty  = 20,
            exp  = 3500,
            pts  = { 50, 65 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Land_Worm",            -- 25-27
                "Clipper",              -- 25-29
                "Dancing_Weapon",       -- 28-30
                "Greater_Pugil",        -- 38-30
                "Wight",                -- 28-30
                "Banshee",              -- 31-33
                "Goblin_Bounty_Hunter", -- 31-33
                "Acrophies",            -- 32-34
            },
        },
        {
            area = "Yuhtunga_Jungle",
            qty  = 20,
            exp  = 4200,
            pts  = { 50, 65 },
            box  = 5109, -- goblin_giftbox_(small)
            mobs =
            {
                "Yuhtunga_Mandragora", -- 30-33
                "Ivory_Lizard",        -- 32-35
                "Goblin_Furrier",      -- 32-37
                "Goblin_Smithy",       -- 32-37
                "Death_Jacket",        -- 33-37
                "Young_Opo-opo",       -- 34-36
                "Creek_Sahagin",       -- 34-38
                "River_Sahagin",       -- 34-38
                "Stream_Sahagin",      -- 34-38
                "Jungle_Coeurl",       -- 35-38
                "Soldier_Crawler",     -- 37-41
                "Goblin_Poacher",      -- 42-47
                "Goblin_Reaper",       -- 42-47
                "Goblin_Robber",       -- 42-47
            },
        },
    },

    -- (30-39)
    {
        {
            area = "Yhoator_Jungle",
            qty  = 20,
            exp  = 4800,
            pts  = { 55, 70 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Yhoator_Mandragora",   -- 35-37
                "White_Lizard",         -- 36-37
                "Yhoator_Wasp",         -- 37-40
                "Goblin_Pathfinder",    -- 35-39
                "Goblin_Shaman",        -- 35-39
                "Goblin_Smithy",        -- 35-39
                "Young_Opo-opo",        -- 40-44
                "Goblin_Reaper",        -- 41-45
                "Worker_Crawler",       -- 43-46
                "Big_Jaw",              -- 43-47
                "Goblin_Poacher",       -- 45-49
                "Goblin_Robber",        -- 45-49
                "Goblin_Trader",        -- 45-49
                "Master_Coeurl",        -- 47-50
            },
        },
        {
            area = "West_Sarutabaruta_[S]",
            qty  = 20,
            exp  = 4500,
            pts  = { 55, 70 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Savanna_Dhalmel",           -- 34-37 v
                "Hispid_Rarab",              -- 39-41 v (Custom level)
                "Toad",                      -- 42-44 v (Custom Level, was 49-51)
                "Poroggo_Gent",              -- 46-48 v (Custom Level, was 56-58)
            },
        },
        {
            area = "Sea_Serpent_Grotto",
            qty  = 20,
            exp  = 5000,
            pts  = { 55, 70 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Royal_Leech",               -- 35-38
                "Lake_Sahagin",              -- 36-39
                "Pond_Sahagin",              -- 36-39
                "Spring_Sahagin",            -- 36-39
                "Undead_Bats",               -- 36-39
                "Ironshell",                 -- 37-40
                "Ghast",                     -- 38-41
                "Ooze",                      -- 39-42
                "Brook_Sahagin",             -- 41-48
                "Rivulet_Sahagin",           -- 41-48
                "Vampire_Bat",               -- 42-45
            },
        },
        {
            area = "The_Sanctuary_of_ZiTah",
            qty  = 20,
            exp  = 4500,
            pts  = { 55, 70 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Lesser_Gaylas",        -- 39-42
                "Goobbue_Gardener",     -- 40-43
                "Ogrefly",              -- 41-44
                "Myxomycete",           -- 41-46
                "Goobbue_Parasite",     -- 42-45
                "Goblin_Poacher",       -- 42-46
                "Goblin_Reaper",        -- 42-46
                "Goblin_Robber",        -- 42-46
                "Goblin_Trader",        -- 42-46
                "Master_Coeurl",        -- 44-47
            },
        },
        {
            area = "Batallia_Downs_[S]",
            qty  = 20,
            exp  = 4500,
            pts  = { 55, 70 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Lycopodium",       -- 28-31
                "Sadfly",           -- 29-31
                "Stalking_Sapling", -- 31-34
                "Clipper",          -- 32-35
                "Ba",               -- 36-37
            },
        },
        {
            area = "Eastern_Altepa_Desert",
            qty  = 20,
            exp  = 4200,
            pts  = { 55, 70 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Giant_Spider",     -- 30-34
                "Sand_Beetle",      -- 36-40
                "Desert_Dhalmel",   -- 39-44
            },
        },
    },

    -- (40-49)
    {
        {
            area = "Western_Altepa_Desert",
            qty  = 20,
            exp  = 3500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Desert_Spider",            -- 40-44
                "Desert_Dhalmel",           -- 44-48
                "Desert_Beetle",            -- 47-51
                "Cactuar",                  -- 48-53
                "Antican_Essedarius",       -- 47-51
                "Antican_Eques",            -- 45-49
                "Antican_Retiarius",        -- 45-49
                "Goblin_Bouncer",           -- 51-55
                "Goblin_Hunter",            -- 51-55
                "Goblin_Welldigger",        -- 51-55
                "Goblin_Enchanter",         -- 52-55
                "Tulwar_Scorpion",          -- 53-56
                "Desert_Manticore",         -- 52-55
                "Antican_Hoplomachus",      -- 54-58
                "Antican_Lanista",          -- 54-58
                "Antican_Secutor",          -- 54-58
            },
        },
        {
            area = "East_Ronfaure_[S]",
            qty  = 20,
            exp  = 4500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Colibri",                -- 45-47
                "Ladybug",                -- 45-47
                "Giant_Spider",           -- 50-52
                "Goblins_Ladybug",        -- 52-54
                "Djinn",                  -- 53-55
                "Walking_Tree",           -- 54-56
            },
        },
        {
            area = "Rolanberry_Fields_[S]",
            qty  = 20,
            exp  = 4500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Death_Wasp",        -- 38-40
                "Death_Jacket",      -- 40-42
                "Clipper",           -- 43-45 v
                "Poison_Leech",      -- 44-47
                "Scabrous_Slug",     -- 45-47
                "Hawker",            -- 46-48
                "Coppercap",         -- 47-49 v
                "Berry_Grub",        -- 50-52
                "Goblin_Skirmisher", -- 50-52 (custom level)
                "Champion_Crawler",  -- 53-55
            },
        },
        {
            area = "Garlaige_Citadel",
            qty  = 20,
            exp  = 3500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Wingrats",         -- 40-42
                "Siege_Bat",        -- 40-43
                "Borer_Beetle",     -- 41-44
                "Fallen_Evacuee",   -- 42-43
                "Citadel_Bats",     -- 46-48
                "Demonic_Weapon",   -- 47-49
                "Fallen_Soldier",   -- 47-49
                "Warden_Beetle",    -- 48
                "Donjon_Bat",       -- 48
                "Fortalice_Bats",   -- 48
                "Kaboom",           -- 48
                "Funnel_Bats",      -- 51-55
                "Explosure",        -- 52-53
                "Fallen_Officer",   -- 52-55
                "Chamber_Beetle",   -- 56-58
            },
        },
        {
            area = "Batallia_Downs_[S]",
            qty  = 20,
            exp  = 4500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Tsetse_Fly",       -- 44-46
                "Smilodon",         -- 46-48
                "Forester_Beetle",  -- 47-50
            },
        },
        {
            area = "Crawlers_Nest",
            qty  = 20,
            exp  = 3500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Death_Jacket",     -- 40-42
                "Worker_Crawler",   -- 40-44
                "Maze_Lizard",      -- 41-43
                "Caveberry",        -- 42-44
                "Killer_Mushroom",  -- 45-47
                "Nest_Beetle",      -- 45-47
                "Soldier_Crawler",  -- 47-49
                "Soul_Stinger",     -- 48-50
                "Wespe",            -- 48-50
                "Labyrinth_Lizard", -- 49-51
                "Witch_Hazel",      -- 50-52
                "Hornfly",          -- 50-53
                "Exoray",           -- 51-54
                "Blazer_Beetle",    -- 52-54
                "Rumble_Crawler",   -- 53-55
            },
        },
        {
            area = "Labyrinth_of_Onzozo",
            qty  = 20,
            exp  = 4500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Labyrinth_Leech",  -- 45-48
                "Labyrinth_Leech",  -- 45-48
                "Cockatrice",       -- 50-53
                "Mushussu",         -- 51-57
                "Goblin_Poacher",   -- 46-49
                "Goblin_Reaper",    -- 46-49
                "Goblin_Robber",    -- 46-49
                "Goblin_Trader",    -- 46-49
                "Flying_Manta",     -- 55-59
            },
        },
        {
            area = "Sauromugue_Champaign_[S]",
            qty  = 20,
            exp  = 4500,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Diving_Beetle",        -- 44-47
                "Hill_Lizard",          -- 45-48
                "Lynx",                 -- 46-48
                "Sauromugue_Skink",     -- 51-53
                "Tabar_Beak",           -- 52-55
                "Goblin_Toxophilite",   -- 53-55
                "Goblin_Grenadier",     -- 53-55
                "Goblin_Flagman",       -- 53-55
                "Goblin_Guerrilla",     -- 53-55
                "Gouger_Beetle",        -- 56-58
            },
        },
        {
            area = "Gustav_Tunnel",
            qty  = 20,
            exp  = 4000,
            pts  = { 60, 75 },
            box  = 5111, -- goblin_giftbox_(medium)
            mobs =
            {
                "Hell_Bat",         -- 44-48
                "Hawker",           -- 45-48
                "Labyrinth_Leech",  -- 45-48
                "Goblin_Poacher",   -- 46-49
                "Goblin_Reaper",    -- 46-49
                "Goblin_Robber",    -- 46-49
                "Greater_Gaylas",   -- 46-49
                "Labyrinth_Lizard", -- 46-49
                "Makara",           -- 46-49
            },
        },
    },
    -- (50-59)
    {
        {
            area = "Rolanberry_Fields_[S]",
            qty  = 20,
            exp  = 6000,
            pts  = { 65, 80 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Champion_Crawler", -- 53-55
                "Dragonfly",        -- 58-60
                "Goobbue_Farmer",  -- 59-61 v
                "Worker_Crawler",   -- 60-62
--                "Chigoe",           -- 59-61
            },
        },
        {
            area = "Bostaunieux_Oubliette",
            qty  = 20,
            exp  = 4500,
            pts  = { 65, 80 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Funnel_Bats",      -- 52-55
                "Werebat",          -- 55-59
                "Hecatomb_Hound",   -- 59-61
                "Haunt",            -- 60-63
            },
        },
        {
            area = "Quicksand_Caves",
            qty  = 20,
            exp  = 4500,
            pts  = { 65, 80 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Sand_Spider",          -- 51-55
                "Helm_Beetle",          -- 51-58
                "Sand_Eater",           -- 51-59
                "Antican_Hastatus",     -- 52-59
                "Antican_Princeps",     -- 52-59
                "Antican_Signifer",     -- 52-59
                "Sabotender_Bailaor",   -- 52-59
                "Sand_Lizard",          -- 56-59
                "Girtab",               -- 62-65
            },
        },
        {
            area = "Crawlers_Nest",
            qty  = 20,
            exp  = 5000,
            pts  = { 65, 80 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Wespe",            -- 55-57
                "Dragonfly",        -- 55-58
                "Helm_Beetle",      -- 59-62
                "Crawler_Hunter",   -- 60-62
                "Knight_Crawler",   -- 60-63
            },
        },
        {
            area = "Kuftal_Tunnel",
            qty  = 20,
            exp  = 5000,
            pts  = { 65, 80 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Cave_Worm",            -- 60-63
                "Robber_Crab",          -- 60-63
                "Sand_Lizard",          -- 61-64
                "Recluse_Spider",       -- 63-66
                "Haunt",                -- 63-66
                "Sabotender_Sediendo",  -- 64-67
                "Deinonychus",          -- 65-68
            },
        },
    },
    -- (60-69)
    {
        {
            area = "The_Boyahda_Tree",
            qty  = 20,
            exp  = 4750,
            pts  = { 70, 85 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Bark_Spider",       -- 60-63
                "Death_Cap",         -- 60-63
                "Robber_Crab",       -- 62-66
                "Mourioche",         -- 62-66
                "Knight_Crawler",    -- 62-67
                "Moss_Eater",        -- 62-67
                "Old_Goobbue",       -- 62-67
                "Skimmer",           -- 72-74
                "Korrigan",          -- 72-75
                "Processionaire",    -- 72-75
                "Steelshell",        -- 73-76
                "Elder_Goobbue",     -- 74-77
                "Boyahda_Sapling",   -- 74-77
                "Darter",            -- 75-77  -- normally 75-78, module lowers to 77
                "Blood_Ball",        -- 75-77  -- normally 75-78, module lowers to 77
            },
        },
        {
            area = "Cape_Teriggan",
            qty  = 20,
            exp  = 4750,
            pts  = { 70, 85 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Beach_Bunny",          -- 62-65
                "Sand_Lizard",          -- 62-66
                "Robber_Crab",          -- 64-67
                "Velociraptor",         -- 66-69
                "Terror_Pugil",         -- 66-70
                "Goblin_Alchemist",     -- 65-68
                "Goblin_Bandit",        -- 65-68
                "Goblin_Mercenary",     -- 65-68
                "Goblin_Shepherd",      -- 65-68
                "Doom_Soldier",         -- 66-70
                "Doom_Mage",            -- 66-70
                "Sand_Cockatrice",      -- 71-74
            },
        },
        {
            area = "Bhaflau_Thickets",
            qty  = 20,
            exp  = 5500,
            pts  = { 70, 85 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Aht_Urhgan_Attercop",  -- 63-65
                "Lesser_Colibri",       -- 63-65
                "Ameretat",             -- 65-66 v(erified level range in database)
                "Treant_Sapling",       -- 66-68 v
                "Trolls_Automaton",     -- 70-71
                "Colibri",              -- 71-73 v
                "Troll_Sabreur",        -- 71-73
                "Troll_Shieldbearer",   -- 71-73
                "Troll_Surveillant",    -- 71-73
                "Date_Eruca",           -- 72-74 v
                "Olden_Treant",         -- 74-76
                "Colorful_Treant",      -- 74-76 v
            },
        },
        {
            area = "Aydeewa_Subterrane",
            qty  = 20,
            exp  = 6500,
            pts  = { 70, 85 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
--                "Fossorial_Flea",       -- 66-68
                "Treant_Sapling",       -- 66-69
                "Puktrap",              -- 67-69
                "Phlebotomic_Slug",     -- 67-70 v
                "Slime_Mold",           -- 67-70
                "Qiqirn_Enterpriser",   -- 68-70 v
                "Qiqirn_Lieuter",       -- 68-70 v
                "Mycohopper",           -- 68-70
                "Mold_Eater",           -- 69-71
                "Defoliator",           -- 69-72 v (custom, was 68-73)
                "Aydeewa_Diremite",     -- 71-74 v (custom, was 70-75)
                "Qiqirn_Archaeologist", -- 73-75 v (custom, was 70-75)
                "Qiqirn_Mosstrooper",   -- 73-75 v (custom, was 70-75)
                "Cave_Tiger",           -- 73-76
            },
        },
        {
            area = "Bibiki_Bay", -- Couple custom level changes here to make the camp viable for ventures, otherwise everything was level 71+
            qty  = 20,
            exp  = 4750,
            pts  = { 70, 85 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Tragopan",             -- 65-68 (custom level, previously 71-73 v)
                "Tropical_Rarab",       -- 68-70 (custom level, previously 73-76 v)
                "Tartarus_Eft",         -- 70-72 (custom level, previously 76-78 v)
                "Hobgoblin_Animalier",  -- 72-74 v
                "Hobgoblin_Fascinator", -- 72-74 v
                "Hobgoblin_Martialist", -- 72-74 v
                "Hobgoblin_Venerer",    -- 72-74 v
                "Catoblepas",           -- 75-77 (custom level, previously 76-80 v)
            },
        },
        {
            area = "Caedarva_Mire",
            qty  = 20,
            exp  = 6500,
            pts  = { 70, 85 },
            box  = 6264, -- goblin_giftbox_(large)
            mobs =
            {
                "Treant_Sapling",       -- 62-64 v (custom level, previously 61-64 v)
                "Caedarva_Leech",       -- 63-65 v
                "Puktrap",              -- 64-66 v
                "Oil_Slick",            -- 65-68 v
                "Oderly_Imp",           -- 66-68 (custom level, previously 63-68 v)
                "Marsh_Murre",          -- 66-68 (custom level, previously 64-68 v)
                "Qiqirn_Rock_Hound",    -- 67-69 v
                "Qiqirn_Mireguide",     -- 67-69 v
                "Wild_Karakul",         -- 68-70 v
                "Mature_Treant",        -- 70-72 v
                "Ephramadian_Shade",    -- 75-77 v
                "Reserve_Draugar",      -- 73-74 v
                "Lamia_Fatedealer",     -- 73-75 v
                "Jnun",                 -- 75-77 (custom level, previously 72-77 v)
            },
        },
    },
}

cexi.ventures.exp.categories =
{
    { "(10-19)", 1, 5109 },
    { "(20-29)", 2, 5109 },
    { "(30-39)", 3, 5111 },
    { "(40-49)", 4, 5111 },
    { "(50-59)", 5, 6264 },
    { "(60-69)", 6, 6264 },
}

cexi.ventures.exp.mapping = {}

local index = 1

for rangeIndex, rangeInfo in pairs(cexi.ventures.exp.ventures) do
    for ventureIndex, ventureInfo in pairs(rangeInfo) do
        cexi.ventures.exp.mapping[index] = { rangeIndex, ventureIndex }
        ventureInfo.index = index
        index = index + 1
    end
end

return m
