-----------------------------------
-- Ventures
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_ventures_dynamis")

cexi                           = cexi or {}
cexi.ventures                  = cexi.crystal_warrior or {}
cexi.ventures.dynamis          = cexi.ventures.dynamis or {}
cexi.ventures.dynamis.ventures =
{
    {
        {
            area  = "Dynamis-San_dOria",
            qty   = 20,
            exp   = 4000,
            pts   = { 90, 110 },
            box   = { 1452, 23, 30 },
            mobs  =
            {
                "Vanguard_Amputator",
                "Vanguard_Backstabber",
                "Vanguard_Bugler",
                "Vanguard_Dollmaster",
                "Vanguard_Footsoldier",
                "Vanguard_Grappler",
                "Vanguard_Gutslasher",
                "Vanguard_Hawker",
                "Vanguard_Impaler",
                "Vanguard_Mesmerizer",
                "Vanguard_Neckchopper",
                "Vanguard_Pillager",
                "Vanguard_Predator",
                "Vanguard_Trooper",
                "Vanguard_Vexer",
            },
            boss =
            {
                { name = "Overlords_Tombstone", mods = { xi.mod.STR, 15 }, desc = "STR+15" },
            },
        },
        {
            area  = "Dynamis-Bastok",
            qty   = 20,
            exp   = 4000,
            pts   = { 90, 110 },
            box   = { 1455, 23, 30 },
            mobs  =
            {
                "Vanguard_Beasttender",
                "Vanguard_Constable",
                "Vanguard_Defender",
                "Vanguard_Drakekeeper",
                "Vanguard_Hatamoto",
                "Vanguard_Kusa",
                "Vanguard_Mason",
                "Vanguard_Militant",
                "Vanguard_Minstrel",
                "Vanguard_Protector",
                "Vanguard_Purloiner",
                "Vanguard_Thaumaturge",
                "Vanguard_Undertaker",
                "Vanguard_Vigilante",
                "Vanguard_Vindicator",
            },
            boss =
            {
                { name = "GuDha_Effigy", mods = { xi.mod.DOUBLE_ATTACK, 10 }, desc = "Double Attack+10%" },
            },
        },
        {
            area  = "Dynamis-Windurst",
            qty   = 20,
            exp   = 4000,
            pts   = { 90, 110 },
            box   = { 1449, 23, 30 },
            mobs  =
            {
                "Vanguard_Assassin",
                "Vanguard_Chanter",
                "Vanguard_Exemplar",
                "Vanguard_Inciter",
                "Vanguard_Liberator",
                "Vanguard_Ogresoother",
                "Vanguard_Oracle",
                "Vanguard_Partisan",
                "Vanguard_Persecutor",
                "Vanguard_Prelate",
                "Vanguard_Priest",
                "Vanguard_Salvager",
                "Vanguard_Sentinel",
                "Vanguard_Skirmisher",
                "Vanguard_Visionary",
            },
            boss =
            {
                { name = "Tzee_Xicu_Idol", mods = { xi.mod.CRITHITRATE, 10 }, desc = "Critical hit rate+10%" },
            },
        },
        {
            area  = "Dynamis-Jeuno",
            qty   = 20,
            exp   = 4000,
            pts   = { 90, 110 },
            box   = { { 1449, 1452, 1455 }, 23, 30 },
            mobs  =
            {
                "Vanguard_Necromancer",
                "Vanguard_Tinkerer",
                "Vanguard_Ambusher",
                "Vanguard_Enchanter",
                "Vanguard_Armorer",
                "Vanguard_Dragontamer",
                "Vanguard_Welldigger",
                "Vanguard_Shaman",
                "Vanguard_Alchemist",
                "Vanguard_Hitman",
                "Vanguard_Maestro",
                "Vanguard_Ronin",
                "Vanguard_Smithy",
                "Vanguard_Pathfinder",
                "Vanguard_Pitfighter",
            },
            boss =
            {
                { name = "Goblin_Golem", mods = { xi.mod.TRIPLE_ATTACK, 10 }, desc = "Triple Attack+10%" },
            },
        },
    },
}

cexi.ventures.dynamis.categories =
{
    { "Dynamis Cities", 1 },
}

cexi.ventures.dynamis.mapping = {}

local index = 1

for tierIndex, tierInfo in pairs(cexi.ventures.dynamis.ventures) do
    for ventureIndex, ventureInfo in pairs(tierInfo) do
        cexi.ventures.dynamis.mapping[index]  = { tierIndex, ventureIndex }
        ventureInfo.index = index
        index = index + 1
    end
end

return m
