-----------------------------------
-- Skill
-- Provides info and utils for custom skills
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_utils_skill")

cexi       = cexi or {}
cexi.skill =
{
    garbagio =
    {
        name     = "Garbagio",
        desc     = "garbagio goodwill",
        varSkill = "[SKILL]Garbagio",
        varRank  = "[SKILL]Garbagio_Rank",
        varTally = "[SKILL]Garbagio_Tally",
        skillCap = 110,
        ranks    =
        {
            {   0, "Nobody",                          }, -- None
            {  10, "Garbage",        { {  2164, 8 } } }, -- Peph. Hive Chip x8
            {  20, "Outlander",      { {  769,  5 } } }, -- Silk Thread x5
            {  30, "Apprehensive",   { {  701,  2 } } }, -- Rosewood Log x3
            {  40, "Persuadable",    { {  1703, 3 } } }, -- Kunwu Ore x3
            {  50, "Acquainted",     { {  1764, 1 } } }, -- Kejusu Satin x1
            {  60, "Familiar",       { {  1841, 1 } } }, -- Unicorn Horn x1
            {  70, "Friendly",       { {  1771, 1 } } }, -- Dragon Bone x1
            {  80, "Comrade",        { {  1767, 1 } } }, -- Eltoro Leather x1
            {  90, "Jovial",         { {  1763, 1 } } }, -- Viridian Urushi x1
            { 100, "Affectionate",   { {  1816, 1 } } }, -- Wyrm Horn x1
            { 110, "Kindred Spirit", { { 23803, 1 } } }, -- Poroggo Cassock
        },
    },

    scrying =
    {
        name     = "Scrying",
        desc     = "scrying skill",
        varSkill = "[SKILL]Scrying",
        varRank  = "[SKILL]Scrying_Rank",
        varTally = "[SKILL]Scrying_Tally",
        skillCap = 110,
        ranks    =
        {
            {   0, "Outsider",                    }, -- None
            {  10, "Initiate",   { {   769, 5 } } }, -- Silk Thread x5
            {  20, "Novice",     { {   701, 2 } } }, -- Rosewood Log x3
            {  30, "Apprentice", { {  1703, 3 } } }, -- Kunwu Ore x3
            {  40, "Traveler",   { {  1764, 1 } } }, -- Kejusu Satin x1
            {  50, "Scribe",     { {  1841, 1 } } }, -- Unicorn Horn x1
            {  60, "Artisan",    { {  1771, 1 } } }, -- Dragon Bone x1
            {  70, "Adept",      { {  1767, 1 } } }, -- Eltoro Leather x1
            {  80, "Magus",      { {  1763, 1 } } }, -- Viridian Urushi x1
            {  90, "Mystic",     { {  1816, 1 } } }, -- Wyrm Horn x1
            { 100, "Elder",      { { 23803, 1 } } }, -- Poroggo Cassock
            { 110, "Master",     { { 23803, 1 } } }, -- Poroggo Cassock
        },
    },

    prospecting =
    {
        name     = "Prospecting",
        desc     = "prospecting skill",
        varSkill = "[SKILL]Prospecting",
        varRank  = "[SKILL]Prospecting_Rank",
        varTally = "[SKILL]Prospecting_Tally",
        skillCap = 110,
        ranks    =
        {
            {   0, "Amateur"    },
            {  10, "Recruit"    },
            {  20, "Initiate"   },
            {  30, "Novice"     },
            {  40, "Apprentice" },
            {  50, "Journeyman" },
            {  60, "Craftsman"  },
            {  70, "Artisan"    },
            {  80, "Adept"      },
            {  90, "Veteran"    },
            { 100, "Expert"     },
            { 110, "Master"     },
        },
    },

    lapidary =
    {
        name     = "Lapidary",
        desc     = "lapidary skill",
        varSkill = "[SKILL]Lapidary",
        varRank  = "[SKILL]Lapidary_Rank",
        varTally = "[SKILL]Lapidary_Tally",
        skillCap = 110,
        ranks    =
        {
            {   0, "Amateur"    },
            {  10, "Recruit"    },
            {  20, "Initiate"   },
            {  30, "Novice"     },
            {  40, "Apprentice" },
            {  50, "Journeyman" },
            {  60, "Craftsman"  },
            {  70, "Artisan"    },
            {  80, "Adept"      },
            {  90, "Veteran"    },
            { 100, "Expert"     },
            { 110, "Master"     },
        },
    },
}

local function getSkillChance(current, skillMax)
    local roll = math.random(1, 10)

    if skillReq ~= nil then
        local diff = skillMax - current

        -- Block skillups at recipe cap
        if diff < 1 then
            return false

        elseif diff <= 2 then
            return roll <= 6

        elseif diff <= 5 then
            return roll <= 4
        end
    end

    return roll <= 3
end

cexi.skill.skillUp = function(player, skillInfo, skillMax)
    local current = player:getCharVar(skillInfo.varSkill)

    if skillInfo.skillCap ~= nil then
        if current >= skillInfo.skillCap * 10 then
            return
        end
    else
        if current >= 110 then
            return
        end
    end

    -- Base skillup amount is 0.1
    local amount  = 1

    -- Chance of 0.2 or 0.3
    if skillMax ~= nil then
        if getSkillChance(current, skillMax) then
            if
                current < 600 and
                getSkillChance(current, skillMax)
            then
                -- Under 60, extra chance for 0.3
                amount = 3
            else
                -- Any level, chance for 0.2
                amount = 2
            end
        end
    else
        if math.random(1, 10) <= 3 then
            if
                current < 600 and
                math.random(1, 10) <= 3
            then
                -- Under 60, extra chance for 0.3
                amount = 3
            else
                -- Any level, chance for 0.2
                amount = 2
            end
        end
    end

    local result      = current + amount
    local name        = player:getName()
    local resultLevel = math.floor(result / 10)

    player:sys("{}'s {} rises 0.{} points.", name, skillInfo.desc, amount)

    if skillInfo.cap ~= nil then
        if resultLevel > skillInfo.cap then
            resultLevel = skillInfo.cap
        end
    else
        if resultLevel > 110 then
            resultLevel = 110
        end
    end

    if resultLevel > math.floor(current / 10) then
        player:sys("{}'s {} reaches level {}.", name, skillInfo.desc, resultLevel)

        if skillInfo.ranks ~= nil then
            if resultLevel % 10 == 0 then
                local resultRank = (resultLevel / 10) + 1
                player:sys("{} reaches the rank of {}.", name, skillInfo.ranks[resultRank][2])
            end
        end
    end

    player:setCharVar(skillInfo.varSkill, result)
end

cexi.skill.rankUpReward = function(player, npc, skillInfo, callback)
    local rank  = player:getCharVar(skillInfo.varRank)
    local skill = player:getCharVar(skillInfo.varSkill) / 10

    for index, rankInfo in pairs(skillInfo.ranks) do
        if
            skill >= rankInfo[1] and
            not utils.mask.getBit(rank, index - 1)
        then
            if
                rankInfo[3] ~= nil and
                npcUtil.giveItem(player, rankInfo[3])
            then
                player:setCharVar(skillInfo.varRank, utils.mask.setBit(rank, index - 1, true))

                if callback then
                    callback(player, npc)
                end

                return true
            end
        end
    end

    return false
end

local directionTable =
{
    [0] = "east",
    [1] = "southeast",
    [2] = "south",
    [3] = "southwest",
    [4] = "west",
    [5] = "northwest",
    [6] = "north",
    [7] = "northeast",
}

local function distanceWords(distance)
    local distanceText = "unknown"

    if distance > 200 then
        distanceText = "in the distance"
    elseif distance > 100 then
        distanceText = "far away"
    elseif distance > 50 then
        distanceText = "near by"
    elseif distance > 25 then
        distanceText = "close"
    elseif distance > 10 then
        distanceText = "very close"
    else
        distanceText = "beneath your feet"
    end

    return distanceText
end

cexi.skill.distanceTo = function(player, targetPos)
    local targetX   = targetPos[1]
    local targetZ   = targetPos[3]
    local playerPos = player:getPos()
    local distance  = player:checkDistance(targetX, playerPos.y, targetZ)

    -- Angle between points
    -- NOTE: This is mapped to 0-255
    local angle = player:getWorldAngle(targetX, playerPos.y, targetZ)

    -- Map angle from 0-255 to 0-7 for the messageSpecial arg, with a small offset for cardinal direction
    local offset    = 255 / 8
    local direction = math.floor(((7 - 0) / (255 - 0)) * ((angle + offset) - 0))

    return {
        distance  = distance,
        direction = direction,
    }
end

cexi.skill.digTreasure = function(player, loc)
    local zoneID = player:getZoneID()
    local result = cexi.skill.distanceTo(player, loc)

    player:timer(2000, function()
        player:ceAnimate(player, player, 21, 2)

        player:timer(1000, function()
            if result.distance >= 5 then
                player:fmt("You find nothing but you sense something is buried {} to the {}.", distanceWords(result.distance), directionTable[result.direction])
            end
        end)
    end)

    return result.distance < 5
end

return m
