-----------------------------------
-- Deliver Util
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_deliver")

cexi         = cexi or {}
cexi.deliver = cexi.deliver or {}

local settings =
{
    assistant =
    {
        slots    = 4,
        itemVar  = "[DELIVERY]SLOT_{}",
        qtyVar   = "[DELIVERY]SLOT_{}_QTY",
    },
}

cexi.deliver.assistant = function(player, item, qty)
    local sent = 0
    local used = 0
    local iqty = qty or 1

    for slot = 1, settings.assistant.slots do
        if player:getCharVar(fmt(settings.assistant.itemVar, slot)) == 0 then
            if sent == 0 then
                player:setCharVar(fmt(settings.assistant.itemVar, slot), item)
                player:setCharVar(fmt(settings.assistant.qtyVar, slot), iqty)
                sent = slot
                used = used + 1
            end
        else
            used = used + 1
        end
    end

    if sent == 0 then
        player:sys("The Delivery Assistant is at max capacity. Your item was lost.")
        print(fmt("[DELIVER] {} was unable to receive {} x{} due to max capacity", player:getName(), item, iqty))
        return
    end

    player:sys("Item sent to Delivery Assistant in Ru'Lude Gardens, please collect at your earliest convenience. (Slots used: {}/{})", used, settings.assistant.slots)

    if used >= settings.assistant.slots then
        player:sys("The Delivery Assistant is at max capacity. Any further missed items will be lost!")
    end

    print(fmt("[DELIVER] {} was sent {} x{} through slot #{}", player:getName(), item, iqty, sent))
end

return m
