-----------------------------------
-- Bundles
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_bundle")

cexi        = cexi or {}
cexi.bundle = cexi.bundle or {}

cexi.bundle.garrison =
{
    { name = "Ronfaure",         item = xi.item.RED_CRYPTEX,              gil = 100 },
    { name = "Gustaberg",        item = xi.item.DARKSTEEL_ENGRAVING,      gil = 100 },
    { name = "Sarutabaruta",     item = xi.item.SEVEN_KNOT_QUIPU,         gil = 100 },
    { name = "Zulkheim",         item = xi.item.GALKA_FANG_SACK,          gil = 200 },
    { name = "Norvallen",        item = xi.item.JADE_CRYPTEX,             gil = 200 },
    { name = "Derfland",         item = xi.item.SILVER_ENGRAVING,         gil = 200 },
    { name = "Kolshushu",        item = xi.item.MITHRA_FANG_SACK,         gil = 200 },
    { name = "Aragoneu",         item = xi.item.THIRTEEN_KNOT_QUIPU,      gil = 200 },
    { name = "Qufim",            item = xi.item.RAM_LEATHER_MISSIVE,      gil = 200 },
    { name = "Fauregandi",       item = xi.item.TIGER_LEATHER_MISSIVE,    gil = 300 },
    { name = "Li'Telor",         item = xi.item.HOUND_FANG_SACK,          gil = 300 },
    { name = "Elshimo Lowlands", item = xi.item.SHEEP_LEATHER_MISSIVE,    gil = 300 },
    { name = "Valdeaunia",       item = xi.item.BEHEMOTH_LEATHER_MISSIVE, gil = 400 },
    { name = "Kuzotz",           item = xi.item.DHALMEL_LEATHER_MISSIVE,  gil = 400 },
    { name = "Elshimo Uplands",  item = xi.item.COEURL_LEATHER_MISSIVE,   gil = 400 },
    { name = "Vollbow",          item = xi.item.BUNNY_FANG_SACK,          gil = 500 },
}

local garrisonItemLookup = {}

cexi.bundle.tradeableGarrison =
{
    [xi.item.GARRISON_PASS] = true,
}

for itemIndex, itemInfo in pairs(cexi.bundle.garrison) do
    garrisonItemLookup[itemInfo.item] = itemIndex
    cexi.bundle.tradeableGarrison[itemInfo.item] = true
end

cexi.bundle.hasPass = function(player, garrisonItemID)
    local current = player:getCharVar("[GARRISON]PASS")
    local index   = garrisonItemLookup[garrisonItemID]

    if index == nil then
        return false
    end

    return utils.mask.getBit(current, index)
end

cexi.bundle.usePass = function(player, garrisonItemID)
    local current = player:getCharVar("[GARRISON]PASS")
    local index   = garrisonItemLookup[garrisonItemID]

    if index == nil then
        return false
    end

    current = utils.mask.setBit(current, index, false)
    player:setCharVar("[GARRISON]PASS", current)
end

cexi.bundle.chest =
{
    { name = "Pso'Xja",                item = 1064, gil = 100 },
    { name = "Oldton Movalpolos",      item = 1062, gil = 100 },
    { name = "Sacrarium",              item = 1061, gil = 100 },
    { name = "Fort Ghelsba",           item = 1024, gil = 100 },
    { name = "Palborough Mines",       item = 1025, gil = 100 },
    { name = "Giddeus",                item = 1026, gil = 100 },
    { name = "Beadeaux",               item = 1034, gil = 100 },
    { name = "Davoi",                  item = 1033, gil = 100 },
    { name = "Castle Oztroja",         item = 1035, gil = 100 },
    { name = "Delkfutts Tower",        item = 1036, gil = 100 },
    { name = "Castle Zvahl",           item = 1038, gil = 100 },
    { name = "Sea Serpent Grotto",     item = 1055, gil = 100 },
    { name = "King Ranperre's Tomb",   item = 1027, gil = 100 },
    { name = "Dangruf Wadi",           item = 1028, gil = 100 },
    { name = "Horutoto Ruins",         item = 1029, gil = 100 },
    { name = "Ordelles Caves",         item = 1030, gil = 100 },
    { name = "The Eldieme Necropolis", item = 1039, gil = 100 },
    { name = "Gusgen Mines",           item = 1031, gil = 100 },
    { name = "Crawlers Nest",          item = 1040, gil = 100 },
    { name = "Maze of Shakhrami",      item = 1032, gil = 100 },
    { name = "Garlaige Citadel",       item = 1041, gil = 100 },
    { name = "Feiyin",                 item = 1037, gil = 100 },
    { name = "Labyrinth of Onzozo",    item = 1056, gil = 100 },
}

cexi.bundle.coffer =
{
    { name = "Newton Movalpolos",      item = 1063, gil = 300 },
    { name = "Ru'Aun Gardens",         item = 1058, gil = 300 },
    { name = "Beadeaux",               item = 1043, gil = 300 },
    { name = "Monastic Cavern",        item = 1042, gil = 300 },
    { name = "Castle Oztroja",         item = 1044, gil = 300 },
    { name = "The Boyahda Tree",       item = 1052, gil = 300 },
    { name = "Temple of Uggalepih",    item = 1049, gil = 300 },
    { name = "Den of Rancor",          item = 1050, gil = 300 },
    { name = "Castle Zvahl Baileys",   item = 1048, gil = 300 },
    { name = "Toraimarai Canal",       item = 1057, gil = 300 },
    { name = "Kuftal Tunnel",          item = 1051, gil = 300 },
    { name = "Sea Serpent Grotto",     item = 1059, gil = 300 },
    { name = "Velugannon Palace",      item = 1060, gil = 300 },
    { name = "The Eldieme Necropolis", item = 1046, gil = 300 },
    { name = "Crawlers Nest",          item = 1045, gil = 300 },
    { name = "Garlaige Citadel",       item = 1047, gil = 300 },
    { name = "Ifrits Cauldron",        item = 1053, gil = 300 },
    { name = "Quicksand Caves",        item = 1054, gil = 300 },
}

local keyLookup = {}

cexi.bundle.tradeableKeys =
{
    [xi.item.GOBLIN_KEYRING] = true,
}

for itemIndex, itemInfo in pairs(cexi.bundle.chest) do
    keyLookup[itemInfo.item] = { 'chest', itemIndex }
    cexi.bundle.tradeableKeys[itemInfo.item] = true
end

for itemIndex, itemInfo in pairs(cexi.bundle.coffer) do
    keyLookup[itemInfo.item] = { 'coffer', itemIndex }
    cexi.bundle.tradeableKeys[itemInfo.item] = true
end

cexi.bundle.hasKey = function(player, keyItemID)
    local keyInfo = keyLookup[keyItemID]

    if keyInfo == nil then
        return false
    end

    if keyInfo[1] == "coffer" then
        local current = player:getCharVar("[KEYS]COFFER")
        return utils.mask.getBit(current, keyInfo[2])
    else
        local current = player:getCharVar("[KEYS]CHEST")
        return utils.mask.getBit(current, keyInfo[2])
    end
end

cexi.bundle.useKey = function(player, keyItemID)
    local keyInfo = keyLookup[keyItemID]

    if keyInfo == nil then
        return false
    end

    if keyInfo[1] == "coffer" then
        local current = player:getCharVar("[KEYS]COFFER")
        current = utils.mask.setBit(current, keyInfo[2], false)
        player:setCharVar("[KEYS]COFFER", current)
    else
        local current = player:getCharVar("[KEYS]CHEST")
        current = utils.mask.setBit(current, keyInfo[2], false)
        player:setCharVar("[KEYS]CHEST", current)
    end
end

return m

