-----------------------------------
-- Augment Util
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_util_augment")

cexi      = cexi or {}
cexi.util = cexi.util or {}
cexi.util.augment = cexi.util.augment or {}

cexi.util.augment.isAugmented = function(trade, itemID)
    for slot = 0, trade:getSlotCount() - 1 do
        if trade:getItemId(slot) == itemID then
            local item = trade:getItem(slot)

            if item:getAugment(0) ~= nil then
                return true
            end
        end
    end

    return false
end

cexi.util.augment.getAugments = function(player, itemArg)
    local augs = {}
    local item = itemArg

    if type(itemArg) == "number" then
        item = player:findItem(itemArg)
    end

    if item == nil then
        return augs
    end

    for i = 0, 8 do
        local aug = item:getAugment(i)

        if
            aug ~= nil and
            aug[1] > 0
        then
            table.insert(augs, { aug[1], aug[2] })
        end
    end

    return augs
end

cexi.util.augment.hasAugments = function(player, itemID, augs)
    local item = player:findItem(itemID)

    if item == nil then
        return false
    end

    for i = 1, #augs, 2 do
        local hasAug = false

        for j = 0, 8 do
            local aug = item:getAugment(j)

            if
                aug[1] == augs[i] and
                aug[2] == augs[i+1]
            then
                hasAug = true
            end
        end

        if not hasAug then
            return false
        end
    end

    return true
end

cexi.util.augment.getTradedItem = function(trade, itemID)
    for i = 0, trade:getSlotCount()-1 do
        local item = trade:getItemId(i)

        if trade:getItemId(i) == itemID then
            return trade:getItem(i)
        end
    end
end

cexi.util.augment.transferAugments = function(player, trade, sourceID, destID)
    local ID   = zones[player:getZoneID()]
    local item = cexi.util.augment.getTradedItem(trade, sourceID)

    if player:getFreeSlotsCount() > 0 then
        local aug0 = item:getAugment(0)
        local aug1 = item:getAugment(1)
        local aug2 = item:getAugment(2)
        local aug3 = item:getAugment(3)

        player:tradeComplete()

        player:addItem(destID, 1, aug0[1], aug0[2], aug1[1], aug1[2], aug2[1], aug2[2], aug3[1], aug3[2])

        player:timer(1000, function()
            player:messageSpecial(ID.text.ITEM_OBTAINED, destID)
        end)
    end

    player:tradeComplete()
end

cexi.util.getByte = function(current, byte)
    local result = bit.lshift(current, 28 - ((byte - 1) * 4))
    return bit.rshift(result, 28)
end

cexi.util.setByte = function(current, byte, value)
    if value == 0 then
        local full = bit.lshift(15, (byte - 1) * 4)
        return bit.bor(current, full) - full
    else
        local result = bit.lshift(value, (byte - 1) * 4)
        return bit.bor(current, result)
    end
end

return m
