-----------------------------------
-- Novice Trials
-----------------------------------
require("modules/module_utils")
----------------------------------------------------------
local m = Module:new("base_trials_novice")

cexi                       = cexi or {}
cexi.trials                = cexi.trials or {}
cexi.trials.novice         = cexi.trials.novice or {}
cexi.trials.novice.upgrade =
{
    [xi.item.DOUBLET]    = { "Doublet +1",         12591 },
    [xi.item.SCALE_MAIL] = { "Solid Mail",         12661 },
    [xi.item.LINEN_ROBE] = { "Linen Robe +1",      12626 },
    [12455]              = { "Beetle Mask +1",     13827 },
    [12583]              = { "Beetle Harness +1",  13717 },
    [12711]              = { "Beetle Mittens +1",  12789 },
    [12835]              = { "Beetle Subligar +1", 12913 },
    [12967]              = { "Btl. Leggings +1",   13043 },
    [17493]              = { "Trp. Punches +1",    17494 },
    [18956]              = { "Serpette +1",        18959 },
    [11407]              = { "Mtt. Leggings +1",   11412 },
    [12593]              = { "Great Doublet",      12669 },
    [14132]              = { "Winged Boots +1",    14133 },
    [13631]              = { "Nomad's Mantle +1",  13632 },
    [19119]              = { "Ranging Knife +1",   19127 },
    [15939]              = { "Griot Belt +1",      15947 },
    [17441]              = { "Eremite's Wand +1",  17442 },
    [17630]              = { "Hawker's Knife +1",  17631 },
    [19009]              = { "Brass Grip +1",      19010 },
    [16524]              = { "Fleuret +1",         16803 },
    [17739]              = { "Steel Kilij +1",     17740 },
    [14722]              = { "Pigeon Earring +1",  14723 },
    [13635]              = { "Cvl. Mantle +1",     13636 },
    [18606]              = { "Passaddhi Staff +1", 18615 },
    [13703]              = { "Brigandine +1",      13710 },
}

cexi.trials.novice.list    =
{
    [14062] =
    {
        name = "Carbuncle Mitts",
        mobs =
        {
            { "Air_Elemental",     "Tahrongi_Canyon",      3 }, -- !gotoid 17256757
            { "Water_Elemental",   "La_Theine_Plateau",    3 }, -- !gotoid 17195202
            { "Thunder_Elemental", "Konschtat_Highlands",  3 }, -- !gotoid 17219996
        },
        augs = { 17, 4, 40, 0, 99, 9 },
        desc = "HP/MP+5 Enmity-1 Pet: DEF+10",
    },

    [14669] =
    {
        name = "Jaeger Ring",
        mobs =
        {
            { "Sadfly",        "Gusgen_Mines",           30 }, -- !gotoid 17580115
            { "Gallinipper",   "Attohwa_Chasm",          40 }, -- !gotoid 16805898
            { "Elusive_Edwin", "The_Sanctuary_of_ZiTah",  1 }, -- !spawnmob 17272915 !gotoid 17272915
        },
        augs = { 515, 2, 142, 0 },
        desc = "AGI+3 Store TP+1",
    },

    [15184] =
    {
        name = "Voyager Sallet",
        mobs =
        {
            { "Hawker",    "Riverne-Site_A01",       30 }, -- !gotoid 16900216
            { "Ogrefly",   "The_Sanctuary_of_ZiTah", 40 }, -- !gotoid 17272961
            { "Guardian_Crawler", "Crawlers_Nest",    6 }, -- !spawnmob 17584130 !gotoid 17584130
        },
        augs = { 33, 15, 514, 3, 25, 1 },
        desc = "DEF+16 VIT+4 Attack+2",
    },

    [15183] =
    {
        name = "Dobson Bandana",
        boss =
        {
            mob         = "Prince Ogrefly",
            pop         = "Ogrefly Nest",
            area        = "Attohwa_Chasm", -- (F-8)
            groupId     = 31, -- Monarch Ogrefly
            groupZoneId = 7,
            look        = 449,
            pos         = { -271.445, -4.138, -7.492, 162 }, -- !pos -271.445 -4.138 -7.492 7
            level       = 42,
            capped      = 40,
            item        =
            {
                "a piece of Attowah ginseng",
                { { 1683, 1 } },
            },
        },
        augs = { 33, 14, 39, 1, 37, 0 },
        desc = "DEF+15 Enmity+2 Magic Evasion+1",
    },

    [xi.item.BEESTINGER] =
    {
        name = "Beestinger",
        mobs =
        {
            { "Huge_Wasp",  "Konschtat_Highlands", 15 }, -- !gotoid 17219636
            { "Huge_Wasp",  "La_Theine_Plateau",   15 }, -- !gotoid 17195056
            { "Killer_Bee", "Tahrongi_Canyon",     15 }, -- !gotoid 17256504
        },
        augs = { 45, 2, 41, 0},
        desc = "DMG:+3, Crit.hit rate+1%%",
    },

    [xi.item.LIGHT_AXE] =
    {
        name = "Light Axe",
        mobs =
        {
            { "Forest_Hare",  "East_Ronfaure", 20 }, -- !gotoid 17190975
            { "Forest_Hare",  "West_Ronfaure", 20 }, -- !gotoid 17186876
        },
        augs = { 45, 2, 518, 1 },
        desc = "DMG:+3, CHR+2",
    },

    [xi.item.SCALE_MAIL] =
    {
        name = "Scale Mail",
        boss =
        {
            mob         = "Goblin Armorer",
            pop         = "Lost Tongs",
            area        = "Konschtat_Highlands",
            groupId     = 7, -- Goblin Butcher
            groupZoneId = 108,
            pos         = { -136.574, 16.922, 267.291, 175 }, -- !pos -136.574 16.922 267.291 108
            level       = 15,
            capped      = 15,
            item        =
            {
                "three bronze ingots",
                { { 649, 3 } },
            },
        },
        augs = { 1, 9, 33, 2 },
        desc = "HP+10, DEF+3",
    },

    [xi.item.DOUBLET] =
    {
        name = "Doublet",
        boss =
        {
            mob         = "Goblin Burglar",
            pop         = "Lost Lockpick",
            area        = "La_Theine_Plateau",
            groupId     = 17, -- Goblin Thug
            groupZoneId = 102,
            pos         = { -828.787, 16.359, 438.968, 113 }, -- !pos -828.787 16.359 438.968 102
            level       = 15,
            capped      = 15,
            item        =
            {
                "three sheep leather",
                { { 850, 3 } },
            },
        },
        augs = { 1, 9, 33, 2 },
        desc = "HP+10, DEF+3",
    },

    [xi.item.LINEN_ROBE] =
    {
        name = "Linen Robe",
        boss =
        {
            mob         = "Goblin Tailor",
            pop         = "Lost Needle",
            area        = "Tahrongi_Canyon",
            groupId     = 13, -- Goblin Weaver
            groupZoneId = 117,
            pos         = { -193.083, -17.368, -166.096, 160 }, -- !pos -193.083 -17.368 -166.096 117
            level       = 15,
            capped      = 15,
            item        =
            {
                "three cotton threads",
                { { 818, 3 } },
            },
        },
        augs = { 9, 9, 33, 2 },
        desc = "MP+10, DEF+3",
    },

    [12455] =
    {
        name = "Beetle Mask",
        mobs =
        {
            { "Copper_Beetle", "Palborough_Mines",   15 }, -- !gotoid 17363175
            { "Beady_Beetle",  "Carpenters_Landing", 15 }, -- !gotoid 16785414
        },
        augs = { 515, 1 },
        desc = "AGI+2",
    },

    [12583] =
    {
        name = "Beetle Harness",
        boss =
        {
            mob         = "Giant Beetle",
            pop         = "Disturbed Mound",
            area        = "Sauromugue_Champaign",
            groupId     = 34, -- Stag Beetle
            groupZoneId = 119,
            look        = 410,
            pos         = { -226.491, 14.024, 415.389, 120 }, -- !pos -226.491 14.024 415.389 120     (G-5)
            level       = 20,
            capped      = 20,
            item        =
            {
                "twelve beetle shells",
                { { 889, 12 } },
            },
        },
        augs = { 33, 3, 515, 1 },
        desc = "DEF+4, AGI+2",
    },

    [12711] =
    {
        name = "Beetle Mittens",
        mobs =
        {
            { "Stag_Beetle",  "Jugner_Forest",         15 }, -- !gotoid 17203217
            { "Stag_Beetle",  "Meriphataud_Mountains", 15 }, -- !gotoid 17264858
        },
        augs = { 25, 1 },
        desc = "Attack+2",
    },

    [12835] =
    {
        name = "Beetle Subligar",
        mobs =
        {
            { "Stag_Beetle",  "Jugner_Forest",         15 }, -- !gotoid 17203217
            { "Stag_Beetle",  "Meriphataud_Mountains", 15 }, -- !gotoid 17264858
        },
        augs = { 25, 1 },
        desc = "Attack+2",
    },

    [12967] =
    {
        name = "Beetle Leggings",
        mobs =
        {
            { "Copper_Beetle", "Palborough_Mines",   15 }, -- !gotoid 17363175
            { "Beady_Beetle",  "Carpenters_Landing", 15 }, -- !gotoid 16785414
        },
        augs = { 515, 1 },
        desc = "AGI+2",
    },

    [12567] =
    {
        name = "Steam Scale Mail",
        mobs =
        {
            { "Steam_Lizard", "Dangruf_Wadi",         25 }, -- !gotoid 17559592
            { "Hill_Lizard",  "Sauromugue_Champaign", 15 }, -- !gotoid 17268742
        },
        augs = { 17, 9, 551, 0, 287, 2 },
        desc = "HP/MP+10 STR/VIT+1 Parry Skill +3",
    },

    [18394] =
    {
        name = "Pilgrim's Wand",
        mobs =
        {
            { "Akbaba", "La_Theine_Plateau", 20 }, -- !gotoid 17195021
            { "Akbaba", "Tahrongi_Canyon",   20 }, -- !gotoid 17256484
        },
        augs = { 9, 4, 141, 1, 52, 0 },
        desc = "MP+5 Conserve MP+2 MP recovered while healing +1",
    },

    [17493] =
    {
        name = "Tropical Punches",
        mobs =
        {
            { "Mandragora", "East_Sarutabaruta", 20 }, -- !gotoid 17252592
            { "Pygmaioi", "Tahrongi_Canyon",     20 }, -- !gotoid 17256453
        },
        augs = { 45, 2, 145, 1 },
        desc = "DMG:+3, Counter+2",
    },

    [19305] =
    {
        name = "Pike",
        mobs =
        {
            { "Killer_Bee", "Tahrongi_Canyon",   25 }, -- !gotoid 17256504
            { "Digger_Wasp", "Giddeus",          15 }, -- !gotoid 16785425
        },
        augs = { 45, 4, 121, 1 },
        desc = "DMG:+5, Pet: Breath+2",
    },

    [16185] =
    {
        name = "Pelte",
        mobs =
        {
            { "Wadi_Crab", "Dangruf_Wadi",         20 }, -- !gotoid 17559636
            { "Thickshell", "La_Theine_Plateau",   20 }, -- !gotoid 17195194
        },
        augs = { 554, 0, 52, 1 },
        desc = "INT/MND+1, MP recovered while healing+2",
    },

    [13607] =
    {
        name = "Mist Silk Cape",
        mobs =
        {
            { "Crawler", "West_Sarutabaruta",        15 }, -- !gotoid 17248307
            { "Canyon_Crawler", "Tahrongi_Canyon",   25 }, -- !gotoid 17256551
        },
        augs = { 323, 0, 329, 0 },
        desc = "Cure spellcasting time-1%%, Cure potency+1%%",
    },

    [15218] =
    {
        name = "Entrancing Ribbon",
        mobs =
        {
            { "Steppe_Hare", "La_Theine_Plateau",  20 }, -- !gotoid 17195014
            { "Canyon_Rarab", "Tahrongi_Canyon",   20 }, -- !gotoid 17256449
        },
        augs = { 140, 0, 96, 1 },
        desc = "Fast Cast+1%%, Pet: Acc+2 Rng.Acc+2",
    },

    [16296] =
    {
        name = "Armiger's Lace",
        mobs =
        {
            { "Vulture", "South_Gustaberg",  25 }, -- !gotoid 17215662
            { "Akbaba", "La_Theine_Plateau", 20 }, -- !gotoid 17195021
        },
        augs = { 1, 1, 23, 0 },
        desc = "HP+2, Accuracy+1",
    },

    [17811] =
    {
        name = "Katayama",
        mobs =
        {
            { "Ornery_Sheep", "North_Gustaberg",   20 }, -- !gotoid 17211472
            { "Mad_Sheep", "Konschtat_Highlands",  20 }, -- !gotoid 17219758
        },
        augs = { 45, 4, 198, 1 },
        desc = "DMG:+5, Zanshin+2",
    },
    
    [14803] =
    {
        name = "Optical Earring",
        mobs =
        {
            { "Strolling_Sapling", "Konschtat_Highlands",  20 }, -- !gotoid 17219591
            { "Wandering_Sapling", "Jugner_Forest",        15 }, -- !gotoid 17203219
        },
        augs = { 1, 1, 513, 0 },
        desc = "HP+2, DEX+1",
    },

    [17594] =
    {
        name = "Gelong Staff",
        mobs =
        {
            { "Beach_Pugil", "Valkurm_Dunes",   20 }, -- !gotoid 17199346
            { "Pugil", "East_Ronfaure_[S]",     20 }, -- !gotoid 17109028
        },
        augs = { 1, 4, 137, 0 },
        desc = "HP+5, Regen+1",
    },

    [18956] =
    {
        name = "Serpette",
        boss =
        {
            mob         = "Rambling Ram",
            pop         = "Large Hoofprint",
            area        = "East_Ronfaure",
            groupId     = 20, -- Rambukk
            groupZoneId = 101,
            look        = 344,
            pos         = { 508.018, -19.671, -208.280, 101 }, -- !pos 508.018 -19.671 -208.280 101
            level       = 15,
            capped      = 15,
            item        =
            {
                "three baked apples",
                { { 4406, 3 } },
            },
        },
        augs = { 45, 4, 558, 0 },
        desc = "DMG:+5, STR/INT+1",
    },
    
    [12371] =
    {
        name = "Clipeus",
        mobs =
        {
            { "Scarab_Beetle", "East_Ronfaure",        25 }, -- !gotoid 17190985
            { "Copper_Beetle", "Palborough_Mines",     15 }, -- !gotoid 17363114
        },
        augs = { 1, 4, 286, 2 },
        desc = "HP+5, Shield Skill+3",
    },

    [13112] =
    {
        name = "Rabbit Charm",
        mobs =
        {
            { "Steppe_Hare", "La_Theine_Plateau",      20 }, -- !gotoid 17195014
            { "Wadi_Hare", "Dangruf_Wadi",             15 }, -- !gotoid 17559589
        },
        augs = { 553, 0, 31, 0 },
        desc = "DEX/AGI+1, Evasion+1",
    },

    [17412] =
    {
        name = "Wild Cudgel",
        mobs =
        {
            { "Orcish_Stonechucker", "Fort_Ghelsba",   10 }, -- !gotoid 17354905
            { "Orcish_Grunt", "Fort_Ghelsba",          10 }, -- !gotoid 17354847
            { "Orcish_Neckchopper", "Fort_Ghelsba",    10 }, -- !gotoid 17354849
            { "Sentry_Lizard", "Fort_Ghelsba",         10 }, -- !gotoid 17354906
        },
        augs = { 45, 6, 1, 4, 145, 1 },
        desc = "DMG:+7, HP+5, Counter+2",
    },

    [17967] =
    {
        name = "Felling Axe",
        mobs =
        {
            { "Grave_Bat", "King_Ranperres_Tomb",        25 }, -- !gotoid 17195014
            { "Tomb_Bat", "King_Ranperres_Tomb",         10 }, -- !gotoid 17559589  (Only 3 spawn)
        },
        augs = { 45, 2, 512, 0, 1806, 0 },
        desc = "DMG:+3, STR+1, Pet: STR+1 DEX+1 VIT+1",
    },

    [15052] =
    {
        name = "Guerilla Gloves",
        mobs =
        {
            { "Greater_Quadav", "Palborough_Mines",      15 }, -- !gotoid 17363122
            { "Veteran_Quadav", "Palborough_Mines",      15 }, -- !gotoid 17363121
            { "Onyx_Quadav", "Palborough_Mines",         15 }, -- !gotoid 17363118
        },
        augs = { 33, 1, 9, 3, 25, 1, 1792, 0 },
        desc = "DEF+2, MP+4, Attack+2, Pet: STR+1",
    },

    [12799] =
    {
        name = "Battle Gloves",
        mobs =
        {
            { "Rock_Eater", "King_Ranperres_Tomb",       25 }, -- !gotoid 17555641
            { "Plague_Bats", "King_Ranperres_Tomb",      10 }, -- !gotoid 17555710
            { "Nachzehrer", "King_Ranperres_Tomb",        5 }, -- !gotoid 17555669
            { "Spook", "King_Ranperres_Tomb",             1 }, -- !gotoid 17555598
        },
        augs = { 33, 1, 17, 2, 142, 0, 356, 0 },
        desc = "DEF+2, HP/MP+3, Store TP+1, Potency of Cure received+1",
    },

    [18412] =
    {
        name = "Gassan",
        mobs =
        {
            { "Thread_Leech", "Pashhow_Marshlands", 20 }, -- !gotoid 17223713
            { "Forest_Leech", "Jugner_Forest",      20 }, -- !gotoid 17203286
        },
        augs = { 45, 2, 39, 1 },
        desc = "DMG:+3, Enmity+2",
    },

    [12485] =
    {
        name = "Fungus Hat",
        mobs =
        {
            { "Marsh_Funguar", "Carpenters_Landing", 25 }, -- !gotoid 16785499
            { "Marsh_Funguar", "Pashhow_Marshlands", 25 }, -- !gotoid 17224095
        },
        augs = {33, 2, 556, 0, 49, 0 },
        desc = "DEF+3, INT/MND/CHR+1, Haste+1%%",
    },

    [18246] =
    {
        name = "Rogetsurin",
        mobs =
        {
            { "Skeleton_Warrior", "Gusgen_Mines",  20 }, -- !gotoid 17580045
            { "Sand_Hare", "Valkurm_Dunes",        15 }, -- !gotoid 17199228
            { "Sand_Bats", "Valkurm_Dunes",         5 }, -- !gotoid 17199254
            { "Poltergeist", "Konschtat_Highlands", 5 }, -- !gotoid 17219694
        },
        augs = {17, 2, 514, 0, 283, 2 },
        desc = "HP/MP+3, VIT+1, Throwing Skill+3",
    },

    [11407] =
    {
        name = "Mettle Leggings",
        mobs =
        {
            { "Wild_Sheep", "East_Ronfaure_[S]",   25 }, -- !gotoid 17559666
            { "Brutal_Sheep", "Jugner_Forest",     20 }, -- !gotoid 17203286
        },
        augs = { 1, 3, 513, 0, 97, 1 },
        desc = "HP+4, DEX+1, Pet: Attack+2 Rng.Atk.+2 ",
    },

    [12593] =
    {
        name = "Cotton Doublet",
        boss =
        {
            mob         = "Cottontail",
            pop         = "Bunny Trail",
            area        = "Batallia_Downs",
            groupId     = 7, -- Twigtrip_Lapinion
            groupZoneId = 261,
            look        = 1937,
            pos         = { -154.768, -7.515, 447.153, 105 }, -- !pos -154.7688 -7.515 447.153 105
            level       = 25,
            capped      = 25,
            item        =
            {
                "twelve cotton cloths",
                { { 825, 12 } },
            },
        },
        augs = { 17, 6, 33, 2, 25, 0 },
        desc = "HP/MP+7, DEF+3, Attack+1",
    },

    [14132] =
    {
        name = "Winged Boots",
        mobs =
        {
            { "Rock_Lizard", "North_Gustaberg_[S]",  35 }, -- !gotoid 17137951
            { "Hill_Lizard", "Sauromugue_Champaign", 25 }, -- !gotoid 17268742
            { "Ivory_Lizard", "Yuhtunga_Jungle",     15 }, -- !gotoid 17281062
        },
        augs = { 33, 2, 31, 1, 49, 0 },
        desc = "DEF+3, Evasion+2, Haste+1%%",
    },

    [16935] =
    {
        name = "Barbarian's Sword",
        mobs =
        {
            { "Yagudo_Votary", "Castle_Oztroja",     20 }, -- !gotoid 17395725
            { "Yagudo_Priest", "Castle_Oztroja",     10 }, -- !gotoid 17395727
            { "Yagudo_Theologist", "Castle_Oztroja", 10 }, -- !gotoid 17395739
            { "Boggart", "Meriphataud_Mountains",    20 }, -- !gotoid 17264927
        },
        augs = { 45, 5, 514, 1, 1472, 1 },
        desc = "DMG:+6, VIT+2, Parrying rate+2%%",
    },

    [13631] =
    {
        name = "Nomad's Mantle",
        mobs =
        {
            { "Seeker_Bats", "Korroloka_Tunnel", 35 }, -- !gotoid 17485832
            { "Bogy", "Gusgen_Mines",            25 }, -- !gotoid 17580089
        },
        augs = { 33, 2, 146, 0 },
        desc = "DEF+3, Dual Wield+1",
    },

    [19119] =
    {
        name = "Ranging Knife",
        mobs =
        {
            { "Clipper", "Rolanberry_Fields", 25 }, -- !gotoid 17228117
            { "Clipper", "Korroloka_Tunnel",  35 }, -- !gotoid 17486039
        },
        augs = { 45, 3, 513, 0, 29, 1 },
        desc = "DMG:+4, DEX+1, Ranged Attack+2",
    },

    [17650] =
    {
        name = "Nadrs",
        mobs =
        {
            { "Clipper", "Batallia_Downs",   25 }, -- !gotoid 17485832
            { "Clipper", "Qufim_Island",     35 }, -- !gotoid 17293331
        },
        augs = { 45, 3, 132, 0 },
        desc = "DMG:+4, Dbl.Atk.+1%% Crit.hit rate+1%%",
    },

    [17750] =
    {
        name = "Anthos Xiphos",
        boss =
        {
            mob         = "Soniashnyk",
            pop         = "Black Soil",
            area        = "West_Sarutabaruta_[S]",
            groupId     = 84, -- Albumen's Pachypodium
            groupZoneId = 291,
            look        = 2377,
            pos         = { -442.689, -28.000, 319.222, 95 }, -- !pos -442.689 -28.000 319.222 95     (E-6)
            level       = 25,
            capped      = 25,
            item        =
            {
                "thiry-six lycopodium flowers",
                { { 2507, 36 } },
            },
        },
        augs = { 45, 2, 513, 0, 25, 2 },
        desc = "DMG+3, DEX+1, Attack+3",
    },

    [16754] =
    {
        name = "Parrying Knife",
        mobs =
        {
            { "Malboro", "Pashhow_Marshlands",          10 }, -- !gotoid 17145883
            { "Ornery_Sheep", "North_Gustaberg_[S]",    30 }, -- !gotoid 17137686
            { "GeDha_Evileye", "Beadeaux",               1 }, -- !spawnmob 17379450 !gotoid 17379450
        },
        augs = { 45, 2, 557, 0, 39, 1, 1472, 0 },
        desc = "DMG:+3, STR+1 CHR+1, Enmity+2, Parrying Rate+1",
    },

    [18604] =
    {
        name = "Astaroth Cane",
        mobs =
        {
            { "Bandersnatch", "Gusgen_Mines",   20 }, -- !gotoid 17580063
            { "Ore_Eater", "Gusgen_Mines",      15 }, -- !gotoid 17580066
            { "Ghoul", "Gusgen_Mines",          20 }, -- !gotoid 17580073
        },
        augs = { 45, 4, 9, 8, 516, 0, 23, 4 },
        desc = "DMG+5, MP+9, INT+1, Accuracy+5",
    },

    [15939] =
    {
        name = "Griot Belt",
        mobs =
        {
            { "Copper_Quadav", "Rolanberry_Fields", 5 }, -- !gotoid 17227823
            { "Brass_Quadav", "Rolanberry_Fields",  5 }, -- !gotoid 17227825
            { "Old_Quadav", "Rolanberry_Fields",    5 }, -- !gotoid 17227822
            { "Copper_Quadav", "Beadeaux",         20 }, -- !gotoid 17379330
            { "Brass_Quadav", "Beadeaux",          20 }, -- !gotoid 17379336
            { "Old_Quadav", "Beadeaux",            20 }, -- !gotoid 17379329
        },
        augs = { 17, 4, 49, 1 },
        desc = "HP/MP+5, Haste+2%%",
    },

    [17441] =
    {
        name = "Eremite's Wand",
        mobs =
        {
            { "Orcish_Cursemaker", "Davoi",            20 }, -- !gotoid 17387529
            { "Orcish_Cursemaker", "Batallia_Downs",    5 }, -- !gotoid 17207478
            { "Orcish_Fighter", "Davoi",               20 }, -- !gotoid 17387526
            { "Orcish_Fighter", "Batallia_Downs",       5 }, -- !gotoid 17207420
        },
        augs = { 45, 4, 9, 14, 554, 2, 334, 1 },
        desc = "DMG:+5, MP+10, INT+3 MND+3", "Magic burst dmg.+2%%",
    },

    [13731] =
    {
        name = "Faerie Tunic",
        boss =
        {
            mob         = "Schildkrote",
            pop         = "Seltsam Loch",
            area        = "Pashhow_Marshlands",
            groupId     = 14, -- Peiste (Pashhow_Marshlands (S))
            groupZoneId = 90,
            look        = 2015,
            pos         = { 622.730, 25.000, 334.733, 179 }, -- !pos 622.730 25.000 334.733 90 (L-6)
            level       = 30,
            capped      = 30,
            item        =
            {
                "two holy phials",
                { { 13073, 2 } },
            },
        },
        augs = { 9, 14, 552, 1, 134, 1, 329, 1 },
        desc = "MP+15, STR/AGI+2, Magic Def. Bonus+2, Cure potency+2%%",
    },

    [17630] =
    {
        name = "Hawker's Knife",
        mobs =
        {
            { "Orcish_Nightraider", "Davoi",            30 }, -- !gotoid 17387572
            { "Orcish_Nightraider", "Batallia_Downs",    5 }, -- !gotoid 17207442
            { "Orcish_Nightraider", "Lufaise_Meadows",   5 }, -- !gotoid 16875547
            { "Orcish_Serjeant", "Carpenters_Landing",   5 }, -- !gotoid 16785474
        },
        augs = { 45, 2, 142, 0, 212, 4 },
        desc = "DMG:+3, Store TP+1, Recycle+5",
    },

    [19009] =
    {
        name = "Brass Grip",
        mobs =
        {
            { "Boggart", "Inner_Horutoto_Ruins",            35 }, -- !gotoid 17563793
        },
        augs = { 268, 1, 287, 1, 288, 1 },
        desc = "Staff Skill+2, Parrying Skill+2, Divine Magic Skill+2",
    },

    [11531] =
    {
        name = "Fidelity Mantle",
        mobs =
        {
            { "Bulwark_Bat", "Castle_Oztroja",             10 }, -- !gotoid 17395973
            { "Bastion_Bats", "Castle_Oztroja",            15 }, -- !gotoid 17178625
            { "Stirge", "Oldton_Movalpolos",               15 }, -- !gotoid 16822326
            { "Dark_Bats", "Oldton_Movalpolos",            10 }, -- !gotoid 16822328
            { "Goblins_Bat", "Oldton_Movalpolos",          10 }, -- !gotoid 16822325
        },
        augs = { 33, 2, 17, 5, 25, 2 },
        desc = "DEF+3, HP/MP+6, Attack+3",
    },

    [16524] =
    {
        name = "Fleuret",
        mobs =
        {
            { "Dancing_Weapon", "Qufim_Island",            20 }, -- !gotoid 17563793
            { "Lycopodium", "Sauromugue_Champaign_[S]",    20 }, -- !gotoid 17178625
            { "Chaos_Idol", "Lower_Delkfutts_Tower",       15 }, -- !gotoid 17531040
        },
        augs = { 45, 3, 17, 6, 23, 2, 554, 1 },
        desc = "DMG+4, HP/MP+7, Accuracy+3, INT/MND+2",
    },

    [17739] =
    {
        name = "Steel Kilij",
        boss =
        {
            mob         = "Hollohaza Liba",
            pop         = "Clay Cast Nest",
            area        = "Bhaflau_Thickets",
            groupId     = 21, -- Colibri Bhaflau_Thickets
            groupZoneId = 52,
            pos         = { -46.410, -24.308, 157.366, 52 }, -- !pos -46.410 -24.308 157.366 52     (F-9)
            level       = 33,
            capped      = 30,
            item        =
            {
                "4 Karakul Leathers and 12 Colorful Eggs",
                { { 879, 4 }, {4487, 12} },
            },
        },
        augs = { 45, 2, 558, 0, 68, 2, 140, 0  },
        desc = "DMG+3, STR+1 INT+1, Acc+3 Atk+3, Fast Cast+1%%",
    },

    [11338] =
    {
        name = "Aega's Doublet",
        mobs =
        {
            { "Yuhtunga_Mandragora", "Yuhtunga_Jungle", 30 }, -- !gotoid 17281032
            { "Yhoator_Mandragora",  "Yhoator_Jungle",  30 }, -- !gotoid 17285126
        },
        augs = { 1, 14, 31, 2, 97, 2 },
        desc = "HP+15 Evasion+3 Pet: Attack +3",
    },

    [14722] =
    {
        name = "Pigeon Earring",
        mobs =
        {
            { "Thread_Leech", "Korroloka_Tunnel",   30 }, -- !gotoid 17485905
            { "Acrophies", "Lufaise_Meadows",       15 }, -- !gotoid 16875588
            { "Acrophies", "Qufim_Island",          30 }, -- !gotoid 17293478
        },
        augs = { 9, 14, 512, 0, 25, 1 },
        desc = "MP+15, STR+1, Attack+2 ",
    },

    [13635] =
    {
        name = "Cvl. Mantle",
        mobs =
        {
            { "Orcish_Beastrider", "Davoi",           20 }, -- !gotoid 17387579
            { "Orcish_Impaler", "Davoi",              20 }, -- !gotoid 17387578
            { "Orcish_Beastrider", "Lufaise_Meadows", 10 }, -- !gotoid 16875546
            { "Orcish_Impaler", "Lufaise_Meadows",    10 }, -- !gotoid 16875548
        },
        augs = { 33, 1, 39, 1, 145, 1 },
        desc = "DEF:+2, Enmity+2, Counter+2",
    },

    [18606] =
    {
        name = "Passaddhi Staff",
        mobs =
        {
            { "Ooze", "Sea_Serpent_Grotto",             15 }, -- !gotoid 17498220
            { "Spring_Sahagin", "Sea_Serpent_Grotto",   15 }, -- !gotoid 17498195
            { "Lake_Sahagin", "Sea_Serpent_Grotto",     15 }, -- !gotoid 17498214
            { "Pond_Sahagin", "Sea_Serpent_Grotto",     15 }, -- !gotoid 17498215
        },
        augs = { 45, 4, 9, 14, 517, 1, 141, 3 },
        desc = "DMG+5, MP+15, MND+2, Conserve MP+4",
    },

    [13728] =
    {
        name = "Jujitsu Gi",
        mobs =
        {
            { "Orcish_Brawler", "Batallia_Downs",  20 }, -- !gotoid 17207426
            { "Orcish_Brawler", "Lufaise_Meadows", 20 }, -- !gotoid 16875545
        },
        augs = { 1, 14, 552, 1, 142, 0 },
        desc = "HP+15, STR/AGI+2 Store TP+1",
    },

    [12923] =
    {
        name = "Jujitsu Sitabaki",
        mobs =
        {
            { "Orcish_Brawler", "Batallia_Downs",  20 }, -- !gotoid 17207426
            { "Orcish_Brawler", "Lufaise_Meadows", 20 }, -- !gotoid 16875545
        },
        augs = { 1, 9, 550, 1, 142, 0 },
        desc = "HP+10, STR/DEX+2 Store TP+1",
    },

    [13703] =
    {
        name = "Brigandine",
        mobs =
        {
            { "Battering_Ram", "La_Theine_Plateau",   15 }, -- !gotoid 17195143
            { "Tremor_Ram",    "Konschtat_Highlands", 15 }, -- !gotoid 17219885
            { "Tundra_Tiger",  "Beaucedine_Glacier",  30 }, -- !gotoid 17231878
            { "Smilodon",      "Batallia_Downs_[S]",  10 }, -- !gotoid 17121309
        },
        augs = { 17, 9, 552, 1, 25, 3 },
        desc = "HP/MP+10, STR/AGI+2, Attack +4",
    },
}

cexi.trials.novice.storage =
{
    ["Weapons"] =
    {
        { "Beestinger", 16486 },
        { "Light Axe", 16667 },
        { "Pilgrim's Wand", 18394 },
        { "Tropical Punches", 17493 },
        { "Trp. Punches +1", 17494 },
        { "Serpette", 18956 },
        { "Serpette +1", 18959 },
        { "Pike", 19305 },
        { "Katayama", 17811 },
        { "Gelong Staff", 17594 },
        { "Serpette", 18956 },
        { "Felling Axe", 17967 },
        { "Gassan", 18412 },
        { "Rogetsurin", 18246 },
        { "Barbarian's Sword", 16935 },
        { "Ranging Knife", 19119 },
        { "Ranging Knife +1", 19127 },
        { "Nadrs", 17650 },
        { "Anthos Xiphos", 17750 },
        { "Parrying Knife", 16754 },
        { "Astaroth Cane", 18604 },
        { "Eremite's Wand", 17441 },
        { "Eremite's Wand +1", 17442 },
        { "Hawker's Knife", 17630 },
        { "Hawker's Knife +1", 17631 },
        { "Fleuret", 16524 },
        { "Fleuret +1", 16803 },
        { "Steel Kilij", 17739 },
        { "Steel Kilij +1", 17740 },
        { "Passaddhi Staff", 18606 },
        { "Passaddhi Staff +1", 18615 },
    },

    ["Accessories"] =
    {
        { "Jaeger Ring", 14669 },
        { "Mist Silk Cape", 13607 },
        { "Armiger's Lace", 16296 },
        { "Optical Earring", 14803 },
        { "Rabbit Charm", 13112 },
        { "Nomad's Mantle", 13631 },
        { "Nomad's Mantle +1", 13632 },
        { "Griot Belt", 15939 },
        { "Griot Belt +1", 15947 },
        { "Brass Grip", 19009 },
        { "Brass Grip +1", 19010 },
        { "Pigeon Earring", 14722 },
        { "Pigeon Earring +1", 14723 },
        { "Cvl. Mantle", 13635 },
        { "Cvl. Mantle +1", 13636 },
        { "Fidelity Mantle", 11531 },
        { "Blue Cape", 13578 },
        { "Blue Cape +1", 13626 },
    },

    ["Armor I"] =
    {
        { "Pelte", 16185 },
        { "Clipeus", 12371 },
        { "Scale Mail", 12560 },
        { "Solid Mail", 12661 },
        { "Doublet", 12592 },
        { "Doublet +1", 12591 },
        { "Linen Robe", 12601 },
        { "Linen Robe +1", 12626 },
        { "Beetle Mask", 12455 },
        { "Beetle Mask +1", 13827 },
        { "Beetle Harness", 12583 },
        { "Beetle Harness +1", 13717 },
        { "Beetle Mittens", 12711 },
        { "Beetle Mittens +1", 12789 },
        { "Beetle Subligar", 12835 },
        { "Beetle Subligar +1", 12913 },
        { "Beetle Leggings", 12967 },
        { "Btl. Leggings +1", 13043 },
        { "Steam Scale Mail", 12567 },
        { "Entrancing Ribbon", 15218 },
        { "Guerilla Gloves", 15052 },
        { "Battle Gloves", 12799 },
        { "Fungus Hat", 12485 },
        { "Mettle Leggings", 11407 },
        { "Mtt. Leggings +1", 11412 },
        { "Cotton Doublet", 12593 },
        { "Great Doublet", 12669 },
    },

    ["Armor II"] =
    {
        { "Winged Boots", 14132 },
        { "Winged Boots +1", 14133 },
        { "Faerie Tunic", 13731 },
        { "Carbuncle Mitts", 14062 },
        { "Aega's Doublet", 11338 },
        { "Voyager Sallet", 15184 },
        { "Dobson Bandana", 15183 },
        { "Jujitsu Gi", 13728 },
        { "Jujitsu Sitabaki", 12923 },
        { "Brigandine", 13703 },
        { "Brigandine +1", 13710 },
    },
}

cexi.trials.novice.items = {}

for itemType, typeInfo in pairs(cexi.trials.novice.storage) do
    for itemIndex, itemInfo in pairs(typeInfo) do
        cexi.trials.novice.items[itemInfo[2]] = itemIndex
    end
end

cexi.trials.novice.hq_lookup = {}

for itemID, itemInfo in pairs(cexi.trials.novice.upgrade) do
    cexi.trials.novice.hq_lookup[itemInfo[2]] = itemID
end

return m
