-----------------------------------
-- Grand Trials
-----------------------------------
require("modules/module_utils")
----------------------------------------------------------
local m = Module:new("base_trials_grand")

cexi                      = cexi or {}
cexi.trials               = cexi.trials or {}
cexi.trials.grand         = cexi.trials.grand or {}
cexi.trials.grand.upgrade =
{
    [13779] = { "Demon's Cloak",      13780 },
    [13748] = { "Royal Cloak",        13749 },
    [12555] = { "Haubergeon +1",      13735 },
    [12579] = { "Scp. Harness +1",    13734 },
    [13922] = { "Demon Helm +1",      13923 },
    [13703] = { "Brigandine +1",      13710 },
    [13740] = { "Byrnie +1",          13741 },
    [13742] = { "Aketon +1",          13743 },
    [13772] = { "Carnage Aketon",     13773 },
    [13578] = { "Blue Cape +1",       13626 },
    [13775] = { "Blue Cotehard. +1",  13776 },
    [15618] = { "Prince's Slops",     15619 },
    [14539] = { "Kyudogi +1",         14540 },
    [13920] = { "Wyvern Helm +1",     13921 },
}

-- If marks are defined here, they can be reused in multiple trials
cexi.trials.grand.mark    =
{
    {
        name = "Cermet Fragment",
        area = "RoMaeve",
        locs =
        {
            {   10.328, -29.535, 116.749, 220 }, -- !pos 10.328 -29.535 116.749 122
            {   27.010, -28.764,  98.066,   0 }, -- !pos 27.010 -28.764 98.066
            {   96.446,  -9.163,  66.049, 100 }, -- !pos 96.446 -9.163 66.049
            {  127.629,  -8.340,  22.763, 200 }, -- !pos 127.629 -8.340 22.763
            {  166.269,  -4.118,  -7.121, 100 }, -- !pos 166.269 -4.118 -7.121
            {  217.378,  -9.160, -60.526, 160 }, -- !pos 217.378 -9.160 -60.526
            {  -19.170, -28.135,  56.625, 170 }, -- !pos -19.170 -28.135 56.625
            {  -94.419,  -9.317,  67.098,  50 }, -- !pos -94.419 -9.317 67.098
            { -125.419,  -8.148,  28.370, 210 }, -- !pos -125.419 -8.148 28.370
            { -164.763,  -4.000,  -6.690, 160 }, -- !pos -164.763 -4.000 -6.690
            { -199.350,  -8.000, -41.559, 180 }, -- !pos -199.350 -8.000 -41.559
        },
    },
    {
        name = "Mobnesium Alloy",
        area = "Newton_Movalpolos",
        locs =
        {
            {  -48.008, 15.334,   38.777,  59 }, -- !pos -48.008 15.334 38.777 (G-8)
            { -106.201, 11.576, -137.453,  64 }, -- !pos -106.201 11.576 -137.453 (F-10)
            {  119.610, 19.334,  143.235, 100 }, -- !pos 119.610 19.334 143.235 (I-7)
        },
    },
}

cexi.trials.grand.markLookup = {}

for markIndex, markInfo in pairs(cexi.trials.grand.mark) do
    cexi.trials.grand.markLookup[markInfo.name] = markIndex
end

-- If bosses are defined here, they can be reused in multiple trials
cexi.trials.grand.boss    =
{
    {
        mob         = "Deathstalker",
        pop         = "Scorpion Nest",
        area        = "Labyrinth_of_Onzozo",
        groupId     = 33, -- Amikiri
        groupZoneId = 212,
        look        = 2243,
        flags       = 159, -- Make huge
        pos         = { -168.916, 7.668, -101.641, 178 }, -- !pos -168.916 7.668 -101.641 213
        level       = 83,
    },
}

cexi.trials.grand.list    =
{

    [15373] =
    {
        name = "Bravo's Subligar",
        augs = { 553, 1, 185, 2, 211, 1 },
        desc = "DEX+2 AGI+2 \"Resist Gravity\"+3 \"Snapshot\"+2",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 30 Atomic Clusters in Riverne A01, 30 Nitro Clusters in Riverne B01, 10 Overgrown Roses, and 3 Fomor Thieves in Misareaux.",
                mobs =
                {
                    { "Atomic_Cluster", "Riverne-Site_A01", 30 }, -- !gotoid 16900241
                    { "Nitro_Cluster",  "Riverne-Site_B01", 30 }, -- !gotoid 16896057
                    { "Fomor_Thief",     "Misareaux_Coast",  3 }, -- !gotoid 16879815
                    { "Overgrown_Rose",  "Misareaux_Coast", 10 }, -- !gotoid 16879797
                },
            },
            -- Step 2
            {
                desc = "Trade me 72 Cluster Cores 24 Cluster Ashes.",
                item = { { xi.item.CLUSTER_CORE, 72 }, {1630, 24} },
            },
        },
    },

    [13779] =
    {
        name = "Black Cloak",
        augs = { 9, 29, 343, 4, 293, 9 },
        desc = "MP+30 \"Drain\" and \"Aspir\" Potency +5 Dark magic skill +10",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Demons Wizards, 40 Kindred Black Mages, and Price Orobas.",
                mobs =
                {
                    { "Demon_Wizard",       "Castle_Zvahl_Keep", 40 }, -- !gotoid 17440773
                    { "Kindred_Black_Mage", "Dynamis-Xarcabard", 40 }, -- !gotoid 17330237
                    { "Prince_Orobas",      "Xarcabard_[S]",      1 }, -- !spawnmob 17338462 !gototid 17338462
                },
            },
            -- Step 2
            {
                desc = "Trade me 3 Raxa and a Gold Thread.",
                item = { { 1132, 3 }, {823, 1} },
            },
        },
    },

    [13748] =
    {
        name = "Vermillion Cloak",
        augs = { 9, 19, 556, 3, 140, 2 },
        desc = "MP+20 INT/MND/CHR+4, Fast Cast+3",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 60 Robber Crabs, 80 Nightmare Crabs, and Aquarius.",
                mobs =
                {
                    { "Robber_Crab",    "Kuftal_Tunnel",    60 }, -- !gotoid 17489935
                    { "Nightmare_Crab", "Dynamis-Buburimu", 80 }, -- !gotoid 16941212
                    { "Aquarius",       "The_Boyahda_Tree",  1 }, -- !spawnmob 17404000 !gotoid 17404000
                },
            },
            -- Step 2
            {
                desc = "Trade me a Damascene Cloth and 12 Gold Threads.",
                item = { { 836, 1 }, {823, 12} },
            },
        },
    },

    [12555] =
    {
        name = "Haubergeon",
        augs = { 1, 19, 54, 2, 137, 0 },
        desc = "HP+20 Physical dmg. taken -3%% Regen +1",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 60 Diatrymas, 60 Nightmare Rocs, and Kreutzet.",
                mobs =
                {
                    { "Diatryma",      "Misareaux_Coast", 60 }, -- !gotoid 16879839
                    { "Nightmare_Roc", "Dynamis-Qufim",   60 }, -- !gotoid 16945364
                    { "Kreutzet",      "Cape_Teriggan",    1 }, -- !spawnmob 17240413 !gotoid 17240413
                },
            },
            -- Step 2
            {
                desc = "Trade me a Damascus Ingot and 12 Darksteel Chains.",
                item = { { 658, 1 }, {682, 12} },
            },
        },
    },

    [12579] =
    {
        name = "Scorpion Harness",
        augs = { 1, 19, 54, 2, 137, 0 },
        desc = "HP+20 Physical dmg. taken -3%% Regen +1",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Mushussus, 80 Nightmare Scopions, and Amikiri.",
                mobs =
                {
                    { "Mushussu",           "Labyrinth_of_Onzozo", 40 }, -- !gotoid 17649683
                    { "Nightmare_Scorpion", "Dynamis-Buburimu",    80 }, -- !gotoid 16941266
                    { "Amikiri",            "Gustav_Tunnel",        1 }, -- !spawnmob 17645774 !gotoid 17645774
                },
            },
            -- Step 2
            {
                desc = "Trade me a Venemous Claw, 12 Ram Leathers, and 24 Scorpion Shells.",
                item = { {901, 1}, { 851, 12}, {896, 24} },
            },
        },
    },

    [11343] =
    {
        name = "Thrakon Breastplate",
        augs = { 17, 29, 142, 2, 110, 1 },
        desc = "HP+30 MP+30 Store TP +3 Pet: Regen +2",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Diatryma and 40 Phorusrhacos.",
                mobs =
                {
                    { "Diatryma",     "Misareaux_Coast",       40 }, -- !gotoid 16879839
                    { "Phorusrhacos", "Western_Altepa_Desert", 40 }, -- !gotoid 17289364
                },
            },
            -- Step 2
            {
                desc = "Trade me 24 Giant Bird Feathers, 12 Giant Bird Plumes, and 12 Catoblepas Leathers.",
                item = { { 842, 24 }, {843, 12}, {2124, 12} },
            },
        },
    },

    [13804] =
    {
        name = "Minstrel's Coat",
        augs = { 557, 3, 322, 4, 49, 1 },
        desc = "STR+4 CHR +4 Song Spellcasting Time -5%% Haste +2%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Swamp Sahagins, 40 Coastal Sahagins, Fyuu the Seabellow, and Denn the Orcavoiced.",
                mobs =
                {
                    { "Swamp_Sahagin",       "Sea_Serpent_Grotto", 40 }, -- !gotoid 17498422
                    { "Coastal_Sahagin",     "Sea_Serpent_Grotto", 40 }, -- !gotoid 17498432
                    { "Fyuu_the_Seabellow",  "Sea_Serpent_Grotto",  1 }, -- !spawnmob 17498269 !gotoid 17498269
                    { "Denn_the_Orcavoiced", "Sea_Serpent_Grotto",  1 }, -- !spawnmob 17498464 !gotoid 17498464
                },
            },
            -- Step 2
            {
                desc = "Trade me a Cilice, a Scroll of Carnage Elegy, and 24 Shall Shells.",
                item = { {2537, 1}, { 5030, 1 }, {4484, 24} },
            },
        },
    },

    [13740] =
    {
        name = "Byrnie",
        augs = { 527, 2, 25, 4, 143, 0 },
        desc = "STR+3 DEX-3 AGI-3 Attack +5 Double Attack +1%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 80 Ovinniks, Bloodtear Baldurf, and Steelfleece Baldarich.",
                mobs =
                {
                    { "Ovinnik",               "Kuftal_Tunnel",      80 }, -- !gotoid 17490086
                    { "Bloodtear_Baldurf",     "La_Theine_Plateau",   1 }, -- !spawnmob 17195318 !gotoid 17195318
                    { "Steelfleece_Baldarich", "Konschtat_Highlands", 1 }, -- !spawnmob 17219887 !gotoid 17219887
                },
            },
            -- Step 2
            {
                desc = "Trade me 24 Ram Leathers, 24 Ovinnik Leathers, and a Behemoth Leather.",
                item = {  { 851, 24 }, {2122, 24}, {862, 1} },
            },
        },
    },

    [13742] =
    {
        name = "Aketon",
        augs = { 68, 4, 145, 1, 49, 1 },
        desc = "Accuracy+5 Attack+5 Counter+2 Haste +2%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 60 Processionaires, 60 Goblin Enchanters, and Lumber Jack.",
                mobs =
                {
                    { "Processionaire",   "The_Boyahda_Tree",  60 }, -- !gotoid 17404174
                    { "Goblin_Enchanter", "Castle_Zvahl_Keep", 60 }, -- !gotoid 17440802
                    { "Lumber_Jack",      "Batallia_Downs",     1 }, -- !spawnmob 17207308 !gotoid 17207308
                },
            },
            -- Step 2
            {
                desc = "Trade me 6 Platinum Ingots, 12 Gold Threads, and 3 Beetle Bloods.",
                item = {  { 746, 6 }, {823, 12}, {1110, 3} },
            },
        },
    },

    [13772] =
    {
        name = "Bloody Aketon",
        augs = { 515, 3, 23, 8, 37, 5, 137, 0 },
        desc = "AGI+4 Accuracy+9 Magic Evasion+6 Regen+1",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 30 Nightmare Bats, 60 Processionaires, and 3 Habetrot.",
                mobs =
                {
                    { "Nightmare_Bats", "Ifrits_Cauldron",     30 }, -- !gotoid 17617078
                    { "Processionaire", "Crawlers_Nest_[S]",   60 }, -- !gotoid 17477699
                    { "Habetrot",       "Temple_of_Uggalepih",  3 }, -- !spawnmob 17428811 !gotoid 17428811
                },
            },
            -- Step 2
            {
                desc = "Trade me 6 Rainbow Cloths, 12 Gold Threads, and 6 Dragon Bloods.",
                item = {  { 830, 6 }, {823, 12}, {1133, 6} },
            },
        },
    },

    [13578] =
    {
        name = "Blue Cape",
        augs = { 1, 29, 796, 4, 51, 1, 52, 1 },
        desc = "HP+30 All elemental resists+5 HP recovered while healing+2 MP recovered while healing+2",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 50 Sidhes, 30 Ebony Puddings, 20 Poroggos, and Bluestreak Gyugyuroon.",
                mobs =
                {
                    { "Sidhe", "Grauberg_[S]",                       50 }, -- !gotoid 17141989
                    { "Ebony_Pudding", "Mount_Zhayolm",              30 }, -- !gotoid 17092984
                    { "Poroggo", "Mamook",                           20 }, -- !gotoid 17141989
                    { "Bluestreak_Gyugyuroon", "Aydeewa_Subterrane",  1 }, -- !spawnmob 17056156 !gotoid 17056156
                },
            },
            -- Step 2
            {
                desc = "Trade me 12 Silk Cloth and a Beetle Blood.",
                item = { {829, 12}, {1110, 1} },
            },
        },
    },

    [13775] =
    {
        name = "Blue Cotehardie",
        augs = { 1, 39, 130, 4, 1472, 1, 55, 2 },
        desc = "HP+40 Attack+5 Ranged Attack+5 Parry Rate+2 Magic Damage Taken-3%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Chigoes, 30 Pucks, 30 Sweeping Clusters and Nightmare Vase.",
                mobs =
                {
                    { "Chigoe", "Grauberg_[S]",             40 }, -- !gotoid 17141864
                    { "Puck", "Den_of_Rancor",              30 }, -- !gotoid 17432691
                    { "Sweeping_Cluster", "Mount_Zhayolm",  30 }, -- !gotoid 17027205
                    { "Nightmare_Vase", "RoMaeve",           1 }, -- !spawnmob 17092865 !gotoid 17092865
                },
            },
            -- Step 2
            {
                desc = "Trade me 12 Mistletoes, 3 Malboro Fibers, and a Beetle Blood.",
                item = { {918, 12}, {837, 3}, {1110, 1} },
            },
        },
    },
    
-----------------------------------
-- 70-75
-----------------------------------

    [15618] =
    {
        name = "Vendor's Slops",
        augs = { 68, 2, 134, 1, 96, 5 },
        desc = "Accuracy+3 Attack+3 Magic Def. Bonus+2 Pet: Accuracy+6 Ranged Accuracy+6",
        step =
        {
            -- Step 1
            {
                desc = "Defeat Arrapago Monsters and Euryale.",
                mobs =
                {
                    { "Heraldic_Imp", "Caedarva_Mire",      30 }, -- !gotoid 17100930
                    { "Jnun", "Caedarva_Mire",              20 }, -- !gotoid 17100936
                    { "Spongilla_Fly", "Caedarva_Mire",     30 }, -- !gotoid 17100929
                    { "Mosshorn", "Caedarva_Mire",          20 }, -- !gotoid 17100965
                    { "Lamia_Idolater", "Arrapago_Reef",    30 }, -- !gotoid 16998699
                    { "Euryale", "Arrapago_Reef",            1 }, -- !spawnmob 16998696 !gotoid 16998696
                },
            },
            -- Step 2
            {
                desc = "Trade me 6 Scarlet Linens, 3 Imperial Silk Cloths, and a Karakul Leather.",
                item = { {1699, 6}, {2340, 3}, {879, 1} },
            },
        },
    },

    [14469] =
    {
        name = "Reverend Mail",
        augs = { 1, 29, 49, 2, 142, 2 },
        desc = "HP+30 Haste+3%% \"Store TP\"+3",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Coralline Uragnites, 80 Nightmare Uragnites, and Harajnite.",
                mobs =
                {
                    { "Coralline_Uragnite", "Bibiki_Bay",       40 }, -- !gotoid 16793608
                    { "Nightmare_Uragnite", "Dynamis-Buburimu", 80 }, -- !gotoid 16941250
                    { "Harajnite",          "Manaclipper",       1 }, -- !spawnmob 16789509 !gotoid 16789509
                },
            },
            -- Step 2
            {
                desc = "Retrieve a Mobnesium Alloy in Newton Movalpolos at (G-8), (F-10), or (I-7).",
                mark =
                {
                    name = "Mobnesium Alloy",
                    area = "Newton_Movalpolos",
                },
            },
            -- Step 3
            {
                desc = "Trade me 3 Moblumin Sheets, 6 Moblin Putties, and 72 Beeswaxes.",
                item = { {1859, 3}, { 1860, 6 }, {913, 72} },
            },
        },
    },

    [14468] =
    {
        name = "Yinyang Robe",
        augs = { 9, 29, 55, 2, 99, 14 },
        desc = "MP+30 Magic dmg. taken -3%% Pet: DEF+15",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Ominous Weapons, 80 Nightmare Weapons, and Barbaric Weapon",
                mobs =
                {
                    { "Ominous_Weapon",   "RoMaeve",       40 }, -- !gotoid 17276933
                    { "Nightmare_Weapon", "Dynamis-Qufim", 80 }, -- !gotoid 16945288
                    { "Barbaric_Weapon",  "Xarcabard",      1 }, -- !spawnmob 17236027 !gotoid 17236027
                },
            },
            -- Step 2
            {
                desc = "Find the Cermet Fragment in Ro'Maeve.",
                mark =
                {
                    name = "Cermet Fragment",
                    area = "RoMaeve",
                },
            },
            -- Step 3
            {
                desc = "Trade me a Shining Cloth, 12 Silk Cloth, and 12 Velvet Cloth.",
                item = { { 831, 1}, {829, 12}, {828, 12} },
            },
        },
    },

    [13922] =
    {
        name = "Demon Helm",
        augs = { 17, 14, 292, 4, 322, 2 },
        desc = "HP/MP+15 Elem. magic skill +5 Song spellcasting time -3%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Dread Demons, 80 Demon Magus, and Marquis Amon.",
                mobs =
                {
                    { "Dread_Demon",  "Uleguerand_Range",     40 }, -- !gotoid 16797831
                    { "Demon_Magus",  "Xarcabard_[S]",        80 }, -- !gotoid 17338449
                    { "Marquis_Amon", "Castle_Zvahl_Baileys",  1 }, -- !spawnmob 17436918 !gotoid 17436918
                },
            },
            -- Step 2
            {
                desc = "Trade me a 3 Demon Skulls and 6 Demon Horns.",
                item = { { 886, 3 }, {902, 6} },
            },
        },
    },

    [15325] =
    {
        name = "Evoker's Boots",
        augs = { 17, 14, 141, 2, 329, 2 },
        desc = "HP/MP+15 Conserve MP+3 \"Cure\" Potency +3%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Tonberry Dismayers, 60 Tonberry Beleaguerers, and Tonberry Kinq.",
                mobs =
                {
                    { "Tonberry_Dismayer",    "Temple_of_Uggalepih", 40 }, -- !gotoid 17428673
                    { "Tonberry_Beleaguerer", "Den_of_Rancor",       60 }, -- !gotoid 17432632
                    { "Tonberry_Kinq",        "Temple_of_Uggalepih",  1 }, -- !spawnmob 17428677 !gotoid 17428677
                },
            },
            -- Step 2
            {
                desc = "Trade me an Ephemeral Cloth, 3 Phoenix Feathers, and 3 Raxa.",
                item = { { 2838, 1 }, {844, 3}, {1132, 3} },
            },
        },
    },

    [13915] =
    {
        name = "Optical Hat",
        augs = { 1, 14, 553, 2, 49, 2 },
        desc = "HP+15 DEX/AGI+3 Haste+3%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Mindgazers, 40 Dodomeki, and 3 Hakutaku.",
                mobs =
                {
                    { "Mindgazer", "Sea_Serpent_Grotto", 40 }, -- !gotoid 17498523
                    { "Dodomeki",  "Ifrits_Cauldron",    40 }, -- !gotoid 17616977
                    { "Hakutaku",  "Den_of_Rancor",       3 }, -- !spawnmob 17433005 !gotoid 17433005
                },
            },
            -- Step 2
            {
                desc = "Find the Cermet Fragment in Ro'Maeve.",
                mark =
                {
                    name = "Cermet Fragment",
                    area = "RoMaeve",
                },
            },
            -- Step 3
            {
                desc = "Trade me a Flint Glass Sheet, an Eyeball Soup, and 12 Skeleton Keys.",
                item = { {2460, 1}, { 4453, 1 }, {1115, 12} },
            },
        },
    },

    [15223] =
    {
        name = "Ace's Helm",
        augs = { 17, 14, 513, 3, 54, 1 },
        desc = "HP+15 MP+15 DEX+4 Phys. dmg. taken -2%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat Deathstalker in Labyrinth of Onzozo!",
                boss =
                {
                    mob         = "Deathstalker",
                    pop         = "Scorpion Nest",
                    area        = "Labyrinth_of_Onzozo",
                    item        =
                    {
                        "Three Venomous Claws",
                        { { 901, 3 } },
                    },
                },
            },
            -- Step 2
            {
                desc = "Retrieve a Mobnesium Alloy in Newton Movalpolos at (G-8), (F-10), or (I-7).",
                mark =
                {
                    name = "Mobnesium Alloy",
                    area = "Newton_Movalpolos",
                },
            },
            -- Step 3
            {
                desc = "Trade me a Wolf Felt, 12 Griffon Leathers, and 12 H.Q. Scorpion Shells.",
                item = { {2010, 1}, { 1459, 12 }, {1473, 12} },
            },
        },
    },
    
    [14539] =
    {
        name = "Kyudogi",
        augs = { 552, 2, 332, 2, 333, 4, 55, 1 },
        desc = "STR+3 AGI+3 Skillchain Damage+3%% Conserve TP+5 Magic Damage Taken-2%%",
        step =
        {
            -- Step 1
            {
                desc = "Defeat Khimaira, Cerberus, and Hydra!",
                mobs =
                {
                    { "Khimaira", "Caedarva_Mire",            1 }, -- !spawnmob 17101197 !gotoid 17101197
                    { "Cerberus", "Mount_Zhayolm",            1 }, -- !spawnmob 17027458 !gotoid 17027458
                    { "Hydra", "Wajaom_Woodlands",            1 }, -- !spawnmob 16986355 !gotoid 16986355
                },
            },
            -- Step 2
            {
                desc = "Trade me 6 Sailcloths, 3 Cerberus Leather, and a Scintillant Ingot.",
                item = { {1997, 6}, {2170, 3}, {2275, 1} },
            },
        },
    },
 
    [13920] =
    {
        name = "Wyvern Helm",
        augs = { 68, 5, 333, 5 },
        desc = "Accuracy+6 Attack+6 Conserve TP+6",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 40 Sea Puks, 80 Ajattaras, and Scitalis.",
                mobs =
                {
                    { "Sea_Puk",  "Bhaflau_Thickets", 40 }, -- !gotoid 16990383
                    { "Ajattara", "Grauberg_[S]",     80 }, -- !gotoid 17141977
                    { "Scitalis", "Grauberg_[S]",      1 }, -- !spawnmob 17141979 !gotoid 17141979
                },
            },
            -- Step 2
            {
                desc = "Trade me 12 Wyvern Scales, 24 Wyvern Skins, and 12 Wyvern Wings.",
                item = { {xi.item.HANDFUL_OF_WYVERN_SCALES, 12}, {xi.item.WYVERN_SKIN, 24}, {xi.item.WYVERN_WING, 12} },
            },
        },
    },

    [15270] =
    {
        name = "Walahra Turban",
        augs = { 17, 19, 796, 4, 188, 14 },
        desc = "HP+20 MP+20 All elemental resistances+5 \"Resist Charm\"+15",
        step =
        {
            -- Step 1
            {
                desc = "Defeat 60 Merrow Chantresses, 60 Mamool Ja Bounders, and 60 Troll Cuirassers.",
                mobs =
                {
                    { "Merrow_Chantress",  "Arrapago_Reef",  60 }, -- !gotoid 16998409
                    { "Mamool_Ja_Bounder", "Mamook",         60 }, -- !gotoid 17043474
                    { "Troll_Cuirasser",   "Halvung",        60 }, -- !gotoid 17031407
                },
            },
            -- Step 2
            {
                desc = "Trade me 99 Imperial Gold Pieces.",
                item = { {2187, 99} },
            },
        },
    },
}

cexi.trials.grand.storage =
{
    ["Armor I"] =
    {
        { "Bravo's Subligar",    15373 },
        { "Black Cloak",         13779 },
        { "Demon's Cloak",       13780 },
        { "Vermillion Cloak",    13748 },
        { "Royal Cloak",         13749 },
        { "Haubergeon",          12555 },
        { "Haubergeon +1",       13735 },
        { "Scorpion Harness",    12579 },
        { "Scp. Harness +1",     13734 },
        { "Minstrel's Coat",     13804 },
        { "Byrnie",              13740 },
        { "Byrnie +1",           13741 },
        { "Aketon",              13742 },
        { "Aketon +1",           13743 },
        { "Bloody Aketon",       13772 },
        { "Carnage Aketon",      13773 },
    },

    ["Armor II"] =
    {
        { "Thrakon Breastplate", 11343 },
        { "Reverend Mail",       14469 },
        { "Yinyang Robe",        14468 },
        { "Demon Helm",          13922 },
        { "Demon Helm +1",       13923 },
        { "Evoker's Boots",      15325 },
        { "Optical Hat",         13915 },
        { "Ace's Helm",          15223 },
        { "Blue Cotehardie",     13775 },
        { "Blue Cotehard. +1",   13776 },
        { "Vendor's Slops",      15618 },
        { "Prince's Slops",      15619 },
        { "Kyudogi",             14539 },
        { "Kyudogi +1",          14540 },
        { "Wyvern Helm",         13920 },
        { "Wyvern Helm +1",      13921 },
    },
    
    ["Armor III"] =
    {
        { "Walahra Turban",      15270 },
    },
    
}

cexi.trials.grand.items = {}

for itemType, typeInfo in pairs(cexi.trials.grand.storage) do
    for itemIndex, itemInfo in pairs(typeInfo) do
        cexi.trials.grand.items[itemInfo[2]] = itemIndex
    end
end

cexi.trials.grand.hq_lookup = {}

for itemID, itemInfo in pairs(cexi.trials.grand.upgrade) do
    cexi.trials.grand.hq_lookup[itemInfo[2]] = itemID
end

return m
