-----------------------------------
-- Update Guild Vendor Prices
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("base_guilds")

local adjustments =
{

    -- Alchemy
    [912]  =   350, -- Beehive Chip   (  40)
    [937]  =   500, -- Animal Glue    ( 300)
    [921]  =   600, -- Ahriman Tears  ( 200)

    -- Bonecraft
    [880]  =   350, -- Bone Chip      ( 150)
    [864]  =   250, -- Fish Scales    (  96)
    [893]  =  1800, -- Giant Femur    (1400)
    [889]  =   800, -- Beetle Shell   ( 500)
    [894]  =  1800, -- Beetle Jaw     (1000)
    [884]  =  2300, -- Bk. Tiger Fang (2000)

    -- Clothcraft
    [833]  =    80, -- Moko Grass     (  50)
    [1845] =   900, -- Red Moko Grass ( 200)
    [819]  =  1200, -- Linen Thread   ( 150)

    -- Goldsmithing
    [642]  =   550, -- Zinc Ore       ( 200)
    [1231] =   150, -- Brass Nugget   (  40)
    [661]  =   600, -- Brass Sheet    ( 300)
    [736]  =   800, -- Silver Ore     ( 450)
    [1233] =   300, -- Silver Nugget  ( 200)

    -- Leathercraft
    [505]  =   350, -- Sheepskin      ( 100)
    [856]  =   150, -- Rabbit Hide    (  80)
    [878]  =  1800, -- Karakul Skin   ( 600)
    [858]  =  1500, -- Wolf Hide      ( 600)
    [1640] =  3500, -- Bugard Skin    (2500)
    [859]  =  2500, -- Ram Skin       (1500)

    -- Smithing
    [645]  = 12000, -- Darksteel Ore  (7000)

    -- Woodworking
    [688]  =    60, -- Arrowwood Log  (  25)
    [689]  =   150, -- Lauan Log      (  50)
    [691]  =   200, -- Maple Log      (  70)
    [690]  =  6000, -- Elm Log        (3800)
    [699]  =  7000, -- Oak Log        (4000)
    [700]  =  8000, -- Mahogany Log   (4500)
    [702]  =  9000, -- Ebony Log      (5000)
    [2761] = 12000, -- Feyweald Log   (5500)
}

m:addOverride("xi.shop.generalGuild", function(player, stock, guildSkillId)
    local log = -1

    player:createShop(#stock / 3, log)

    for i = 1, #stock, 3 do
        if adjustments[stock[i]] ~= nil then
            player:addShopItem(stock[i], adjustments[stock[i]], guildSkillId, stock[i + 2])
        else
            player:addShopItem(stock[i], stock[i + 1], guildSkillId, stock[i + 2])
        end
    end

    player:sendMenu(2)
end)

return m
