-----------------------------------
-- CW Scrolls
-----------------------------------
local m = Module:new("base_cw_scrolls")

cexi                         = cexi or {}
cexi.crystal_warrior         = cexi.crystal_warrior or {}
cexi.crystal_warrior.scrolls =
{
    ["White Magic"] =
    {
        {   -- Page 1
            { "Cure",            4609 },
            { "Cure II",         4610 },
            { "Cure III",        4611 },
            { "Cure IV",         4612 },

            { "Cure V",          4613 },
            { "Cure VI",         4614 },
            { "Curaga",          4615 },
            { "Curaga II",       4616 },

            { "Curaga III",      4617 },
            { "Curaga IV",       4618 },
            { "Curaga V",        4619 },
            { "Raise",           4620 },

            { "Raise II",        4621 },
            { "Poisona",         4622 },
            { "Paralyna",        4623 },
            { "Blindna",         4624 },

            { "Silena",          4625 },
            { "Stona",           4626 },
            { "Viruna",          4627 },
            { "Cursna",          4628 },

            { "Holy",            4629 },
            { "Holy II",         4630 },
            { "Dia",             4631 },
            { "Dia II",          4632 },

            { "Dia III",         4633 },
            { "Banish",          4636 },
            { "Banish II",       4637 },
            { "Banish III",      4638 },

            { "Diaga",           4641 },
            { "Banishga",        4646 },
            { "Banishga II",     4647 },
            { "Protect",         4651 },
        },
        {   -- Page 2
            { "Protect II",      4652 },
            { "Protect III",     4653 },
            { "Protect IV",      4654 },
            { "Protect V",       4655 },

            { "Shell",           4656 },
            { "Shell II",        4657 },
            { "Shell III",       4658 },
            { "Shell IV",        4659 },

            { "Shell V",         4660 },
            { "Blink",           4661 },
            { "Stoneskin",       4662 },
            { "Aquaveil",        4663 },

            { "Slow",            4664 },
            { "Haste",           4665 },
            { "Paralyze",        4666 },
            { "Silence",         4667 },

            { "Barfire",         4668 },
            { "Barblizzard",     4669 },
            { "Baraero",         4670 },
            { "Barstone",        4671 },

            { "Barthunder",      4672 },
            { "Barwater",        4673 },
            { "Barfira",         4674 },
            { "Barblizzara",     4675 },

            { "Baraera",         4676 },
            { "Barstonra",       4677 },
            { "Barthundra",      4678 },
            { "Barwatera",       4679 },

            { "Barsleep",        4680 },
            { "Barpoison",       4681 },
            { "Barparalyze",     4682 },
            { "Barblind",        4683 },
        },
        {   -- Page 3
            { "Barsilence",      4684 },
            { "Barpetrify",      4685 },
            { "Barvirus",        4686 },
            { "Recall-Jugner",   4687 },

            { "Recall-Pashh",    4688 },
            { "Recall-Meriph",   4689 },
            { "Baramnesia",      4690 },
            { "Baramnesra",      4691 },

            { "Haste II",        4692 },
            { "Barsleepra",      4694 },
            { "Barpoisonra",     4695 },
            { "Barparalyzra",    4696 },

            { "Barblindra",      4697 },
            { "Barsilencera",    4698 },
            { "Barpetra",        4699 },
            { "Barvira",         4700 },

            { "Cura",            4701 },
            { "Sacrifice",       4702 },
            { "Esuna",           4703 },
            { "Auspice",         4704 },

            { "Temper",          4705 },
            { "Enlight",         4706 },
            { "Enfire",          4708 },
            { "Enblizzard",      4709 },

            { "Enaero",          4710 },
            { "Enstone",         4711 },
            { "Enthunder",       4712 },
            { "Enwater",         4713 },

            { "Phalanx",         4714 },
            { "Reprisal",        4715 },
            { "Regen",           4716 },
            { "Refresh",         4717 },
        },
        {   -- Page 4
            { "Regen II",        4718 },
            { "Regen III",       4719 },
            { "Flash",           4720 },
            { "Repose",          4721 },

            { "Enfire II",       4722 },
            { "Enblizzard II",   4723 },
            { "Enaero II",       4724 },
            { "Enstone II",      4725 },

            { "Enthunder II",    4726 },
            { "Enwater II",      4727 },
            { "Teleport-Yhoat",  4728 },
            { "Teleport-Altep",  4729 },

            { "Teleport-Holla",  4730 },
            { "Teleport-Dem",    4731 },
            { "Teleport-Mea",    4732 },
            { "Protectra",       4733 },

            { "Protectra II",    4734 },
            { "Protectra III",   4735 },
            { "Protectra IV",    4736 },
            { "Protectra V",     4737 },

            { "Shellra",         4738 },
            { "Shellra II",      4739 },
            { "Shellra III",     4740 },
            { "Shellra IV",      4741 },

            { "Shellra V",       4742 },
            { "Reraise",         4743 },
            { "Invisible",       4744 },
            { "Sneak",           4745 },

            { "Deodorize",       4746 },
            { "Teleport-Vahzl",  4747 },
            { "Raise III",       4748 },
            { "Reraise II",      4749 },
        },
        {   -- Page 5
            { "Reraise III",     4750 },
            { "Erase",           4751 },
            { "Addle",           4849 },
            { "Refresh II",      4850 },

            { "Cura II",         5082 },
            { "Cura III",        5083 },
            { "Regen IV",        5085 },
            { "Regen V",         5086 },

            { "Gain-STR",        5087 },
            { "Gain-DEX",        5088 },
            { "Gain-VIT",        5089 },
            { "Gain-AGI",        5090 },

            { "Gain-INT",        5091 },
            { "Gain-MND",        5092 },
            { "Gain-CHR",        5093 },
            { "Boost-STR",       5094 },

            { "Boost-DEX",       5095 },
            { "Boost-VIT",       5096 },
            { "Boost-AGI",       5097 },
            { "Boost-INT",       5098 },

            { "Boost-MND",       5099 },
            { "Boost-CHR",       5100 },
            { "Arise",           5101 },
            { "Foil",            5102 },

            { "Crusade",         5103 },
            { "Flurry",          5104 },
            { "Flurry II",       5105 },
            { "Inundation",      5106 },

            { "Firestorm",       6049 },
            { "Rainstorm",       6050 },
            { "Thunderstorm",    6051 },
            { "Hailstorm",       6052 },
        },
        {   -- Page 6
            { "Sandstorm",       6053 },
            { "Windstorm",       6054 },
            { "Aurorastorm",     6055 },
            { "Voidstorm",       6056 },

            { "Animus Augeo",    6059 },
            { "Animus Minuo",    6060 },
            { "Adloquium",       6061 },
            { "Slow II",         6569 },

            { "Paralyze II",     6570 },
            { "Phalanx II",      6571 },
        },
    },
    ["Black Magic"] =
    {
        {   -- Page 1
            { "Endark",          4707 },
            { "Fire",            4752 },
            { "Fire II",         4753 },
            { "Fire III",        4754 },

            { "Fire IV",         4755 },
            { "Fire V",          4756 },
            { "Blizzard",        4757 },
            { "Blizzard II",     4758 },

            { "Blizzard III",    4759 },
            { "Blizzard IV",     4760 },
            { "Blizzard V",      4761 },
            { "Aero",            4762 },

            { "Aero II",         4763 },
            { "Aero III",        4764 },
            { "Aero IV",         4765 },
            { "Aero V",          4766 },

            { "Stone",           4767 },
            { "Stone II",        4768 },
            { "Stone III",       4769 },
            { "Stone IV",        4770 },

            { "Stone V",         4771 },
            { "Thunder",         4772 },
            { "Thunder II",      4773 },
            { "Thunder III",     4774 },

            { "Thunder IV",      4775 },
            { "Thunder V",       4776 },
            { "Water",           4777 },
            { "Water II",        4778 },

            { "Water III",       4779 },
            { "Water IV",        4780 },
            { "Water V",         4781 },
            { "Firaga",          4782 },
        },
        {   -- Page 2
            { "Firaga II",       4783 },
            { "Firaga III",      4784 },
            { "Blizzaga",        4787 },
            { "Blizzaga II",     4788 },

            { "Blizzaga III",    4789 },
            { "Aeroga",          4792 },
            { "Aeroga II",       4793 },
            { "Aeroga III",      4794 },

            { "Stonega",         4797 },
            { "Stonega II",      4798 },
            { "Stonega III",     4799 },
            { "Thundaga",        4802 },

            { "Thundaga II",     4803 },
            { "Thundaga III",    4804 },
            { "Waterga",         4807 },
            { "Waterga II",      4808 },

            { "Waterga III",     4809 },
            { "Flare",           4812 },
            { "Flare II",        4813 },
            { "Freeze",          4814 },

            { "Freeze II",       4815 },
            { "Tornado",         4816 },
            { "Tornado II",      4817 },
            { "Quake",           4818 },

            { "Quake II",        4819 },
            { "Burst",           4820 },
            { "Burst II",        4821 },
            { "Flood",           4822 },

            { "Flood II",        4823 },
            { "Gravity",         4824 },
            { "Gravity II",      4825 },
            { "Comet",           4827 },
        },
        {   -- Page 3
            { "Poison",          4828 },
            { "Poison II",       4829 },
            { "Poisonga",        4833 },
            { "Poisonga II",     4834 },

            { "Bio",             4838 },
            { "Bio II",          4839 },
            { "Bio III",         4840 },
            { "Burn",            4843 },

            { "Frost",           4844 },
            { "Choke",           4845 },
            { "Rasp",            4846 },
            { "Shock",           4847 },

            { "Drown",           4848 },
            { "Meteor",          4851 },
            { "Drain",           4853 },
            { "Drain II",        4854 },

            { "Aspir",           4855 },
            { "Aspir II",        4856 },
            { "Blaze Spikes",    4857 },
            { "Ice Spikes",      4858 },

            { "Shock Spikes",    4859 },
            { "Stun",            4860 },
            { "Sleep",           4861 },
            { "Blind",           4862 },

            { "Break",           4863 },
            { "Bind",            4866 },
            { "Sleep II",        4867 },
            { "Dispel",          4868 },

            { "Warp",            4869 },
            { "Warp II",         4870 },
            { "Escape",          4871 },
            { "Tractor",         4872 },
        },
        {   -- Page 4
            { "Retrace",         4873 },
            { "Absorb-STR",      4874 },
            { "Absorb-DEX",      4875 },
            { "Absorb-VIT",      4876 },

            { "Absorb-AGI",      4877 },
            { "Absorb-INT",      4878 },
            { "Absorb-MND",      4879 },
            { "Absorb-CHR",      4880 },

            { "Sleepga",         4881 },
            { "Sleepga II",      4882 },
            { "Absorb-TP",       4883 },
            { "Blind II",        4884 },

            { "Dread Spikes",    4885 },
            { "Absorb-Acc",      4886 },
            { "Absorb-Attri",    4887 },
            { "Breakga",         4889 },

            { "Firaja",          4890 },
            { "Blizzaja",        4891 },
            { "Aeroja",          4892 },
            { "Stoneja",         4893 },

            { "Thundaja",        4894 },
            { "Waterja",         4895 },
            { "Distract",        4912 },
            { "Distract II",     4913 },

            { "Frazzle",         4914 },
            { "Frazzle II",      4915 },
            { "Fira",            4916 },
            { "Fira II",         4917 },

            { "Blizzara",        4918 },
            { "Blizzara II",     4919 },
            { "Aerora",          4920 },
            { "Aerora II",       4921 },
        },
        {   -- Page 5
            { "Stonera",         4922 },
            { "Stonera II",      4923 },
            { "Thundara",        4924 },
            { "Thundara II",     4925 },

            { "Watera",          4926 },
            { "Watera II",       4927 },
            { "Pyrohelix",       6041 },
            { "Hydrohelix",      6042 },

            { "Ionohelix",       6043 },
            { "Cryohelix",       6044 },
            { "Geohelix",        6045 },
            { "Anemohelix",      6046 },

            { "Luminohelix",     6047 },
            { "Noctohelix",      6048 },
        },
    },
    ["Summoning"] =
    {
        {   -- Page 1
            { "Fire Spirit",     4896 },
            { "Ice Spirit",      4897 },
            { "Air Spirit",      4898 },
            { "Earth Spirit",    4899 },

            { "Thunder Spirit",  4900 },
            { "Water Spirit",    4901 },
            { "Light Spirit",    4902 },
            { "Dark Spirit",     4903 },
        },
    },
    ["Ninjutsu"] =
    {
        {   -- Page 1
            { "Katon: Ichi",     4928 },
            { "Katon: Ni",       4929 },
            { "Katon: San",      4930 },
            { "Hyoton: Ichi",    4931 },

            { "Hyoton: Ni",      4932 },
            { "Hyoton: San",     4933 },
            { "Huton: Ichi",     4934 },
            { "Huton: Ni",       4935 },

            { "Huton: San",      4936 },
            { "Doton: Ichi",     4937 },
            { "Doton: Ni",       4938 },
            { "Doton: San",      4939 },

            { "Raiton: Ichi",    4940 },
            { "Raiton: Ni",      4941 },
            { "Raiton: San",     4942 },
            { "Suiton: Ichi",    4943 },

            { "Suiton: Ni",      4944 },
            { "Suiton: San",     4945 },
            { "Utsusemi: Ichi",  4946 },
            { "Utsusemi: Ni",    4947 },

            { "Jubaku: Ichi",    4949 },
            { "Hojo: Ichi",      4952 },
            { "Hojo: Ni",        4953 },
            { "Kurayami: Ichi",  4955 },

            { "Kurayami: Ni",    4956 },
            { "Dokumori: Ichi",  4958 },
            { "Tonko: Ichi",     4961 },
            { "Tonko: Ni",       4962 },

            { "Monomi: Ichi",    4964 },
            { "Aisha: Ichi",     4965 },
            { "Myoshu: Ichi",    4966 },
            { "Yurin: Ichi",     4967 },
        },
        {   -- Page 2
            { "Kakka: Ichi",     4968 },
            { "Migawari: Ichi",  4969 },
            { "Gekka: Ichi",     4970 },
            { "Yain: Ichi",      4971 },
        },
    },
    ["Songs"] =
    {
        {   -- Page 1
            { "Foe Requiem",       4976 },
            { "Foe Requiem II",    4977 },
            { "Foe Requiem III",   4978 },
            { "Foe Requiem IV",    4979 },

            { "Foe Requiem V",     4980 },
            { "Foe Requiem VI",    4981 },
            { "Foe Requiem VII",   4982 },
            { "Horde Lullaby",     4984 },

            { "Horde Lullaby II",  4985 },
            { "Armys Paeon",       4986 },
            { "Armys Paeon II",    4987 },
            { "Armys Paeon III",   4988 },

            { "Armys Paeon IV",    4989 },
            { "Armys Paeon V",     4990 },
            { "Armys Paeon VI",    4991 },
            { "Mages Ballad",      4994 },

            { "Mages Ballad II",   4995 },
            { "Mages Ballad III",  4996 },
            { "Knights Minne",     4997 },
            { "Knights Minne II",  4998 },

            { "Knights Minne III", 4999 },
            { "Knights Minne IV",  5000 },
            { "Knights Minne V",   5001 },
            { "Valor Minuet",      5002 },

            { "Valor Minuet II",   5003 },
            { "Valor Minuet III",  5004 },
            { "Valor Minuet IV",   5005 },
            { "Valor Minuet V",    5006 },

            { "Sword Madrigal",    5007 },
            { "Blade Madrigal",    5008 },
            { "Hunters Prelude",   5009 },
            { "Archers Prelude",   5010 },
        },
        {   -- Page 2
            { "Sheepfoe Mambo",    5011 },
            { "Dragonfoe Mambo",   5012 },
            { "Fowl Aubade",       5013 },
            { "Herb Pastoral",     5014 },

            { "Shining Fantasia",  5016 },
            { "Scops Operetta",    5017 },
            { "Puppets Operetta",  5018 },
            { "Gold Capriccio",    5020 },

            { "Warding Round",     5022 },
            { "Goblin Gavotte",    5023 },
            { "Advancing March",   5027 },
            { "Victory March",     5028 },

            { "Battlefield Elegy", 5029 },
            { "Carnage Elegy",     5030 },
            { "Sinewy Etude",      5032 },
            { "Dextrous Etude",    5033 },

            { "Vivacious Etude",   5034 },
            { "Quick Etude",       5035 },
            { "Learned Etude",     5036 },
            { "Spirited Etude",    5037 },

            { "Enchanting Etude",  5038 },
            { "Herculean Etude",   5039 },
            { "Uncanny Etude",     5040 },
            { "Vital Etude",       5041 },

            { "Swift Etude",       5042 },
            { "Sage Etude",        5043 },
            { "Logical Etude",     5044 },
            { "Bewitching Etude",  5045 },

            { "Fire Carol",        5046 },
            { "Ice Carol",         5047 },
            { "Wind Carol",        5048 },
            { "Earth Carol",       5049 },
        },
        {   -- Page 3
            { "Lightning Carol",   5050 },
            { "Water Carol",       5051 },
            { "Light Carol",       5052 },
            { "Dark Carol",        5053 },

            { "Fire Carol II",     5054 },
            { "Ice Carol II",      5055 },
            { "Wind Carol II",     5056 },
            { "Earth Carol II",    5057 },

            { "Lightning Carol II", 5058 },
            { "Water Carol II",    5059 },
            { "Light Carol II",    5060 },
            { "Dark Carol II",     5061 },

            { "Fire Threnody",     5062 },
            { "Ice Threnody",      5063 },
            { "Wind Threnody",     5064 },
            { "Earth Threnody",    5065 },

            { "Ltng. Threnody",    5066 },
            { "Water Threnody",    5067 },
            { "Light Threnody",    5068 },
            { "Dark Threnody",     5069 },

            { "Magic Finale",      5070 },
            { "Foe Lullaby",       5071 },
            { "Goddesss Hymnus",   5072 },
            { "Chocobo Mazurka",   5073 },

            { "Maidens Virelai",   5074 },
            { "Raptor Mazurka",    5075 },
            { "Foe Sirvente",      5076 },
            { "Adventurers Dirge", 5077 },

            { "Sentinels Scherzo", 5078 },
            { "Foe Lullaby II",    5079 },
            { "Pining Nocturne",   5080 },
        },
    },
    ["Dice"] =
    {
        {
            { "Warrior Die",      5477 },
            { "Monk Die",         5478 },
            { "White Mage Die",   5479 },
            { "Black Mage Die",   5480 },

            { "Red Mage Die",     5481 },
            { "Thief Die",        5482 },
            { "Paladin Die",      5483 },
            { "Dark Knight Die",  5484 },

            { "Beastmaster Die",  5485 },
            { "Bard Die",         5486 },
            { "Ranger Die",       5487 },
            { "Samurai Die",      5488 },

            { "Ninja Die",        5489 },
            { "Dragoon Die",      5490 },
            { "Summoner Die",     5491 },
            { "Blue Mage Die",    5492 },

            { "Corsair Die",      5493 },
            { "Puppetmaster Die", 5494 },
            { "Dancer Die",       5495 },
            { "Scholar Die",      5496 },

            { "Bolters Die",      5497 },
            { "Casters Die",      5498 },
            { "Coursers Die",     5499 },
            { "Blitzers Die",     5500 },

            { "Tacticians Die",   5501 },
            { "Allies Die",       5502 },
            { "Misers Die",       5503 },
            { "Companions Die",   5504 },

            { "Avengers Die",     5505 },
            { "Geomancer Die",    6368 },
            { "Rune Fencer Die",  6369 },
        },
    },
    ["Geomancy"] =
    {
        {
            { "Indi-Regen",      6073 },
            { "Indi-Poison",     6074 },
            { "Indi-Refresh",    6075 },
            { "Indi-STR",        6076 },

            { "Indi-DEX",        6077 },
            { "Indi-VIT",        6078 },
            { "Indi-AGI",        6079 },
            { "Indi-INT",        6080 },

            { "Indi-MND",        6081 },
            { "Indi-CHR",        6082 },
            { "Indi-Fury",       6083 },
            { "Indi-Barrier",    6084 },

            { "Indi-Acumen",     6085 },
            { "Indi-Fend",       6086 },
            { "Indi-Precision",  6087 },
            { "Indi-Voidance",   6088 },

            { "Indi-Focus",      6089 },
            { "Indi-Attunement", 6090 },
            { "Indi-Wilt",       6091 },
            { "Indi-Frailty",    6092 },

            { "Indi-Fade",       6093 },
            { "Indi-Malaise",    6094 },
            { "Indi-Slip",       6095 },
            { "Indi-Torpor",     6096 },

            { "Indi-Vex",        6097 },
            { "Indi-Languor",    6098 },
            { "Indi-Slow",       6099 },
            { "Indi-Paralysis",  6100 },

            { "Indi-Gravity",    6101 },
            { "Indi-Haste",      6131 },
        },
    },
}

cexi.crystal_warrior.scrolls_tradeable = {}

for category, tier in pairs(cexi.crystal_warrior.scrolls) do
    for tierIndex, tierInfo in pairs(tier) do
        for scrollIndex, scrollInfo in pairs(tierInfo) do
            cexi.crystal_warrior.scrolls_tradeable[scrollInfo[2]] =
            {
                scrollIndex - 1,
                scrollInfo[1],
                category,
                tierIndex,
            }
        end
    end
end

cexi.crystal_warrior.scrolls_short =
{
    ["White Magic"] = "WHM",
    ["Black Magic"] = "BLM",
    ["Summoning"]   = "SMN",
    ["Ninjutsu"]    = "NIN",
    ["Songs"]       = "BRD",
}

return m
