-----------------------------------
-- Upgrade list for NQ -> HQ Augments
-----------------------------------
local m = Module:new("base_cw_quest_rewards")

cexi                          = cexi or {}
cexi.crystal_warrior          = cexi.crystal_warrior or {}
cexi.crystal_warrior.quest_rewards =
{
    -----------------------------------
    -- Aht Urhgan
    -----------------------------------
    {
        category = "Aht Urhgan",
        list     =
        {
            {
                quest = "Insult to Gingery",
                var   = { "[CW]INSULT_GINGERY", 2 },
                name  = "Sipahi Turban",
                id    = 16061,
                hq    = { 16067, "Abtal Turban" },
                augs  = { 513, 1, 516, 1 }, -- DEX +2, INT +2
                mats  = { { 2166, 2 }, "Marid Hair x2" },
            },

            {
                quest = "Pecking Battles",
                var   = { "[CW]BEAKS", 100 },
                name  = "Wivre Mask",
                id    = 16130,
                hq    = { 16131, "Wivre Mask +1" },
                augs  = { 513, 2, 23, 4 }, -- DEX +3, Accuracy +5
                mats  = { { 2428, 2 }, "Wivre Hide x2" },
            },
        },
    },

    -----------------------------------
    -- Bastok
    -----------------------------------
    {
        category = "Bastok",
        list     =
        {
            {
                quest = "A Matter of Trust I (Bastok)",
                var   = { "[CW]TRUST_BASTOK", 4 },
                name  = "Brass Mittens",
                id    = 12705,
                hq    = { 12770, "Brass Mittens +1" },
                augs  = { 1, 9 }, -- HP +10
                mats  = { { 642, 2 }, "Zinc Ore x2" },
            },

            {
                quest = "A Matter of Trust II (Bastok)",
                var   = { "[CW]TRUST_BASTOK", 8 },
                name  = "Greaves",
                id    = 12936,
                hq    = { 13025, "Greaves +1" },
                augs  = { 1, 9, 512, 0, 516, 0 }, -- HP +10, STR +1, INT +1
                mats  = { { 680, 2 }, "Iron Chain x2" },
            },

            {
                quest = "A Matter of Trust III (Bastok)",
                var   = { "[CW]TRUST_BASTOK", 13 },
                name  = "Earth Mantle",
                id    = 13623,
                augs  = { 33, 1, 512, 1, 516, 1 }, -- DEF +2, STR +2, INT +2
            },

            {
                quest = "Wanting Ore",
                var   = { "[CQ]WANTING_ORE", 5 },
                name  = "Plate Belt",
                id    = 12705,
                augs  = { 1, 9, 23, 1, 53, 7 }, -- HP +10, Accuracy +2, Spell interruption rate down 8%
            },

            {
                quest = "Buzz Off",
                var   = { "[CW]BUZZ_OFF", 2 },
                name  = "Leather Vest",
                id    = 12568,
                hq    = { 12599, "Leather Vest +1" },
                augs  = { 514, 0, 516, 0 }, -- VIT +1, INT +1
                mats  = { { 505, 4 }, "Sheepskin x4" },
            },

            {
                quest = "Buzz Kill",
                var   = { "[CW]BUZZ_OFF", 5 },
                name  = "Brass Spear",
                id    = 16834,
                hq    = { 16864, "Brass Spear +1" },
                augs  = { 515, 1, 517, 1 }, -- AGI +2, MND +2
                mats  = { { 650, 2 }, "Brass Ingot x2" },
            },

            {
                quest = "Runic Insurrection",
                var   = { "[CW]RUNIC_INSURRECTION", 7 },
                name  = "Sowilo Claymore",
                id    = 20781,
            },

            {
                quest = "The Way of Wadi",
                var   = { "[CW]WAY_OF_WADI", 11 },
                name  = "Onion Sword",
                id    = 16534,
                augs  = { 523, 4, 525, 4 }, -- INT -5, CHR -5
            },

            {
                quest = "The Way of Wadi",
                var   = { "[CW]WAY_OF_WADI", 12 },
                name  = "Degen",
                id    = 16517,
                hq    = { 16633, "Degen +1" },
                mats  = { { 744, 2 }, "Silver Ingot x2" },
                augs  = { 516, 2, 518, 2 }, -- INT +3 CHR +3
            },

            {
                quest = "Running Rings Around",
                var   = { "[CW]RUNNING_RINGS_AROUND", 9 },
                name  = "Bastokan Ring",
                id    = 13497,
            },
        },
    },

    -----------------------------------
    -- Jeuno
    -----------------------------------
    {
        category = "Jeuno",
        list     =
        {
            {
                quest = "Leg Work",
                var   = { "[CW]LEG_DAY", 12 },
                name  = "Silver Hose",
                id    = 12809,
                hq    = { 12894, "Silver Hose +1" },
                mats  = { { 760, 2 }, "Silver Chain x2" },
                augs  = { 1, 14, 512, 1, 514, 1, 25, 2 }, -- HP +15, STR +2, VIT +2, Attack +3
            },

            {
                quest = "Leg Work II",
                var   = { "[CW]LEG_DAY", 16 },
                name  = "Velvet Slops",
                id    = 12859,
                hq    = { 12918, "Mage's Slops" },
                mats  = { { 828, 2 }, "Velvet Cloth x2" },
                augs  = { 9, 14, 513, 1, 25, 3 }, -- MP +15, DEX +2, Attack +4
            },
        },
    },

    -----------------------------------
    -- San d'Oria
    -----------------------------------
    {
        category = "San d'Oria",
        list     =
        {
            {
                quest = "Chasing the Light",
                var   = { "[CQ]CHASING_LIGHT", 6 },
                name  = "Scroll of Enlight",
                id    = 4706,
            },

            {
                quest = "Saving My Hide",
                var   = { "[CQ]SAVING_MY_HIDE", 2 },
                name  = "Lizard Belt",
                id    = 13193,
                hq    = { 13191, "Lizard Belt +1" },
                mats  = { { 852, 4 }, "Lizard Skin x4" },
                augs  = { 1, 4, 513, 1, 51, 0 }, -- HP +5, DEX +2, HP recovered while healing +1
            },

            {
                quest = "A Matter of Trust I (San d'Oria)",
                var   = { "[CW]TRUST_SANDORIA", 4 },
                name  = "Gloves",
                id    = 12720,
                hq    = { 12773, "Gloves +1" },
                mats  = { { 834, 4 }, "Saruta Cotton x4" },
                augs  = { 1, 9 }, -- HP +10
            },

            {
                quest = "A Matter of Trust II (San d'Oria)",
                var   = { "[CW]TRUST_SANDORIA", 10 },
                name  = "Cotton Gaiters",
                id    = 12977,
                hq    = { 13032, "Great Gaiters" },
                mats  = { { 825, 2 }, "Cotton Cloth x2" },
                augs  = { 517, 1, 513, 0 }, -- MND +2, DEX +1
            },

            {
                quest = "A Matter of Trust III (San d'Oria)",
                var   = { "[CW]TRUST_SANDORIA", 15 },
                name  = "Ram Mantle",
                id    = 13570,
                hq    = { 13575, "Ram Mantle +1" },
                mats  = { { 859, 4 }, "Ram Skin x4" },
                augs  = { 513, 1, 515, 1, 51, 1 }, -- DEX +2, AGI +2, HP recovered while healing +2
            },

            {
                quest = "All Thine Heart",
                var   = { "[CW]ALL_THINE_HEART", 5 },
                name  = "Holy Breastplate",
                id    = 13812,
                hq    = { 13813, "Divine Breastplate" },
                mats  = { { 664, 2 }, "Darksteel Sheet x2" },
                augs  = { 25, 4, 23, 4, 517, 2 }, -- Attack +5, Accuracy +5, MND +3
                cost  = 15000,
            },

            {
                quest = "On Guard",
                var   = { "[CW]ON_GUARD", 2 },
                name  = "Kenpogi",
                id    = 12584,
                hq    = { 12668, "Kenpogi +1" },
                mats  = { { 824, 2 }, "Grass Cloth x2" },
                augs  = { 1, 4, 515, 0 }, -- HP +5, AGI +1
            },

            {
                quest = "On Watch",
                var   = { "[CW]ON_GUARD", 5 },
                name  = "Brass Xiphos",
                id    = 16531,
                hq    = { 16802, "Brass Xiphos +1" },
                mats  = { { 650, 2 }, "Brass Ingot x2" },
                augs  = { 514, 1, 32, 1 }, -- VIT +2, Evasion -2
            },

            {
                quest = "Ring Around the Roses",
                var   = { "[CW]RING_AROUND_THE_ROSES", 4 },
                name  = "San d'Orian Ring",
                id    = 13495,
            },
        },
    },

    -----------------------------------
    -- Windurst
    -----------------------------------
    {
        category = "Windurst",
        list     =
        {
            {
                quest = "Feather Forecast",
                var   = { "[CQ]FEATHER_FORECAST", 5 },
                name  = "Silver Obi",
                id    = 13205,
                hq    = { 13224, "Silver Obi +1" },
                mats  = { { 822, 4 }, "Silver Thread x4" },
                augs  = { 9, 9, 53, 7, 97, 0 }, -- MP +10, Spell interruption rate down 8%, Pet: Attack+1 Rng.Atk.+1
            },

            {
                quest = "A Matter of Trust I (Windurst)",
                var   = { "[CW]TRUST_WINDURST", 5 },
                name  = "Linen Cuffs",
                id    = 12729,
                hq    = { 12778, "Linen Cuffs +1" },
                mats  = { { 819, 2 }, "Linen Thread x2" },
                augs  = { 9, 9 }, -- MP +10
            },

            {
                quest = "A Matter of Trust II (Windurst)",
                var   = { "[CW]TRUST_WINDURST", 11 },
                name  = "Sandals",
                id    = 12993,
                hq    = { 13048, "Mage's Sandals" },
                mats  = { { 850, 2 }, "Sheep Leather x2" },
            },

            {
                quest = "A Matter of Trust III (Windurst)",
                var   = { "[CW]TRUST_WINDURST", 16 },
                name  = "Tundra Mantle",
                id    = 13625,
                augs  = { 517, 1, 518, 1, 141, 1 }, -- MND +2, CHR +2, Conserve MP +2
            },

            {
                quest = "Say Peas",
                var   = { "[CW]SAY_PEAS", 2 },
                name  = "Robe",
                id    = 12600,
                hq    = { 12615, "Robe +1" },
                mats  = { { 817, 4 }, "Grass Thread x2" },
                augs  = { 17, 2 }, -- HP +3 / MP +3
            },

            {
                quest = "The Unnamed Way",
                var   = { "[CW]UNNAMED_WAY", 7 },
                name  = "Matre Bell",
                id    = xi.item.MATRE_BELL,
            },

            {
                quest = "Get Cracking",
                var   = { "[CW]SAY_PEAS", 5 },
                name  = "Holly Staff",
                id    = 17089,
                hq    = { 17125, "Holly Staff +1" },
                mats  = { { 714, 2 }, "Holly Lumber x2" },
                augs  = { 512, 1, 517, 1 }, -- STR +2, MND +2
            },

            {
                quest = "Give Me a Ring",
                var   = { "[CW]GIVE_ME_A_RING", 4 },
                name  = "Windurstian Ring",
                id    = 13496,
            },
        },
    },

    -----------------------------------
    -- Other Areas
    -----------------------------------
    {
        category = "Other Areas",
        list     =
        {
            {
                quest = "Broken Bones",
                var   = { "[CQ]BROKEN_BONES", 3 },
                name  = "Rose Harp",
                id    = 17355,
                hq    = { 17376, "Rose Harp +1" },
                mats  = { { 718, 4 }, "Rosewood Lumber x4" },
                augs  = { 514, 0, 31, 3, 51, 1 }, -- VIT +1, Evasion +4, HP recovered while healing+2
            },

            {
                quest = "Head First",
                var   = { "[CW]HEAD_FIRST", 3 },
                name  = "Lizard Mantle",
                id    = 13592,
                hq    = { 13608, "Lizard Mantle +1" },
                mats  = { { 852, 2 }, "Lizard Skin x2" },
                augs  = { 512, 0 }, -- STR +1
            },

            {
                quest = "Helping Hands",
                augs  = { "[CW]HELPING_HANDS", 5 },
                name  = "Lizard Gloves",
                id    = 12697,
                hq    = { 12785, "Fine Gloves" },
                mats  = { { 852, 4 }, "Lizard Skin x4" },
                augs  = { 1, 4, 513, 1, 518, 1 }, -- HP +5, DEX +2, CHR +2
            },

            {
                quest = "Likely Tails",
                var   = { "[CW]LIKELY_TAILS", 2 },
                name  = "Cotton Cape",
                id    = 13584,
                hq    = { 13601, "Cotton Cape +1" },
                mats  = { { 825, 2 }, "Cotton Cloth x2" },
                augs  = { 9, 4, 516, 0 }, -- MP +5, INT +1
            },

            {
                quest = "Rolling With Punches",
                var   = { "[CW]ROLLING_PUNCHES", 5 },
                name  = "Cotton Tekko",
                id    = 12713,
                hq    = { 12777, "Cotton Tekko +1" },
                mats  = { { 825, 4 }, "Cotton Cloth x4" },
                augs  = { 512, 1, 25, 3, 32, 3 }, -- STR +2, Attack +4, Evasion -4
            },
        },
    },

    -----------------------------------
    -- Garish/Rubious Attire
    -----------------------------------
    {
        category = "Garish/Rubious",
        list     =
        {
            {
                quest = "On the Range",
                bit   = { "[CW]REPAIR_GARISH", 1 },
                name  = "Garish Crown",
                id    = 15164,
                hq    = { 15168, "Rubious Crown" },
                mats  = { { 927, 2 }, "Coeurl Whisker x2" },
                augs  = { 9,  4, 25, 1 }, -- MP +5, Attack +2
            },

            {
                quest = "On the Range",
                bit   = { "[CW]REPAIR_GARISH", 2 },
                name  = "Garish Tunic",
                id    = 14425,
                hq    = { 14432, "Rubious Tunic" },
                mats  = { { 1699, 4 }, "Scarlet Linen x4" },
                augs  = { 1, 14, 23, 1 }, -- HP +15, Accuracy +2
                cost  = 10000,
            },

            {
                quest = "On the Range",
                bit   = { "[CW]REPAIR_GARISH", 3 },
                name  = "Garish Mitts",
                id    = 14857,
                hq    = { 14861, "Rubious Mitts" },
                mats  = { { 1700, 2 }, "Bloodthread x2" },
                augs  = { 9,  9, 23, 1 }, -- MP +10, Accuracy +2
            },

            {
                quest = "On the Range",
                bit   = { "[CW]REPAIR_GARISH", 4 },
                name  = "Garish Slacks",
                id    = 14326,
                hq    = { 14330, "Rubious Slacks" },
                mats  = { { 1699, 4 }, "Scarlet Linen x4" },
                augs  = { 1,  9, 23, 2 }, -- HP +10, Accuracy +3
            },

            {
                quest = "On the Range",
                bit   = { "[CW]REPAIR_GARISH", 5 },
                name  = "Garish Pumps",
                id    = 15314,
                hq    = { 15318, "Rubious Pumps" },
                mats  = { { 1700, 2 }, "Bloodthread x2" },
                augs  = { 9,  4, 25, 1 }, -- MP  +5, Attack   +2
            },
        },
    },

    -----------------------------------
    -- Shade/+1 Attire
    -----------------------------------
    {
        category = "Shade/+1 Attire",
        list     =
        {
            {
                quest = "Empty Handed",
                bit   = { "[CW]REPAIR_SHADE", 1 },
                name  = "Shade Tiara",
                id    = 15165,
                hq    = { 15169, "Shade Tiara +1" },
                mats  = { { 1623, 2 }, "Eft Skin x2" },
                augs  = { 512, 1, 518, 1 }, -- STR +2, CHR +2
            },

            {
                quest = "Empty Handed",
                bit   = { "[CW]REPAIR_SHADE", 2 },
                name  = "Shade Harness",
                id    = 14426,
                hq    = { 14433, "Shade Harness +1" },
                mats  = { { 529, 4 }, "Luminicloth x4" },
                augs  = { 514, 1, 517, 1 }, -- VIT +2, MND +2
                cost  = 10000,
            },

            {
                quest = "Empty Handed",
                bit   = { "[CW]REPAIR_SHADE", 3 },
                name  = "Shade Mittens",
                id    = 14858,
                hq    = { 14862, "Shade Mittens +1" },
                mats  = { { 1618, 2 }, "Uragnite Shell x2" },
                augs  = { 512, 1, 516, 1 }, -- STR +2, INT +2
            },

            {
                quest = "Empty Handed",
                bit   = { "[CW]REPAIR_SHADE", 4 },
                name  = "Shade Tights",
                id    = 14327,
                hq    = { 14331, "Shade Tights +1" },
                mats  = { { 529, 4 }, "Luminicloth x4" },
                augs  = { 512, 1, 516, 1 }, -- STR +2, INT +2
            },

            {
                quest = "Empty Handed",
                bit   = { "[CW]REPAIR_SHADE", 5 },
                name  = "Shade Leggings",
                id    = 15315,
                hq    = { 15319, "Shade Leggings +1" },
                mats  = { { 1618, 2 }, "Uragnite Shell x2" },
                augs  = { 513, 1, 517, 1 }, -- DEX +2, MND +2
            },
        },
    },
}

return m
