-----------------------------------
-- Crystal Warrior Intro Utils
-----------------------------------
local m = Module:new("base_cw_introduction")

cexi                       = cexi or {}
cexi.crystal_warrior       = cexi.crystal_warrior or {}
cexi.crystal_warrior.intro = cexi.crystal_warrior.intro or {}

cexi.crystal_warrior.intro.getHints = function(obj)
    return {
        -- Hint #1
        {
            after   = 3000,
            message =
            {
                fmt("You've acquired a {}! Find the nearby {} and target it using the [Tab] key.", obj.tool, obj.point),
                "Once you've acquired a target, open the Main Menu [-] and select Trade.",
                fmt("Deposit {} x1 into the trade window then click OK.", obj.tool),
                "~~~",
                "Many NPCs throughout the world request items you can give via Trade.",
                fmt("{} is also a great way to gather materials for crafting!", obj.gather),
            },
        },

        -- Hint #2
        {
            after   = 3000,
            message = {
                fmt("You've acquired {}!", obj.material),
                fmt("Return to {} and trade {} using the same process as before.", obj.npc, obj.material),
            },
        },

        -- Hint #3
        {
            after   = 3000,
            message =
            {
                fmt("{} is busy crafting your starting equipment.", obj.npc),
                "~~~",
                "You can craft your own equipment using Crystals dropped from monsters.",
                "(To obtain Crystals you must have an \"Signet\" effect from the city guards)",
                "~~~",
                "Example: Fire Crystal and Copper Ore x4 = Copper Ingot",
                "Example: Fire Crystal and Copper Ingot x2 = Copper Ring",
                "(See: \"Synthesis\" under the Main Menu)",
                "~~~",
                fmt("Speak to {} when you're ready to continue.", obj.npc),
            },
        },

        -- Hint #4
        {
            after   = 3000,
            message =
            {
                "Prepare yourself for combat!",
                "~~~",
                "\"Use\" any spell scrolls you have obtained under \"Item\" in the Main Menu",
                "\"Equip\" your new equipment under Equipment in the Main Menu",
                "~~~",
                "To engage a target, select a monster with [Tab] and use [Enter] to \"Attack\" using the Sub-Menu",
                "~~~",
                fmt("Speak to {} when you're ready to continue.", obj.npc),
            },
        },

        -- Hint #5
        {
            "You've completed the Crystal Warrior introduction!",
            fmt("From here, you'll need to make your way to {}, where your adventure begins.", obj.city),
            "~~~",
            fmt("Once you arrive, don't forget to set your Home Point and collect your starting ring from {}'s quest in {}.", obj.ringNpc, obj.ringZone),
            "If you need any help or have any questions, don't hesitate to ask in /linkshell (Helpers also gain EXP Scrolls and Helper Points!)",
        },
    }
end

local progVar = "[CW]INTRO"

cexi.crystal_warrior.intro.setNextZone = function(mod, zoneName, hint, startPos)
    mod:addOverride(fmt("xi.zones.{}.Zone.afterZoneIn", zoneName), function(player)
        super(player)

        if not player:isCrystalWarrior() then
            return
        end

        local cwIntro = player:getCharVar(progVar)

        if
            cwIntro == 0 or
            cwIntro > 8
        then
            return
        end

        if cwIntro == 8 then
            for _, message in pairs(hint[5]) do
                player:sys(message)
            end

            player:setCharVar(progVar, 9)
            return
        end

        player:sys("You must complete the Crystal Warrior introduction before continuing.")

        player:timer(1500, function()
            player:setPos(unpack(startPos))
        end)
    end)
end

return m
