-----------------------------------
-- Additional enum entries
-----------------------------------
local m = Module:new("base_cw_ephemeral_box")

cexi                                           = cexi or {}
cexi.crystal_warrior                           = cexi.crystal_warrior or {}
cexi.crystal_warrior.ephemeral_box             = cexi.crystal_warrior.ephemeral_box or {}
cexi.crystal_warrior.ephemeral_box.tradeable   = {}
cexi.crystal_warrior.ephemeral_box.conditional = {}

cexi.crystal_warrior.ephemeral_box.conversion  =
{
    [4104] = { 4096, 12, "Fire Crystal"    }, -- Fire Cluster
    [4105] = { 4097, 12, "Ice Crystal"     }, -- Ice Cluster
    [4106] = { 4098, 12, "Wind Crystal"    }, -- Wind Cluster
    [4107] = { 4099, 12, "Earth Crystal"   }, -- Earth Cluster
    [4108] = { 4100, 12, "Thunder Crystal" }, -- Thunder Cluster
    [4109] = { 4101, 12, "Water Crystal"   }, -- Water Cluster
    [4110] = { 4102, 12, "Light Crystal"   }, -- Light Cluster
    [4111] = { 4103, 12, "Dark Crystal"    }, -- Dark Cluster
}

cexi.crystal_warrior.ephemeral_box.seals       =
{
    [xi.item.BEASTMENS_SEAL       ] = { 0, "Beastmen's Seal"        },
    [xi.item.KINDREDS_SEAL        ] = { 1, "Kindred's Seal"         },
    [xi.item.KINDREDS_CREST       ] = { 2, "Kindred's Crest"        },
    [xi.item.HIGH_KINDREDS_CREST  ] = { 3, "High Kindred's Crest"   },
    [xi.item.SACRED_KINDREDS_CREST] = { 4, "Sacred Kindred's Crest" },
}

cexi.crystal_warrior.ephemeral_box.organs = set {
    xi.item.PHUABO_ORGAN,
    xi.item.XZOMIT_ORGAN,
    xi.item.AERN_ORGAN,
    xi.item.HPEMDE_ORGAN,
    xi.item.YOVRA_ORGAN,
    xi.item.EUVHI_ORGAN,
    xi.item.HIGH_QUALITY_PHUABO_ORGAN,
    xi.item.HIGH_QUALITY_XZOMIT_ORGAN,
    xi.item.HIGH_QUALITY_AERN_ORGAN,
    xi.item.HIGH_QUALITY_HPEMDE_ORGAN,
    xi.item.HIGH_QUALITY_EUVHI_ORGAN,
    xi.item.LUMINIAN_TISSUE,
}

cexi.crystal_warrior.ephemeral_box.duplicateItem =
{
    ["giant_donko"]     = 4306,
    ["shining_trout"]   = 4354,
    ["bastore_sardine"] = 4360,
    ["gold_lobster"]    = 4383,
    ["bluetail"]        = 4399,
    ["moat_carp"]       = 4401,
    ["dark_bass"]       = 4428,
    ["black_eel"]       = 4429,
    ["monke-onke"]      = 4462,
    ["pipira"]          = 4464,
    ["giant_catfish"]   = 4469,
    ["bladefish"]       = 4471,
    ["crayfish"]        = 4472,
    ["three-eyed_fish"] = 4478,
    ["bhefhel_marlin"]  = 4479,
    ["gugru_tuna"]      = 4480,
    ["ogre_eel"]        = 4481,
    ["nosteau_herring"] = 4482,
    ["tiger_cod"]       = 4483,
    ["quus"]            = 4514,
    ["copper_frog"]     = 4515,
    ["rhinochimera"]    = 5135,
    ["istavrit"]        = 5136,
    ["veydal_wrasse"]   = 5141,
    ["gigant_octopus"]  = 5475,
}

cexi.crystal_warrior.ephemeral_box.areas =
{
    ["Southern_San_dOria"] =
    {
        ["Leathercraft"] = { -188.048, -2.000, -3.331, 225 }, -- (Leathercraft) !pos -188.048 -2.000 -3.331 230
    },
    ["Northern_San_dOria"] =
    {
        ["Woodworking"] = { -174.738, 12.000, 270.035,  93 }, -- (Woodworking) !pos -174.738 12.000 270.035 231
        ["Smithing"]    = { -186.699, 12.002, 137.754, 190 }, -- (Smithing)    !pos -186.699 12.002 137.754 231
    },
    ["Windurst_Woods"] =
    {
        ["Bonecraft"]  = { -9.768, -5.250, -145.016, 191 }, -- (Bonecraft)  !pos -9.768 -5.250 -145.016 241
        ["Clothcraft"] = { -35.752, -1.250, -113.964, 86 }, -- (Clothcraft) !pos -35.752 -1.250 -113.964 241
    },
    ["Windurst_Waters"] =
    {
        ["Cooking"] = { -116.399, -2.000, 64.295, 127 }, -- (Cooking) !pos -116.399 -2.000 64.295 238
    },
    ["Port_Windurst"] =
    {
        ["Fishing"] = { -194.122, -4.000, 101.702, 32 }, -- (Fishing) !pos -194.122 -4.000 101.702 240
    },
    ["Bastok_Markets"] =
    {
        ["Goldsmithing"] = { -218.647, -6.815, -63.956, 220 }, -- (Goldsmithing) !pos -218.647 -6.815 -63.956 235
    },
    ["Bastok_Mines"] =
    {
        ["Alchemy"] = { 117.309, 2.017, 4.179, 62 }, -- (Alchemy) !pos 117.309 2.017 4.179 234
    },
    ["Metalworks"] =
    {
        ["Smithing"] = { -97.657, 2.000, 25.609, 128 }, -- (Smithing) !pos -97.657 2.000 25.609 237
    },
    ["Lower_Jeuno"] =
    {
        ["Alchemy"] = { 34.000, -0.100, -0.200, 85 }, -- (Default) !pos 34.000 -0.100 -0.200 245
    },
    ["Norg"] =
    {
        ["Alchemy"] = { -54.635, -1.514, 32.607, 196 }, -- (Default) !pos -54.635 -1.514 32.607 252
    },
    ["Rabao"] =
    {
        ["Alchemy"] = { -38.573, 8.000, 77.624, 243 }, -- (Default) !pos -38.573 8.000 77.624 247
    },
    ["Kazham"] =
    {
        ["Alchemy"] = { -113.306, -10.000, -15.330, 48 }, -- (Default) !pos -113.306 -10.000 -15.330 250
    },
    ["Aht_Urhgan_Whitegate"] =
    {
        ["Alchemy"] = { -124.599, -6.000, 67.163, 126 }, -- (Default) !pos -124.599 -6.000 67.163 50
    },
    ["Provenance"] =
    {
        ["Lapidary"] = { -625.788, -19.386, -529.724, 133 }, -- (Lapidary ) !pos -625.788 -19.386 -529.724 222
    },
}

cexi.crystal_warrior.ephemeral_box.list =
{
    Alchemy   =
    {
        category =
        {
            "Reagent",
            "Plant",
            "Memory",
            "Potion",
            "Powder",
        },
        list =
        {
            {
                {  557, "Ahriman Lens"      },
                {  921, "Ahriman Tears"     },
                {  935, "Ahriman Wing"      },
                {  937, "Animal Glue"       },
                { 1109, "Artificial Lens"   },
                { 1626, "Avatar Blood"      },
                { 2113, "Baking Soda"       },
                {  922, "Bat Wing"          },
                { 2015, "Beast Blood"       },
                {  930, "Beastman Blood"    },
                {  912, "Beehive Chip"      },
                {  913, "Beeswax"           },
                { 1110, "Beetle Blood"      },
                { 2014, "Bird Blood"        },
                {  929, "Black Ink"         },
                { 9494, "Blank Key"         },
                { 17316, "Bomb Arm"         },
                {  928, "Bomb Ash"          },
                { 3980, "Bztavian Stinger"  },
                {  916, "Cactuar Needle"    },
                {  932, "Carbon Fiber"      },
                {  931, "Cermet Chunk"      },
                { 2229, "Chimera Blood"     },
                { 1630, "Cluster Ash"       },
                {  927, "Coeurl Whisker"    },
                { 2365, "Demon Blood"       },
                { 2549, "Djinn Ash"         },
                { 1165, "Doll Shard"        },
                { 1133, "Dragon Blood"      },
                { 4486, "Dragon Heart"      },
                {  924, "Fiend Blood"       },
                {  947, "Firesand"          },
                { 2175, "Flan Meat"         },
                { 1519, "Fresh Orc Liver"   },
                {  925, "Giant Stinger"     },
                {  933, "Glass Fiber"       },
                { 1887, "Glass Sheet"       },
                { 1520, "Goblin Grease"     },
                { 9518, "Goblin Powder"     },
                { 9497, "Goblin Stone"      },
                {  955, "Golem Shard"       },
                {  939, "Hecteyes Eye"      },
                { 2362, "High Ebonite"      },
                { 2309, "Homncl. Nerves"    },
                { 2163, "Imp Wing"          },
                { 2290, "Imperial Cermet"   },
                { 2475, "Kaolin"            },
                { 1979, "Leech Saliva"      },
                { 2155, "Lesser Chigoe"     },
                { 2013, "Lizard Blood"      },
                {  926, "Lizard Tail"       },
                {  954, "Magic Pot Shard"   },
                {  914, "Mercury"           },
                { 5165, "Moval. Water"      },
                { 2126, "Orpiment"          },
                { 2524, "Peiste Stinger"    },
                { 2164, "Peph. Hive Chip"   },
                {  942, "Phil. Stone"       },
                { 2310, "Plasma Oil"        },
                {  952, "Poison Flour"      },
                { 2316, "Polyflan Paper"    },
                {  936, "Rock Salt"         },
                { 1886, "Sieglinde Putty"   },
                { 1888, "Silica"            },
                { 1521, "Slime Juice"       },
                {  637, "Slime Oil"         },
                { 1108, "Sulfur"            },
                { 1621, "Taurus Wing"       },
                {  915, "Toad Oil"          },
                { 2338, "Wamoura Scale"     },
                {  934, "Yuhtunga Sulfur"   },
                { 4015, "Yggdreant Root"    },
            },
            {
                {  957, "Amaryllis"         },
                { 2361, "Ameretat Vine"     },
                {  919, "Boyahda Moss"      },
                {  948, "Carnation"         },
                {  636, "Chamomile"         },
                {  959, "Dahlia"            },
                {  923, "Dryad Root"        },
                { 1617, "Flytrap Leaf"      },
                { 1524, "Fresh Mugwort"     },
                { 1309, "Gold Leaf"         },
                {  956, "Lilac"             },
                { 2507, "Lycopodium Flower" },
                {  920, "Malboro Vine"      },
                {  958, "Marguerite"        },
                {  918, "Mistletoe"         },
                { 1308, "Mythril Leaf"      },
                { 1310, "Platinum Leaf"     },
                {  949, "Rain Lily"         },
                { 2513, "Rafflesia Vine"    },
                {  941, "Red Rose"          },
                {  940, "Revival Root"      },
                { 1307, "Silver Leaf"       },
                { 1725, "Snow Lily"         },
                {  953, "Treant Bulb"       },
                {  951, "Wijnruit"          },
                { 5907, "Winterflower"      },
            },
            {
                { 1607, "Bitter Memory"     },
                { 1606, "Burning Memory"    },
                { 1644, "Earth Anima"       },
                { 1648, "Dark Anima"        },
                { 1641, "Fire Anima"        },
                { 1608, "Fleeting Memory"   },
                { 1642, "Ice Anima"         },
                { 1647, "Light Anima"       },
                { 1645, "Lightning Anima"   },
                { 1609, "Profane Memory"    },
                { 1610, "Strtlng. Memory"   },
                { 1611, "Somber Memory"     },
                { 1612, "Radiant Memory"    },
                { 1613, "Malevolent Memory" },
                { 1646, "Water Anima"       },
                { 1643, "Wind Anima"        },
            },
            {
                { 4148, "Antidote"          },
                { 4163, "Blinding Potion"   },
                { 4246, "Cantarella"        },
                { 4151, "Echo Drops"        },
                { 4128, "Ether"             },
                { 4150, "Eye Drops"         },
                { 5306, "Hallowed Water"    },
                { 4116, "Hi-Potion"         },
                { 4154, "Holy Water"        },
                { 4149, "Panacea"           },
                { 4159, "Paralyze Potion"   },
                { 4157, "Poison Potion"     },
                { 4112, "Potion"            },
                { 4164, "Prism Powder"      },
                { 1893, "Salinator"         },
                { 4162, "Silencing Potion"  },
                { 4165, "Silent Oil"        },
                { 4161, "Sleeping Potion"   },
                { 4158, "Venom Potion"      },
                { 4171, "Vitriol"           },
            },
            {
                { 2459, "Minium"            },
                {  945, "Paralysis Dust"    },
                {  943, "Poison Dust"       },
                {  944, "Venom Dust"        },
                { 1884, "Zinc Oxide"        },
            },
        },
    },
    Bonecraft =
    {
        category =
        {
            "Bone",
            "Shell",
            "Scales",
            "Other",
        },
        list =
        {
            {
                {  891, "Bat Fang"          },
                {  883, "Behemoth Horn"     },
                {  884, "Blk. Tiger Fang"   },
                {  880, "Bone Chip"         },
                { 1615, "Buffalo Horn"      },
                { 1622, "Bugard Tusk"       },
                { 1463, "Chronos Tooth"     },
                { 2171, "Colibri Beak"      },
                { 1518, "Colossal Skull"    },
                {  898, "Chicken Bone"      },
                {  902, "Demon Horn"        },
                {  886, "Demon Skull"       },
                { 1771, "Dragon Bone"       },
                {  903, "Dragon Talon"      },
                { 3977, "Gabbrath Horn"     },
                { 2747, "Gargouille Horn"   },
                { 2748, "Garglle. Shank"    },
                {  893, "Giant Femur"       },
                { 1517, "Giant Frozen Head" },
                { 2158, "Hydra Fang"        },
                { 2157, "Imp Horn"          },
                { 2371, "Khimaira Horn"     },
                { 1458, "Mammoth Tusk"      },
                { 1123, "Manticore Fang"    },
                { 2147, "Marid Tusk"        },
                {  895, "Ram Horn"          },
                { 3979, "Rockfin Tooth"     },
                { 2754, "Ruszor Fang"       },
                {  882, "Sheep Tooth"       },
                { 1620, "Taurus Horn"       },
                { 1841, "Unicorn Horn"      },
                { 4012, "Waktza Rostrum"    },
                { 2426, "Wivre Horn"        },
                { 2427, "Wivre Maul"        },
                { 9453, "Wyrm Tooth"        },
                {  905, "Wyvern Skull"      },
            },
            {
                {  908, "Adamantoise Shell" },
                { 1616, "Antlion Jaw"       },
                { 1312, "Angel Skin"        },
                {  894, "Beetle Jaw"        },
                {  889, "Beetle Shell"      },
                { 2004, "Carap. Powder"     },
                { 8752, "Cehuetzi Claw"     },
                { 2168, "Cerberus Claw"     },
                {  887, "Coral Fragment"    },
                {  881, "Crab Shell"        },
                { 1864, "H.Q. Antlion Jaw"  },
                { 1193, "H.Q. Crab Shell"   },
                { 1473, "H.Q. Scp. Shell"   },
                { 3934, "Matamata Shell"    },
                { 1311, "Oxblood"           },
                {  897, "Scorpion Claw"     },
                {  896, "Scorpion Shell"    },
                {  888, "Seashell"          },
                { 1883, "Shell Powder"      },
                { 4484, "Shall Shell"       },
                { 1586, "Titanictus Shell"  },
                { 5466, "Trumpet Shell"     },
                {  885, "Turtle Shell"      },
                {  901, "Venomous Claw"     },
                { 1715, "Vivified Coral"    },
                { 1618, "Uragnite Shell"    },
            },
            {
                {  867, "Dragon Scales"     },
                {  864, "Fish Scales"       },
                { 2172, "Hydra Scale"       },
                { 1587, "H.Q. Pugil Scls."  },
                {  868, "Pugil Scales"      },
                { 2146, "Merrow Scale"      },
                { 9447, "Wyrm Scale"        },
                {  866, "Wyvern Scales"     },
            },
            {   { 2744, "Angel Skin Orb"    },
                { 2743, "Oxblood Orb"       },
            },
        },
    },
    Clothcraft =
    {
        category =
        {
            "Fiber",
            "Thread",
            "Cloth",
            "Feather/Wing",
        },
        list =
        {
            {
                { 4026, "Akaso"            },
                { 1270, "Arachne Web"      },
                { 1712, "Cashmere Wool"    },
                {  839, "Crawler Cocoon"   },
                { 2539, "Dhalmel Hair"     },
                {  835, "Flax Flower"      },
                { 2315, "Karakul Wool"     },
                { 1163, "Manticore Hair"   },
                { 2166, "Marid Hair"       },
                { 2295, "Mohbwa Grass"     },
                {  833, "Moko Grass"       },
                { 1845, "Red Moko Grass"   },
                {  834, "Saruta Cotton"    },
                {  832, "Sheep Wool"       },
                { 1313, "Siren's Hair"     },
                {  838, "Spider Web"       },
                { 1295, "Twincoon"         },
                { 2173, "Wam. Cocoon"      },
                { 2337, "Wamoura Hair"     },
                { 2011, "Wolf Fur"         },
                { 2198, "W. Spider's Web"  },
            },
            {
                { 4027, "Akaso Thread"     },
                { 1294, "Arachne Thread"   },
                { 1700, "Bloodthread"      },
                { 1713, "Cashmere Thrd."   },
                {  818, "Cotton Thread"    },
                { 9455, "Fable Thread"     },
                {  823, "Gold Thread"      },
                {  817, "Grass Thread"     },
                { 2287, "Karakul Thread"   },
                {  819, "Linen Thread"     },
                {  837, "Malboro Fiber"    },
                { 1651, "Moblin Thread"    },
                { 2296, "Mohbwa Thread"    },
                {  821, "Rainbow Thread"   },
                { 1828, "Red Grs. Thread"  },
                {  816, "Silk Thread"      },
                {  822, "Silver Thread"    },
                { 2199, "Sparkstrand"      },
                { 1278, "Twinthread"       },
                { 2304, "Wamoura Silk"     },
                {  820, "Wool Thread"      },
                { 3550, "Wyrdstrand"       },
            },
            {
                { 2537, "Cilice"           },
                {  825, "Cotton Cloth"     },
                {  836, "Damascene Cloth"  },
                { 9456, "Fable Cloth"      },
                { 1769, "Galateia"         },
                {  824, "Grass Cloth"      },
                { 2005, "Hunter's Cotton"  },
                { 2340, "Imp. Silk Cloth"  },
                { 2288, "Karakul Cloth"    },
                { 1764, "Kejusu Satin"     },
                {  826, "Linen Cloth"      },
                {  529, "Luminicloth"      },
                { 1636, "Moblinweave"      },
                { 2274, "Mohbwa Cloth"     },
                { 2704, "Oil-Soaked Cloth" },
                {  830, "Rainbow Cloth"    },
                { 1132, "Raxa"             },
                { 1829, "Red Grass Cloth"  },
                { 1997, "Sailcloth"        },
                { 1280, "Sarcenet Cloth"   },
                { 1699, "Scarlet Linen"    },
                {  831, "Shining Cloth"    },
                {  829, "Silk Cloth"       },
                {  828, "Velvet Cloth"     },
                { 2289, "Wamoura Cloth"    },
                {  827, "Wool Cloth"       },
                { 3551, "Wyrdweave"        },
            },
            {
                { 2149, "Apkallu Feather"    },
                {  847, "Bird Feather"       },
                {  845, "Black C. Feather"   },
                { 3981, "Bztavian Wing"      },
                {  840, "Chocobo Fthr."      },
                { 2150, "Colibri Feather"    },
                { 2655, "Dark Ixion Tail"    },
                {  842, "Giant Bird Fthr."   },
                {  843, "G. Bird Plume"      },
                { 2522, "Gnat Wing"          },
                { 1619, "Hippogryph Feather" },
                {  846, "Insect Wing"        },
                { 2506, "Ladybug Wing"       },
                {  844, "Phoenix Feather"    },
                { 9147, "Porxie Wings"       },
                { 2148, "Puk Wing"           },
                { 4013, "Waktza Crest"       },
                {  841, "Yagudo Feather"     },
            },
        },
    },
    Cooking =
    {
        category =
        {
            "Vegetable",
            "Meat",
            "Prepared",
            "Liquid",
            "Eggs",
        },
        list =
        {
            {
                { 4504, "Acorn"            },
                { 5680, "Agaricus"         },
                { 2503, "Almond"           },
                { 1523, "Apple Mint"       },
                { 8800, "Azuki Bean"       },
                {  623, "Bay Leaves"       },
                { 4496, "Bbl. Chocolate"   },
                { 4367, "Batagreens"       },
                { 4571, "Beaugreens"       },
                {  626, "Black Pepper"     },
                {  618, "Blue Peas"        },
                { 4503, "Buburimu Grape"   },
                { 5908, "Butterpear"       },
                { 5651, "Burdock"          },
                {  636, "Chamomile"        },
                {  639, "Chestnut"         },
                { 5234, "Cibol"            },
                {  628, "Cinnamon"         },
                { 1633, "Clot Plasma"      },
                { 2270, "Coffee Cherries"  },
                { 4450, "Coral Fungus"     },
                { 4375, "Danceshroom"      },
                { 5566, "Date"             },
                { 4566, "Deathball"        },
                { 4352, "Derfland Pear"    },
                { 5662, "Dragon Fruit"     },
                { 2645, "Eastern Ginger"   },
                { 4388, "Eggplant"         },
                { 5187, "Elshimo Coconut"  },
                { 4363, "Faerie Apple"     },
                { 5964, "Felicifruit"      },
                { 1522, "Fresh Marjoram"   },
                { 4382, "Frost Turnip"     },
                {  617, "Ginger"           },
                { 5688, "Graubg. Lettuce"  },
                { 1590, "Holy Basil"       },
                { 2156, "Im. Tea Leaves"   },
                {  612, "Kazham Peppers"   },
                { 4432, "Kazham Pineapl."  },
                { 1982, "King Locust"      },
                { 4386, "King Truffle"     },
                { 4273, "Kitron"           },
                {  632, "Kukuru Bean"      },
                { 4366, "La Theine Cbg."   },
                {  614, "Mhaura Garlic"    },
                {  629, "Millioncorn"      },
                { 5195, "Misx. Parsley"    },
                { 4390, "Mithran Tomato"   },
                { 1983, "Mushroom Locust"  },
                {  630, "Ogre Pumpkin"     },
                { 4468, "Pamamas"          },
                { 4274, "Persikos"         },
                { 2213, "Pine Nuts"        },
                {  619, "Popoto"           },
                { 4448, "Puffball"         },
                { 4444, "Rarab Tail"       },
                { 4449, "Reishi Mushroom"  },
                { 4365, "Rolanberry"       },
                { 5541, "Royal Grape"      },
                { 4508, "Royal Jelly"      },
                {  638, "Sage"             },
                { 4389, "San d'Or. Carrot" },
                { 4431, "San d'Or. Grape"  },
                { 4392, "Saruta Orange"    },
                { 4447, "Scream Fungus"    },
                { 2236, "Simsim"           },
                { 1981, "Skull Locust"     },
                { 4374, "Sleepshroom"      },
                { 4565, "Sobbing Fungus"   },
                { 1471, "Sticky Rice"      },
                { 4505, "Sunflower Seeds"  },
                {  620, "Tarutaru Rice"    },
                { 4412, "Thundermelon"     },
                { 2112, "Vanilla"          },
                { 5607, "Vomp Carrot"      },
                { 5661, "Walnut"           },
                { 4491, "Watermelon"       },
                { 4387, "Wild Onion"       },
                {  635, "Win. Tea Leaves"  },
                { 4373, "Woozyshroom"      },
                { 4445, "Yagudo Cherry"    },
            },
            {
                {  6416, "Behemoth Meat"   },
                {  5152, "Buffalo Meat"    },
                {  5565, "Cerberus Meat"   },
                {  4435, "Cockatrice Meat" },
                {  4377, "Coeurl Meat"     },
                {  4359, "Dhalmel Meat"    },
                {  5209, "Diatryma Meat"   },
                {  4272, "Dragon Meat"     },
                {  6068, "Gabbrath Meat"   },
                {  4372, "G. Sheep Meat"   },
                {  4358, "Hare Meat"       },
                {  1985, "Helmet Mole"     },
                {  5564, "Hydra Meat"      },
                {  5571, "Karakul Meat"    },
                {  4400, "Land Crab Meat"  },
                {  5667, "Lynx Meat"       },
                {  3978, "Rockfin Fin"     },
                { 16995, "Rotten Meat"     },
                {  5755, "Ruszor Meat"     },
                {  1984, "Snapping Mole"   },
                {  5581, "Ziz Meat"        },
            },
            {
                { 5652, "Anchovy"          },
                { 4364, "Black Bread"      },
                { 5684, "Chalaimbille"     },
                { 2273, "Coffee Powder"    },
                { 2271, "Coffee Beans"     },
                { 1555, "Coriander"        },
                { 2215, "Cornstarch"       },
                { 5233, "Cotton Tofu"      },
                {  621, "Crying Mustard"   },
                { 1475, "Curry Powder"     },
                {  622, "Dried Marjoram"   },
                { 1443, "Dried Mugwort"    },
                { 1111, "Gelatin"          },
                { 5164, "Ground Wasabi"    },
                {  631, "Horo Flour"       },
                { 2237, "Imperial Flour"   },
                { 4499, "Iron Bread"       },
                { 5747, "Marinara Sauce"   },
                {  627, "Maple Sugar"      },
                { 9193, "Miso"             },
                { 9198, "Miso Ramen Soup"  },
                {  616, "Pie Dough"        },
                { 2561, "Pizza Dough"      },
                { 5194, "Pomodoro Sauce"   },
                { 9196, "Ramen Noodles"    },
                { 2272, "Rst. Coff. Beans" },
                {  611, "Rye Flour"        },
                { 1840, "Semolina"         },
                { 4460, "Stone Cheese"     },
                { 5299, "Salsa"            },
                {  615, "Selbina Butter"   },
                {  610, "San d'Or. Flour"  },
                { 9197, "Soy Ramen Soup"   },
                { 1776, "Spaghetti"        },
                { 4408, "Tortilla"         },
                { 1554, "Turmeric"         },
                { 4356, "White Bread"      },
                { 5575, "Yogurt"           },
            },
            {
                {  625, "Apple Vinegar"    },
                { 4509, "Distilled Water"  },
                { 4370, "Honey"            },
                {  633, "Olive Oil"        },
                { 1652, "Rice Vinegar"     },
                { 4378, "Selbina Milk"     },
                { 5232, "Soy Milk"         },
                { 9194, "Soy Sauce"        },
                { 5703, "Uleguerand Milk"  },
                { 5562, "White Honey"      },
            },
            {
                { 5568, "Apkallu Egg"      },
                { 4570, "Bird Egg"         },
                { 4357, "Crawler Egg"      },
                { 4362, "Lizard Egg"       },
                { 5569, "Puk Egg"          },
            },
        },
    },
    Leathercraft =
    {
        category =
        {
           "Hide",
           "Leather",
        },
        list =
        {
            {
                {  860, "Behemoth Hide"    },
                { 1628, "Buffalo Hide"     },
                { 1640, "Bugard Skin"      },
                { 2123, "Catoblepas Hide"  },
                { 8754, "Cehuetzi Pelt"    },
                { 2169, "Cerberus Hide"    },
                {  854, "Cockatrice Skin"  },
                {  863, "Coeurl Hide"      },
                {  857, "Dhalmel Hide"     },
                { 1623, "Eft Skin"         },
                { 1516, "Griffon Hide"     },
                { 1680, "H.Q. Bugard Skin" },
                { 1591, "H.Q. Coeurl Hide" },
                {  878, "Karakul Skin"     },
                { 1277, "Lindwurm Skin"    },
                {  869, "Lizard Molt"      },
                {  852, "Lizard Skin"      },
                { 2512, "Lynx Hide"        },
                {  876, "Manta Skin"       },
                { 1116, "Manticore Hide"   },
                { 2151, "Marid Hide"       },
                { 1861, "Moblin Sheepskin" },
                { 2121, "Ovinnik Hide"     },
                { 2523, "Peiste Skin"      },
                { 8707, "Raaz Hide"        },
                {  856, "Rabbit Hide"      },
                {  859, "Ram Skin"         },
                {  853, "Raptor Skin"      },
                { 2755, "Ruszor Hide"      },
                {  505, "Sheepskin"        },
                { 2518, "Smilodon Hide"    },
                { 3552, "Squamous Hide"    },
                {  861, "Tiger Hide"       },
                {  858, "Wolf Hide"        },
                {  849, "Undead Skin"      },
                { 1122, "Wyvern Skin"      },
                { 1124, "Wyvern Wing"      },
            },
            {
                {  862, "Behem. Leather"   },
                { 1629, "Buffalo Leather"  },
                { 1637, "Bugard Leather"   },
                { 2124, "Catobl. Leather"  },
                { 2170, "Cerber. Leather"  },
                {  506, "Coeurl Leather"   },
                {  848, "Dhalmel Leather"  },
                { 1767, "Eltoro Leather"   },
                { 1459, "Griffon Leather"  },
                {  879, "Karakul Leather"  },
                { 2530, "Lynx Leather"     },
                {  877, "Manta Leather"    },
                { 1117, "Manticore Lth."   },
                { 2152, "Marid Leather"    },
                { 1862, "M. Sheep Lth."    },
                { 2122, "Ovinnik Leather"  },
                {  917, "Parchment"        },
                { 2538, "Peiste Leather"   },
                { 8708, "Raaz Leather"     },
                {  851, "Ram Leather"      },
                { 2756, "Ruszor Leather"   },
                {  850, "Sheep Leather"    },
                { 2529, "Smilodon Leather" },
                {  855, "Tiger Leather"    },
                { 2550, "Vellum"           },
            },
        },
    },
    Smithing =
    {
        category =
        {
            "Ore",
            "Ingot",
            "Sheet",
            "Scales",
            "Chain",
        },
        list =
        {
            {
                { 1229, "Adaman Nugget"    },
                {  646, "Adaman Ore"       },
                { 1231, "Brass Nugget"     },
                { 1232, "Bronze Nugget"    },
                { 1230, "Copper Nugget"    },
                {  640, "Copper Ore"       },
                { 1228, "Dst. Nugget"      },
                {  645, "Darksteel Ore"    },
                { 1654, "Igneous Rock"     },
                { 1234, "Iron Nugget"      },
                {  643, "Iron Ore"         },
                { 1155, "Iron Sand"        },
                { 2711, "Khroma Nugget"    },
                {  685, "Khroma Ore"       },
                { 1650, "Kopparnickel Ore" },
                { 1703, "Kunwu Ore"        },
                {  647, "Molybdenum Ore"   },
                { 2531, "Obsidian"         },
                { 2860, "Plumbago"         },
                { 1466, "Relic Iron"       },
                { 1235, "Steel Nugget"     },
                { 2763, "Swamp Ore"        },
                {  734, "Thokcha Ore"      },
                {  641, "Tin Ore"          },
                { 4020, "Titanium Ore"     },
                { 1469, "Wootz Ore"        },
            },
            {
                {  655, "Adaman Ingot"     },
                {  649, "Bronze Ingot"     },
                {  648, "Copper Ingot"     },
                {  658, "Damascus Ingot"   },
                { 2000, "Dark Adaman"      },
                {  654, "Darksteel Ingot"  },
                { 9454, "Embersteel Ingot" },
                {  686, "Imp. Wootz Ingot" },
                {  651, "Iron Ingot"       },
                { 1681, "Light Steel"      },
                { 1711, "Molybden. Ingot"  },
                { 1635, "Paktong Ingot"    },
                { 1467, "Relic Steel"      },
                { 1738, "Shakudo Ingot"    },
                {  652, "Steel Ingot"      },
                {  657, "Tama-Hagane"      },
                {  735, "Thokcha Ingot"    },
                {  659, "Tin Ingot"        },
                { 4021, "Titanium Ingot"   },
                { 2302, "Tr. Brz. Ingot"   },
                { 2858, "Wolfram Steel"    },
                { 1461, "Wootz Ingot"      },
            },
            {
                {  665, "Adaman Sheet"     },
                {  660, "Bronze Sheet"     },
                { 2001, "Drk. Adm. Sheet"  },
                { 1990, "Drk. Brz. Sheet"  },
                {  664, "Darksteel Sheet"  },
                {  662, "Iron Sheet"       },
                {  669, "Mlbd. Sheet"      },
                {  666, "Steel Sheet"      },
                { 4022, "Titanium Sheet"   },
                { 2303, "Tr. Brz. Sheet"   },
            },
            {
                {  675, "Adaman Scales"    },
                {  673, "Brass Scales"     },
                {  672, "Bronze Scales"    },
                { 1773, "Dark Scales"      },
                {  674, "Iron Scales"      },
                {  676, "Steel Scales"     },
            },
            {
                {  683, "Adaman Chain"     },
                {  684, "Aluminum Chain"   },
                {  764, "Brass Chain"      },
                {  682, "Darksteel Chain"  },
                { 2551, "Electrum Chain"   },
                {  761, "Gold Chain"       },
                {  680, "Iron Chain"       },
                {  681, "Mythril Chain"    },
                {  762, "Ocl. Chain"       },
                {  762, "Platinum Chain"   },
                {  760, "Silver Chain"     },
            },
        },
    },
    Goldsmithing =
    {
        category =
        {
            "Ore",
            "Ingot",
            "Sheet",
            "Rock",
            "Gem",
        },
        list =
        {
            {
                { 2417, "Aht Urhgan Brass" },
                {  678, "Aluminum Ore"     },
                { 2305, "Auric Sand"       },
                { 1231, "Brass Nugget"     },
                { 2859, "Cobalt Ore"       },
                { 1258, "Earth Ore"        },
                { 1262, "Dark Ore"         },
                { 1255, "Fire Ore"         },
                { 2508, "Gold Dust"        },
                { 1225, "Gold Nugget"      },
                {  737, "Gold Ore"         },
                { 1256, "Ice Ore"          },
                { 1261, "Light Ore"        },
                { 1259, "Lightning Ore"    },
                { 2228, "Luminium Ore"     },
                { 1226, "Mythril Nugget"   },
                {  644, "Mythril Ore"      },
                {  739, "Orichalcum Ore"   },
                {  741, "P. Brass Ore"     },
                {  740, "Phyrgian Ore"     },
                { 1227, "Platinum Nugget"  },
                {  738, "Platinum Ore"     },
                { 3922, "Rhodium Ore"      },
                { 3924, "Scholar Stone"    },
                { 2275, "Scintillant Ingot"},
                { 1233, "Silver Nugget"    },
                {  736, "Silver Ore"       },
                { 3920, "Vanadium Ore"     },
                { 1260, "Water Ore"        },
                { 1257, "Wind Ore"         },
                {  642, "Zinc Ore"         },
            },
            {
                { 2418, "A.U. Brass Ingot" },
                {  679, "Aluminum Ingot"   },
                {  650, "Brass Ingot"      },
                { 2536, "Electrum Ingot"   },
                {  745, "Gold Ingot"       },
                { 1858, "Moblumin Ingot"   },
                {  653, "Mythril Ingot"    },
                { 2308, "Mythril Coil"     },
                {  747, "Ocl. Ingot"       },
                {  742, "P. Brass Ingot"   },
                {  746, "Platinum Ingot"   },
                { 3923, "Rhodium Ingot"    },
                {  744, "Silver Ingot"     },
            },
            {
                {  670, "Aluminum Sheet"   },
                {  661, "Brass Sheet"      },
                {  752, "Gold Sheet"       },
                { 1859, "Moblumin Sheet"   },
                {  663, "Mythril Sheet"    },
                {  668, "Ocl. Sheet"       },
                {  755, "P. Brass Sheet"   },
                {  754, "Platinum Sheet"   },
                {  671, "Silver Sheet"     },
            },
            {
                { 3302, "Aqua Geode"       },
                {  775, "Black Rock"       },
                {  770, "Blue Rock"        },
                { 3299, "Breeze Geode"     },
                { 3526, "Carbite"          },
                { 3527, "Fenrite"          },
                { 3297, "Flame Geode"      },
                {  768, "Flint Stone"      },
                { 3522, "Garudite"         },
                { 4057, "Gelid Aggregate"  },
                {  772, "Green Rock"       },
                { 3520, "Ifritite"         },
                { 3525, "Leviatite"        },
                { 3303, "Light Geode"      },
                { 1836, "Marble"           },
                { 3921, "Marble Nugget"    },
                {  774, "Purple Rock"      },
                { 3524, "Ramuite"          },
                {  769, "Red Rock"         },
                { 1649, "Scarlet Stone"    },
                { 3304, "Shadow Geode"     },
                { 3521, "Shivite"          },
                { 3298, "Snow Geode"       },
                { 3300, "Soil Geode"       },
                { 1470, "Sparkling Stone"  },
                { 3301, "Thunder Geode"    },
                { 3523, "Titanite"         },
                {  773, "Translucent Rock" },
                {  776, "White Rock"       },
                {  771, "Yellow Rock"      },
            },
            {
                {  779, "Aventurine"       },
                {  813, "Angelstone"       },
                {  814, "Amber"            },
                {  800, "Amethyst"         },
                {  811, "Ametrine"         },
                {  791, "Aquamarine"       },
                {  793, "Black Pearl"      },
                {  767, "Carnelian"        },
                {  801, "Chrysoberyl"      },
                {  780, "Clarite"          },
                {  809, "Clear Topaz"      },
                { 1306, "Dark Bead"        },
                {  812, "Deathstone"       },
                {  787, "Diamond"          },
                { 1302, "Earth Bead"       },
                {  785, "Emerald"          },
                { 1299, "Fire Bead"        },
                {  810, "Fluorite"         },
                {  777, "Fulmenite"        },
                {  790, "Garnet"           },
                {  808, "Goshenite"        },
                {  778, "Heliodor"         },
                { 1300, "Ice Bead"         },
                { 1740, "Iolite"           },
                {  784, "Jadeite"          },
                { 1460, "Koh-I-Noor"       },
                {  795, "Lapis Lazuli"     },
                {  781, "Larimar"          },
                { 1305, "Light Bead"       },
                {  796, "Light Opal"       },
                { 1303, "Lightning Bead"   },
                {  802, "Moonstone"        },
                {  799, "Onyx"             },
                {  797, "Painite"          },
                {  792, "Pearl"            },
                {  788, "Peridot"          },
                { 1634, "Rhodonite"        },
                {  786, "Ruby"             },
                {  794, "Sapphire"         },
                {  807, "Sardonyx"         },
                {  782, "Selenite"         },
                {  815, "Sphene"           },
                {  804, "Spinel"           },
                {  803, "Sunstone"         },
                {  783, "Tenebrite"        },
                {  789, "Topaz"            },
                {  806, "Tourmaline"       },
                {  798, "Turquoise"        },
                { 1304, "Water Bead"       },
                { 1301, "Wind Bead"        },
                {  805, "Zircon"           },
            },
        },
    },
    Woodworking =
    {
        category =
        {
            "Log",
            "Lumber",
            "Fletchings",
            "Arrowheads",
            "Other",
        },
        list =
        {
            {
                {  731, "Aquilaria Log"    },
                {  688, "Arrowwood Log"    },
                {  698, "Ash Log"          },
                {  704, "Bamboo Stick"     },
                {  692, "Beech Log"        },
                {  729, "Bloodwood Log"    },
                { 1762, "Cassia Lumber"    },
                {  694, "Chestnut Log"     },
                {  722, "Divine Log"       },
                {  727, "Dogwood Log"      },
                {  702, "Ebony Log"        },
                {  690, "Elm Log"          },
                { 2761, "Feyweald Log"     },
                {  697, "Holly Log"        },
                { 2534, "Jacaranda Log"    },
                {  732, "Kapor Log"        },
                { 1446, "Lacquer Tree Log" },
                { 1464, "Lancewood Log"    },
                {  689, "Lauan Log"        },
                {  700, "Mahogany Log"     },
                {  691, "Maple Log"        },
                {  699, "Oak Log"          },
                {  703, "Petrified Log"    },
                {  701, "Rosewood Log"     },
                { 2532, "Teak Log"         },
                { 3926, "Urunday Log"      },
                {  693, "Walnut Log"       },
                {  695, "Willow Log"       },
                {  696, "Yew Log"          },
                { 4014, "Yggdreant Bole"   },
            },
            {
                {  720, "Ancient Lumber"   },
                {  705, "Arrowwood Lbr."   },
                {  715, "Ash Lumber"       },
                {  709, "Beech Lumber"     },
                {  730, "Bloodwood Lumber" },
                {  710, "Chestnut Lumber"  },
                {  723, "Divine Lumber"    },
                {  728, "Dogwd. Lumber"    },
                {  719, "Ebony Lumber"     },
                {  707, "Elm Lumber"       },
                { 2762, "Feywld. Lumber"   },
                {  714, "Holly Lumber"     },
                { 2535, "Jacaranda Lumber" },
                {  733, "Kapor Lumber"     },
                { 1462, "Lancewood Lumber" },
                { 1447, "Lqr. Tree Lbr."   },
                {  706, "Lauan Lumber"     },
                {  717, "Mahogany Lbr."    },
                {  708, "Maple Lumber"     },
                {  716, "Oak Lumber"       },
                {  721, "Rattan Lumber"    },
                {  718, "Rosewood Lbr."    },
                { 2533, "Teak Lumber"      },
                { 3927, "Urunday Lumber"   },
                {  711, "Walnut Lumber"    },
                {  712, "Willow Lumber"    },
                {  713, "Yew Lumber"       },
            },
            {
                { 2292, "Apkal. Fletching"  },
                { 1223, "Bird Fletchings"   },
                { 1254, "Blk. Chc. Fltchg." },
                { 1221, "Chocobo Fltchg."   },
                { 2649, "Colibri Fltchg."   },
                { 1417, "G. Bird Fltchg."   },
                { 2548, "Gnat Fletchings"   },
                { 1224, "Insect Fltchg."    },
                { 9172, "Porxie Fletchings" },
                { 2291, "Puk Fletching"     },
                { 1222, "Yagudo Fltchg."    },
            },
            {
                { 1243, "Acid Bolt Heads"  },
                { 1627, "Arm. Arrowhd."    },
                { 1248, "Beetle Arrowhd."  },
                { 2546, "Blk. Boltheads"   },
                { 1242, "Bln. Bolt Heads"  },
                { 1246, "Bld. Bolt Heads"  },
                { 1215, "Bone Arrowhd."    },
                { 1211, "Brz. Bolt Heads"  },
                { 1213, "Dst. Bolt Heads"  },
                { 1251, "Demon Arrowhd."   },
                { 1515, "Fang Arrowhd."    },
                { 1961, "Gold Arrowheads"  },
                { 1244, "Holy Bolt Heads"  },
                { 1249, "Horn Arrowheads"  },
                { 1216, "Iron Arrowheads"  },
                { 1416, "Kari. Arrowhd."   },
                { 2293, "M. Tusk Arwhds."  },
                { 1212, "Mtl. Bolt Heads"  },
                { 2547, "Obsid. Arrowhd."  },
                { 1962, "Plt. Arrowheads"  },
                { 1252, "Poison Arrowhd."  },
                { 1250, "Scp. Arrowhd."    },
                { 1253, "Sleep Arrowhd."   },
                { 1247, "Slp. Bolt Heads"  },
                { 1217, "Slv. Arrowheads"  },
                { 1214, "Stone Arrowhd."   },
                { 1245, "Vnm. Bolt Heads"  },
            },
            {
                { 1134, "Bast Parchment"   },
                { 1657, "Bundling Twine"   },
                { 1817, "Cactus Arm"       },
                { 1444, "Divine Sap"       },
                { 1240, "Koma"             },
                { 1448, "Lqr. Tree Sap"    },
                { 1415, "Urushi"           },
                { 1763, "Viridian Urushi"  },
            },
        },
    },

    Fishing =
    {
        condition = "[EB]FISHING",
        category  =
        {
            "Fish",
            "Bait",
            "Rods",
        },
        list =
        {
            {
                { 5476, "Abaia"            },
                { 5455, "Ahtapot"          },
                { 5461, "Alabaligi"        },
                { 4316, "Armored Pisces"   },
                { 4461, "Bastore Bream"    },
                { 4360, "Bastore Sardine"  },
                { 5473, "Bastore Sweeper"  },
                { 5139, "Betta"            },
                { 4479, "Bhefhel Marlin"   },
                { 4318, "Bibiki Urchin"    },
                { 4314, "Bibikibo"         },
                { 4429, "Black Eel"        },
                { 5138, "Black Ghost"      },
                { 4384, "Black Sole"       },
                { 4471, "Bladefish"        },
                { 4313, "Blindfish"        },
                { 4399, "Bluetail"         },
                { 5469, "Brass Loach"      },
                { 5474, "Ca Cuong"         },
                { 5465, "Caedarva Frog"    },
                { 4309, "Cave Cherax"      },
                { 4379, "Cheval Salmon"    },
                { 4443, "Cobalt Jellyfish" },
                { 5128, "Cone Calamary"    },
                { 4515, "Copper Frog"      },
                { 4580, "Coral Butterfly"  },
                { 4472, "Crayfish"         },
                { 4473, "Crescent Fish"    },
                { 4528, "Crystal Bass"     },
                { 1210, "Damp Scroll"      },
                { 4428, "Dark Bass"        },
                { 5447, "Denizanasi"       },
                { 5457, "Dil"              },
                { 4290, "Elshimo Frog"     },
                { 4579, "Elshimo Newt"     },
                { 4454, "Emperor Fish"     },
                { 4501, "Fat Greedie"      },
                { 4289, "Forest Carp"      },
                { 5472, "Garpike"          },
                { 4477, "Gavial Fish"      },
                { 5471, "Gerrothorax"      },
                { 4469, "Giant Catfish"    },
                { 4308, "Giant Chirai"     },
                { 4306, "Giant Donko"      },
                { 5475, "Gigant Octopus"   },
                { 4474, "Gigant Squid"     },
                { 4427, "Gold Carp"        },
                { 4383, "Gold Lobster"     },
                { 4500, "Greedie"          },
                { 4304, "Grimmonite"       },
                { 4480, "Gugru Tuna"       },
                { 5127, "Gugrusaurus"      },
                { 5132, "Gurnard"          },
                { 5449, "Hamsi"            },
                { 2341, "Hydrogauge"       },
                { 4470, "Icefish"          },
                { 5453, "Istakoz"          },
                { 5136, "Istavrit"         },
                { 5456, "Istiridye"        },
                { 4307, "Jungle Catfish"   },
                { 5448, "Kalamar"          },
                { 5140, "Kalkanbaligi"     },
                { 5464, "Kaplumbaga"       },
                { 5460, "Kayabaligi"       },
                { 5451, "Kilicbaligi"      },
                { 5450, "Lakerda"          },
                { 2216, "Lamp Marimo"      },
                { 5129, "Lik"              },
                { 4315, "Lungfish"         },
                { 5468, "Matsya"           },
                { 5467, "Megalodon"        },
                { 5454, "Mercanbaligi"     },
                { 4401, "Moat Carp"        },
                { 1638, "Moblin Mask"      },
                { 5134, "Mola Mola"        },
                { 4462, "Monke-Onke"       },
                { 5121, "Moorish Idol"     },
                { 5462, "Morinabaligi"     },
                { 5126, "Muddy Siredon"    },
                { 4361, "Nebimonite"       },
                { 4485, "Noble Lady"       },
                { 1135, "Norg Shell"       },
                { 4482, "Nosteau Herring"  },
                { 4481, "Ogre Eel"         },
                {  624, "Pamtam Kelp"      },
                { 5125, "Phanauet Newt"    },
                { 4464, "Pipira"           },
                { 5470, "Pirarucu"         },
                { 5133, "Pterygotus"       },
                { 6371, "Quick. Blade"     },
                { 4514, "Quus"             },
                { 4402, "Red Terrapin"     },
                { 5135, "Rhinochimera"     },
                { 4305, "Ryugu Titan"      },
                { 4291, "Sandfish"         },
                { 5459, "Sazanbaligi"      },
                { 4475, "Sea Zombie"       },
                { 4484, "Shall Shell"      },
                { 4354, "Shining Trout"    },
                { 4451, "Silver Shark"     },
                { 4463, "Takitaro"         },
                { 5130, "Tavnazian Goby"   },
                { 4478, "Three-Eyed Fish"  },
                { 4483, "Tiger Cod"        },
                { 5817, "Tiger Shark"      },
                { 4310, "Tiny Goldfish"    },
                { 5120, "Titanic Sawfish"  },
                { 4476, "Titanictus"       },
                { 4426, "Tricolored Carp"  },
                { 4319, "Tricorn"          },
                { 4317, "Trilobite"        },
                { 5466, "Trumpet Shell"    },
                { 5137, "Turnabaligi"      },
                { 5452, "Uskumru"          },
                { 5141, "Veydal Wrasse"    },
                { 5131, "Vongola Clam"     },
                { 5463, "Yayinbaligi"      },
                { 4403, "Yellow Globe"     },
                { 5458, "Yilanbaligi"      },
                { 4385, "Zafmlug Bass"     },
                { 4288, "Zebra Eel"        },
                { 3965, "Adoulinian Kelp"  },
            },
            {
                { 16997, "Crayfish Ball"    },
                { 17006, "Drill Calamary"   },
                { 17007, "Dwarf Pugil"      },
                { 17405, "Fly Lure"         },
                { 17403, "Frog Lure"        },
                { 16998, "Insect Ball"      },
                { 17395, "Lugworm"          },
                { 17396, "Little Worm"      },
                { 17401, "Lizard Lure"      },
                { 17005, "Lufaise Fly"      },
                { 17000, "Meatball"         },
                { 17407, "Minnow"           },
                { 16993, "Peeled Crayfish"  },
                { 17394, "Peeled Lobster"   },
                { 17002, "Robber Rig"       },
                { 16995, "Rotten Meat"      },
                { 17398, "Rogue Rig"        },
                { 17399, "Sabiki Rig"       },
                { 16996, "Sardine Ball"     },
                { 17397, "Shell Bug"        },
                { 17402, "Shrimp Lure"      },
                { 17400, "Sinking Minnow"   },
                { 16992, "Sliced Bluetail"  },
                { 17393, "Sliced Cod"       },
                { 16994, "Sliced Moat Carp" },
                { 17392, "Sliced Sardine"   },
                { 17003, "Super Scoop"      },
                { 16999, "Trout Ball"       },
                { 17404, "Worm Lure"        },
            },
            {
                { 17011, "Ebisu Fishing Rod"  },
                { 17014, "Hume Fishing Rod"   },
                { 17015, "Halcyon Rod"        },
                { 17380, "Mithran Fish. Rod"  },
                { 17381, "Comp. Fishing Rod"  },
                { 17382, "S.H. Fishing Rod"   },
                { 17383, "Clothespole"        },
                { 17384, "Carbon Fish. Rod"   },
                { 17385, "Glass Fiber F. Rod" },
                { 17386, "Lu Shang's F. Rod"  },
                { 17387, "Tarutaru F. Rod"    },
                { 17388, "Fastwater F. Rod"   },
                { 17389, "Bamboo Fish. Rod"   },
                { 17390, "Yew Fishing Rod"    },
                { 17391, "Willow Fish. Rod"   },
            },
        },
    },

    Lapidary =
    {
        condition = "[EB]LAPIDARY",
        category =
        {
            "Minerals",
            "Refined",
            "Consumable",
        },
        list =
        {
            {
                -- Copper Ore
                { 8930, "Bornite"        },
                { 8931, "Azurite"        },
                -- Tin Ore
                { 8933, "Stannite"       },
                { 8934, "Cylindrite"     },
                -- Zinc Ore
                { 8936, "Sphalerite"     },
                { 8937, "Wurtzite"       },
                -- Iron Ore
                { 8939, "Hematite"       },
                { 8940, "Magnetite"      },
                -- Darksteel Ore
                { 8942, "Siderite"       },
                { 8943, "Goethite"       },
                -- Silver Ore
                { 8945, "Bromyrite"      },
                { 8946, "Argentite"      },
                -- Gold Ore
                { 8948, "Petzite"        },
                { 8949, "Sylvanite"      },
                -- Platinum Ore
                { 8951, "Sperrylite"     },
                { 8952, "Malanite"       },

                { 8954, "Hibonite"       },
                { 8956, "Taenite"        },
                { 8958, "Kamacite"       },
                { 8960, "Rough Sapphire" },
                { 8962, "Rough Jadeite"  },
                { 8964, "Rough Ruby"     },
            },
            {
                { 8932, "Fine Azurite"    },
                { 8935, "Fine Cylindrite" },
                { 8938, "Fine Wurtzite"   },
                { 8941, "Fine Magnetite"  },
                { 8944, "Fine Goethite"   },
                { 8947, "Fine Argentite"  },
                { 8950, "Fine Sylvanite"  },
                { 8953, "Fine Malanite"   },
                { 8955, "Fine Hibonite"   },
                { 8957, "Fine Taenite"    },
                { 8959, "Fine Kamacite"   },
                { 8961, "Fine Sapphire"   },
                { 8963, "Fine Jadeite"    },
                { 8965, "Fine Ruby"       },
            },
            {
                { 6558, "Ifrit's Ire"        },
                { 6559, "Leviathan's Deluge" },
                { 6560, "Garuda's Tempest"   },
                { 6561, "Titan's Resolve"    },
                { 6562, "Shiva's Remorse"    },
                { 6563, "Ramuh's Judgment"   },
            },
        },
    },

    Ninjutsu =
    {
        condition = "[EB]NINJUTSU",
        category  =
        {
            "Tools",
            "Toolbags",
            "Shuriken",
            "Pouches",
        },
        list =
        {
            {
                { 1161, "Uchitake"        },
                { 1164, "Tsurara"         },
                { 1167, "Kawahori-ogi"    },
                { 1170, "Makibishi"       },
                { 1173, "Hiraishin"       },
                { 1176, "Mizu-deppo"      },
                { 1179, "Shihei"          },
                { 1182, "Jusatsu"         },
                { 1185, "Kaginawa"        },
                { 1188, "Sairui-ran"      },
                { 1191, "Kodoku"          },
                { 1194, "Shinobi-tabi"    },
                { 2553, "Sanjaku-tenugui" },
                { 2555, "Soshi"           },
                { 2642, "Kabenro"         },
                { 2643, "Jinko"           },
                { 2644, "Ryuno"           },
                { 2970, "Mokujin"         },
                { 2971, "Inoshishinofuda" },
                { 2972, "Shikanofuda"     },
                { 2973, "Chonofuda"       },
            },
            {
                { 5308, "Toolbag: Uchi"  },
                { 5309, "Toolbag: Tsura" },
                { 5310, "Toolbag: Kawa"  },
                { 5311, "Toolbag: Maki"  },
                { 5312, "Toolbag: Hira"  },
                { 5313, "Toolbag: Mizu"  },
                { 5314, "Toolbag: Shihe" },
                { 5315, "Toolbag: Jusa"  },
                { 5316, "Toolbag: Kagi"  },
                { 5317, "Toolbag: Sai"   },
                { 5318, "Toolbag: Kodo"  },
                { 5319, "Toolbag: Shino" },
                { 5417, "Toolbag: Sanja" },
                { 5734, "Toolbag: Soshi" },
                { 5863, "Toolbag: Kaben" },
                { 5864, "Toolbag: Jinko" },
                { 5865, "Toolbag: Ryuno" },
                { 5866, "Toolbag: Moku"  },
                { 5867, "Toolbag: Ino"   },
                { 5868, "Toolbag: Shika" },
                { 5869, "Toolbag: Cho"   },
            },
            {
                { 17301, "Shuriken"          },
                { 17302, "Juji Shuriken"     },
                { 17303, "Manji Shuriken"    },
                { 17304, "Fuma Shuriken"     },
                { 18712, "Koga Shuriken"     },
            },
            {
                { 6299,  "Sh. Pouch"       },
                { 6297,  "Juji Sh. Pouch"  },
                { 6298,  "Manji Sh. Pouch" },
                { 6302,  "Fuma Sh. Pouch"  },
                { 6300,  "Koga Sh. Pouch"  },
            },
        },
    },

    Food =
    {
        condition = "[EB]FOOD",
        category  =
        {
            "Meat/Eggs",
            "Seafood",
            "Vegetables",
            "Soups",
            "Breads/Rice",
            "Sweets",
            "Drinks",
        },
        list =
        {
            {
                { 6465, "Behe. Steak +1" },
                { 6464, "Behemoth Steak" },
                { 5207, "Bison Jerky" },
                { 5142, "Bison Steak" },
                { 4536, "Blackened Frog" },
                { 4581, "Blackened Newt" },
                { 5266, "Blackened Siredon" },
                { 4599, "Blackened Toad" },
                { 4547, "Boiled Cockatrice" },
                { 5196, "Buffalo Jerky" },
                { 4349, "Bunny Ball" },
                { 5925, "C. Salis. steak" },
                { 5643, "Cibarious Cilbir" },
                { 5642, "Cilbir" },
                { 4548, "Coeurl Saute" },
                { 4487, "Colored Egg" },
                { 6396, "Cutlet Sandwich" },
                { 6397, "Cutlet Sandwich +1" },
                { 4411, "Dhalmel Pie" },
                { 4322, "Dhalmel Pie +1" },
                { 4438, "Dhalmel Steak" },
                { 4350, "Dragon Steak" },
                { 4326, "Frog Flambe" },
                { 4395, "Galkan Sausage" },
                { 5859, "Glk. Sausage +1" },
                { 5860, "Glk. Sausage +2" },
                { 5861, "Glk. Sausage +3" },
                { 5862, "Glk. Sausage -1" },
                { 4516, "Grilled Black hare" },
                { 4371, "Grilled Hare" },
                { 4409, "Hard-boiled Egg" },
                { 5146, "Hedgehog Pie" },
                { 5609, "Hellsteak" },
                { 5610, "Hellsteak +1" },
                { 4552, "Herb Crawler eggs" },
                { 5739, "Honeyed Egg" },
                { 5683, "Humpty Dumpty" },
                { 5602, "Hydra Kofte" },
                { 5603, "Hydra Kofte +1" },
                { 4331, "Imperial Omelette" },
                { 4335, "Juicy Mutton" },
                { 6071, "Magma Steak" },
                { 6072, "Magma Steak +1" },
                { 5157, "Marbled Steak" },
                { 5689, "Meatloaf" },
                { 5690, "Meatloaf +1" },
                { 4574, "Meat Chiefkabob" },
                { 4376, "Meat Jerky" },
                { 4381, "Meat Mithkabob" },
                { 5586, "Menemen" },
                { 5587, "Menemen +1" },
                { 4439, "Navarin" },
                { 4329, "Newt Flambe" },
                { 4595, "Party Egg" },
                { 5660, "Pepperoni" },
                { 5156, "Porcupine Pie" },
                { 6394, "Pork Cutlet" },
                { 6395, "Pork Cutlet +1" },
                { 6274, "Pukatrice Egg" },
                { 6275, "Pukatrice Egg +1" },
                { 5685, "Rabbit Pie" },
                { 4507, "Rarab Meatball" },
                { 4437, "Roast Mutton" },
                { 4564, "Royal Omelette" },
                { 4295, "Royal Saute" },
                { 5924, "S. Salis. steak" },
                { 5737, "Salted Hare" },
                { 4578, "Sausage" },
                { 4518, "Sheep Jerky" },
                { 5598, "Sis Kebabi" },
                { 5599, "Sis Kebabi +1" },
                { 4532, "Soft-boiled Egg" },
                { 5738, "Sweet Lizard" },
                { 4284, "Tender Navarin" },
                { 4519, "Wild Steak" },
            },
            {
                { 5652, "Anchovy" },
                { 5600, "Balik Sis" },
                { 5601, "Balik Sis +1" },
                { 4582, "Bass Meuniere" },
                { 4346, "Bass Meuniere +1" },
                { 5981, "Bld. Barnacles +1" },
                { 5980, "Boiled Barnacles" },
                { 4456, "Boiled Crab" },
                { 4535, "Boiled Crayfish" },
                { 4540, "Boiled Tuna head" },
                { 5176, "Bream Sushi" },
                { 5177, "Bream Sushi +1" },
                { 4586, "Broiled Carp" },
                { 4588, "Broiled Eel" },
                { 4585, "Broiled Pipira" },
                { 4587, "Broiled Trout" },
                { 4267, "Btr. Nebimonite" },
                { 5721, "Crab Sushi" },
                { 5722, "Crab Sushi +1" },
                { 6277, "D.-fr. Shrimp +1" },
                { 6276, "D.-fried Shrimp" },
                { 5178, "Dorado Sushi" },
                { 5179, "Dorado Sushi +1" },
                { 4457, "Eel Kabob" },
                { 4275, "Emperor Roe" },
                { 5665, "Fin Sushi" },
                { 5666, "Fin Sushi +1" },
                { 5145, "Fish & Chips" },
                { 4575, "Fish Chiefkabob" },
                { 4398, "Fish Mithkabob" },
                { 4276, "Flint Caviar" },
                { 4345, "Flnd. Meuniere +1" },
                { 4584, "Flounder Meuniere" },
                { 5159, "Friture Misareaux" },
                { 5153, "Fty. Tuna sushi" },
                { 4539, "Goblin Pie" },
                { 6584, "Grilled Dfly. Trout" },
                { 5648, "Grilled Lik" },
                { 4559, "Herb Quus" },
                { 4325, "Hobgoblin Pie" },
                { 5219, "Ikra Gunkan" },
                { 5220, "Ikra Gunkan +1" },
                { 5175, "Leremieu Taco" },
                { 5647, "Lik Kabob" },
                { 5670, "Loach Gruel" },
                { 5669, "Loach Slop" },
                { 5671, "Loach Soup" },
                { 4294, "Medicinal Quus" },
                { 4459, "Nebimonite Bake" },
                { 6070, "Oceanfin Soup" },
                { 5693, "Octopus Sushi" },
                { 5694, "Octopus Sushi +1" },
                { 4490, "Pickled Herring" },
                { 5983, "Piscators Skewer" },
                { 6069, "Riverfin Soup" },
                { 4537, "Roast Carp" },
                { 4538, "Roast Pipira" },
                { 4404, "Roast Trout" },
                { 4551, "Salmon Croute" },
                { 5217, "Salmon Eggs" },
                { 4583, "Salmon Meuniere" },
                { 5218, "Salmon Roe" },
                { 5663, "Salmon Sushi" },
                { 5664, "Salmon Sushi +1" },
                { 6583, "Salted Dfly. Trout" },
                { 4353, "Sea Bass Croute" },
                { 5982, "Senroh Skewer" },
                { 4554, "Shallops Tropicale" },
                { 5691, "Shrimp Sushi" },
                { 5692, "Shrimp Sushi +1" },
                { 4347, "Slmn. Meuniere +1" },
                { 5943, "Smoked Mackerel" },
                { 4380, "Smoked Salmon" },
                { 5149, "Sole Sushi" },
                { 5163, "Sole Sushi +1" },
                { 5148, "Squid Sushi" },
                { 5162, "Squid Sushi +1" },
                { 4557, "Steamed Catfish" },
                { 4342, "Steamed Crab" },
                { 4338, "Stmd. Crayfish" },
                { 6468, "Sublime Sushi" },
                { 6469, "Sublime Sushi +1" },
                { 5174, "Tavnazian Taco" },
                { 5215, "Tentacle Sushi" },
                { 5216, "Tentacle Sushi +1" },
                { 5150, "Tuna Sushi" },
                { 5151, "Urchin Sushi" },
                { 5160, "Urchin Sushi +1" },
                { 5183, "Viking Herring" },
            },
            {
                { 4436, "Baked Popoto" },
                { 4553, "Batagreen Saute" },
                { 5168, "Bataquiche" },
                { 5169, "Bataquiche +1" },
                { 4572, "Beaugr. Saute" },
                { 5679, "Cathedral Salad" },
                { 5171, "Emerald Quiche" },
                { 6272, "Fried Popoto" },
                { 6273, "Fried Popoto +1" },
                { 4543, "Goblin Mushpot" },
                { 5143, "Goblin Stir-fry" },
                { 5170, "Green Quiche" },
                { 4334, "Grilled Corn" },
                { 4488, "Jack-o-lantern" },
                { 5588, "Karni Yarik" },
                { 5589, "Karni Yarik +1" },
                { 5161, "Leadafry" },
                { 5185, "Leremieu Salad" },
                { 4293, "Monastic Saute" },
                { 5678, "Mushroom Salad" },
                { 5676, "Mushroom Saute" },
                { 5701, "Nopales Salad" },
                { 5702, "Nopales Salad +1" },
                { 6470, "Oden" },
                { 6471, "Oden +1" },
                { 5582, "Patlican Salata" },
                { 5583, "Patlican Salata +1" },
                { 5677, "Patriarch Saute" },
                { 4282, "Pipin Popoto" },
                { 6610, "Popo. Con que. +1" },
                { 6609, "Popo. Con queso" },
                { 5731, "Ratatouille" },
                { 5732, "Ratatouille +1" },
                { 4415, "Roasted Corn" },
                { 4410, "Roast Mushroom" },
                { 4321, "T. Timbers Salad" },
                { 5173, "T. Timbers Taco" },
                { 4279, "Tavnazian Salad" },
                { 5184, "Vegan Saute" },
                { 4555, "Windurst Salad" },
                { 5172, "Windurst Taco" },
                { 4343, "Witch Kabob" },
            },
            {
                { 5998, "Adoulinian Soup" },
                { 5999, "Adoulinian Soup +1" },
                { 5611, "Angler Stewpot" },
                { 5547, "Beef Stewpot" },
                { 4297, "Black Curry" },
                { 4542, "Brain Stew" },
                { 5544, "Crab Stewpot" },
                { 4533, "Delicious Puls" },
                { 4433, "Dhalmel Stew" },
                { 4549, "Dragon Soup" },
                { 4417, "Egg Soup" },
                { 4327, "Emerald Soup" },
                { 4453, "Eyeball Soup" },
                { 4465, "Goblin Stew" },
                { 5750, "Goulash" },
                { 5751, "Goulash +1" },
                { 4296, "Green Curry" },
                { 4521, "Humpty Soup" },
                { 4522, "Jack-o-soup" },
                { 5760, "Kohlrouladen" },
                { 5761, "Kohlrouladen +1" },
                { 6466, "Miso Soup" },
                { 6467, "Miso Soup +1" },
                { 4419, "Mushroom Soup" },
                { 4544, "Mushroom Stew" },
                { 5595, "Nashmau Stew" },
                { 4285, "Ocean Soup" },
                { 4340, "Optical Soup" },
                { 4416, "Pea Soup" },
                { 4455, "Pebble Soup" },
                { 5752, "Pot-au-feu" },
                { 5753, "Pot-au-feu +1" },
                { 5612, "Prm. Ang. Stewpot" },
                { 5548, "Prm. Beef Stewpot" },
                { 5545, "Prm. Crab Stewpot" },
                { 5239, "Prm. Sfd. Stewpot" },
                { 6220, "Prm. Wt. stewpot" },
                { 5613, "Prz. Ang. Stewpot" },
                { 5549, "Prz. Beef Stewpot" },
                { 5546, "Prz. Crab Stewpot" },
                { 5240, "Prz. Sfd. Stewpot" },
                { 6221, "Prz. Wt. Stewpot" },
                { 4492, "Puls" },
                { 4430, "Pumpkin Soup" },
                { 4298, "Red Curry" },
                { 4561, "Seafood Stew" },
                { 5238, "Seafood Stewpot" },
                { 4452, "Shark Fin soup" },
                { 5931, "Shimmy Soup" },
                { 4601, "Sopa Pez blanco" },
                { 5180, "Sophic Stew" },
                { 5930, "Sprightly Soup" },
                { 4337, "Stamina Soup" },
                { 4341, "Sunset Soup" },
                { 4420, "Tomato Soup" },
                { 4418, "Turtle Soup" },
                { 4323, "Vegetable Broth" },
                { 4560, "Vegetable Soup" },
                { 6219, "Warthog Stewpot" },
                { 4440, "Whitefish Stew" },
                { 4589, "Wild Stew" },
                { 4592, "Wisdom Soup" },
                { 4333, "Witch Soup" },
                { 4344, "Witch Stew" },
                { 5579, "Yayla Corbasi" },
                { 5580, "Yayla Corbasi +1" },
                { 4517, "Yellow Curry" },
                { 5619, "Zesty Zoni" },
                { 5618, "Zoni" },
            },
            {
                { 6260, "Akamochi" },
                { 6261, "Akamochi +1" },
                { 5700, "Anch. Pizza +1" },
                { 6218, "Anch. Slice +1" },
                { 5699, "Anchovy Pizza" },
                { 6217, "Anchovy Slice" },
                { 5657, "Army Biscuit" },
                { 5211, "Arrabbiata" },
                { 5212, "Arrabbiata +1" },
                { 5892, "B.e.w. Pitaru" },
                { 5764, "B. Curry Bun +1" },
                { 5590, "Balik Sandvici" },
                { 5974, "Barnacle Paella" },
                { 6341, "Bean Daifuku" },
                { 6342, "Bean Daifuku +1" },
                { 5972, "Beef Paella" },
                { 5973, "Beef Paella +1" },
                { 4364, "Black Bread" },
                { 5758, "Black Curry Bun" },
                { 5591, "Blk. Sandvici +1" },
                { 5192, "Boscaiola" },
                { 5201, "Boscaiola +1" },
                { 4550, "Bream Risotto" },
                { 4391, "Bretzel" },
                { 5190, "Carbonara" },
                { 5199, "Carbonara +1" },
                { 4407, "Carp Sushi" },
                { 5687, "Cheese Sand. +1" },
                { 5686, "Cheese Sandwich" },
                { 5166, "Coeurl Sub" },
                { 5167, "Coeurl Sub +1" },
                { 5774, "Crepe Forestiere" },
                { 5772, "Crepe Paysanne" },
                { 6600, "Egg Sand. +1" },
                { 6599, "Egg Sandwich" },
                { 5886, "Elshena" },
                { 6381, "Fishermans Feast" },
                { 5975, "Flapanos Paella" },
                { 4266, "Fulm-long Sub" },
                { 4280, "G. Cracker +1" },
                { 5762, "G. Curry Bun +1" },
                { 4467, "Garlic Cracker" },
                { 4458, "Goblin Bread" },
                { 6343, "Grape Daifuku" },
                { 6344, "Grape Daifuku +1" },
                { 5756, "Green Curry Bun" },
                { 5771, "Ham & Ch. Crepe" },
                { 5928, "Himesama R. Ball" },
                { 4328, "Hobgoblin Bread" },
                { 5584, "Ic Pilav" },
                { 5585, "Ic Pilav +1" },
                { 4499, "Iron Bread" },
                { 6262, "Kusamochi" },
                { 6263, "Kusamochi +1" },
                { 5696, "Marg. Pizza +1" },
                { 6214, "Marg. Slice +1" },
                { 5695, "Margherita Pizza" },
                { 6213, "Margherita Slice" },
                { 5719, "Marinara" },
                { 5720, "Marinara +1" },
                { 5743, "Marinara Pizza" },
                { 5744, "Marinara Pizza +1" },
                { 6211, "Marinara Slice" },
                { 6212, "Marinara Slice +1" },
                { 5888, "Maringna" },
                { 4534, "Medicinal Gruel" },
                { 5213, "Melanzane" },
                { 5214, "Melanzane +1" },
                { 6460, "Miso Ramen" },
                { 6461, "Miso Ramen +1" },
                { 5887, "Montagna" },
                { 4568, "Moon Ball" },
                { 4348, "Mttn. Enchilada" },
                { 5971, "Mush. Paella +1" },
                { 5773, "Mushroom Crepe" },
                { 5970, "Mushroom Paella" },
                { 4434, "Mushroom Risotto" },
                { 4506, "Mutton Tortilla" },
                { 4605, "Naval Rice Ball" },
                { 5193, "Nero Di Seppia" },
                { 5202, "Nero Seppia +1" },
                { 5929, "Ojo Rice ball" },
                { 6602, "Om. Sand. +1" },
                { 6601, "Om. Sandwich" },
                { 5658, "Ortolana" },
                { 5659, "Ortolana +1" },
                { 4292, "Pain De Neige" },
                { 5188, "Peperoncino" },
                { 5197, "Peperoncino +1" },
                { 5698, "Pepp. Pizza +1" },
                { 6216, "Pepp. Slice +1" },
                { 5697, "Pepperoni Pizza" },
                { 6215, "Pepperoni Slice" },
                { 5191, "Pescatora" },
                { 5200, "Pescatora +1" },
                { 5969, "Piscators Paella" },
                { 5637, "Pogaca" },
                { 5638, "Pogaca +1" },
                { 6406, "Pork Cutlet Bowl" },
                { 6407, "Pork Cutlet Bowl +1" },
                { 5890, "Poultry Pitaru" },
                { 4591, "Pumpernickel" },
                { 5765, "R. Curry Bun +1" },
                { 4546, "Raisin Bread" },
                { 5759, "Red Curry Bun" },
                { 4281, "Red Hot cracker" },
                { 4405, "Rice Ball" },
                { 4271, "Rice Dumpling" },
                { 4604, "Rogue Rice Ball" },
                { 6339, "Rolan. Daifuku" },
                { 6340, "Rolan. Daifuku +1" },
                { 4590, "Salmon Rice Ball" },
                { 4355, "Salmon Sub" },
                { 5885, "Saltena" },
                { 5182, "Salty Bretzel" },
                { 6462, "Salt Ramen" },
                { 6463, "Salt Ramen +1" },
                { 4396, "Sausage Roll" },
                { 6612, "Sea. Gratin +1" },
                { 6611, "Seafood Gratin" },
                { 5968, "Seafood Paella" },
                { 5891, "Seafood Pitaru" },
                { 4268, "Sea Spray Risotto" },
                { 6258, "Shiromochi" },
                { 6259, "Shiromochi +1" },
                { 4278, "Shogun R.ball" },
                { 5636, "Shr. Cracker +1" },
                { 5635, "Shrimp Cracker" },
                { 5596, "Simit" },
                { 5597, "Simit +1" },
                { 6458, "Soy Ramen" },
                { 6459, "Soy Ramen +1" },
                { 4466, "Spicy Cracker" },
                { 4573, "Steel Bread" },
                { 5889, "Stuffed Pitaru" },
                { 5623, "Tonno Rosso" },
                { 5624, "Tonno Rosso +1" },
                { 4277, "Tonosama R.ball" },
                { 4408, "Tortilla" },
                { 5181, "Tortilla Buena" },
                { 4489, "Vegetable Gruel" },
                { 5189, "Vongole Rosso" },
                { 5198, "Vongole Rosso +1" },
                { 4356, "White Bread" },
                { 4330, "Witch Risotto" },
                { 5763, "Y. Curry Bun +1" },
                { 5186, "Yahata Sushi" },
                { 5757, "Ylw. Curry Bun" },
                { 5727, "Zaru Soba" },
                { 5728, "Zaru Soba +1" },
            },
            {
                { 6224, "A. Snow cone" },
                { 4510, "Acorn Cookie" },
                { 4413, "Apple Pie" },
                { 4320, "Apple Pie +1" },
                { 4406, "Baked Apple" },
                { 5729, "Bavarois" },
                { 5730, "Bavarois +1" },
                { 4496, "Bbl. Chocolate" },
                { 4269, "Bijou Glace" },
                { 5552, "Black Pudding" },
                { 5646, "Bld. Chocolate" },
                { 5550, "Buche Au choco." },
                { 5766, "Butter Crepe" },
                { 6225, "C. Coalescence" },
                { 6223, "C. Snow cone" },
                { 5941, "Campfire Choco" },
                { 5942, "Cascade Candy" },
                { 5745, "Cherry Bavarois" },
                { 5746, "Cherry Bavarois +1" },
                { 5779, "Cherry Macaron" },
                { 5653, "Cherry Muffin" },
                { 5654, "Cherry Muffin +1" },
                { 5934, "Chocobiscuit" },
                { 5633, "Chocolate Cake" },
                { 5775, "Chocolate Crepe" },
                { 5783, "Chocolate Rusk" },
                { 4397, "Cinna-cookie" },
                { 5784, "Coconut Rusk" },
                { 5656, "Coff. Muffin +1" },
                { 5780, "Coffee Macaron" },
                { 5655, "Coffee Muffin" },
                { 4520, "Coin Cookie" },
                { 5718, "Cream Puff" },
                { 5778, "Crepe B. helene" },
                { 5776, "Crepe Caprice" },
                { 5767, "Crepe Delice" },
                { 6568, "Crepe Des rois" },
                { 5144, "Crimson Jelly" },
                { 5681, "Cupid Chocolate" },
                { 5672, "Dried Berry" },
                { 5567, "Dried Date" },
                { 5574, "Dried Date +1" },
                { 5979, "Dulcet Panettones" },
                { 5553, "Dusky Indulgence" },
                { 5560, "Elysian Eclair" },
                { 5978, "Felicifruit Gelatin" },
                { 5555, "Flurry Courante" },
                { 6063, "Fruit Parfait" },
                { 5542, "Gat. Aux fraises" },
                { 4394, "Ginger Cookie" },
                { 4495, "Gob. Chocolate" },
                { 5558, "Golden Royale" },
                { 4497, "Heart Chocolate" },
                { 4324, "Hob. Chocolate" },
                { 4556, "Icecap Rolanberry" },
                { 5572, "Irmik Helvasi" },
                { 5573, "Irmik Helvasi +1" },
                { 5644, "Jack-o-pie" },
                { 5923, "Juglan Jumble" },
                { 5781, "Kitron Macaron" },
                { 5614, "Konigskuchen" },
                { 5616, "Lebkuchen House" },
                { 5617, "Lebkuchen Manse" },
                { 5230, "Love Chocolate" },
                { 5625, "Maple Cake" },
                { 4502, "Marron Glace" },
                { 4421, "Melon Pie" },
                { 4523, "Melon Pie +1" },
                { 5543, "Midwinter Dream" },
                { 5559, "Mille-feuille" },
                { 6009, "Mog Pudding" },
                { 5557, "Mont Blanc" },
                { 5935, "Moogurt" },
                { 4287, "Opo-opo Tart" },
                { 5629, "Orange Cake" },
                { 4393, "Orange Kuchen" },
                { 4332, "Orange Kuchen +1" },
                { 4563, "Pamama Tart" },
                { 5777, "Pear Crepe" },
                { 5631, "Pumpkin Cake" },
                { 4446, "Pumpkin Pie" },
                { 4525, "Pumpkin Pie +1" },
                { 6064, "Queens Crown" },
                { 4339, "Rolan. Pie +1" },
                { 4414, "Rolanberry Pie" },
                { 5673, "Rolsin" },
                { 6010, "Sakura Biscuit" },
                { 5556, "Seraphs Kiss" },
                { 5632, "Silken Sash" },
                { 5626, "Silken Siesta" },
                { 5628, "Silken Smile" },
                { 5634, "Silken Spirit" },
                { 5630, "Silken Squeeze" },
                { 5147, "Snoll Gelato" },
                { 4594, "Snowy Rolanberry" },
                { 5554, "Squirrels Delight" },
                { 5155, "Sub-zero Gelato" },
                { 5782, "Sugar Rusk" },
                { 5577, "Sutlac" },
                { 5578, "Sutlac +1" },
                { 4336, "Swt. Bkd. apple" },
                { 4270, "Swt. Rice cake" },
                { 5551, "Sylvan Excursion" },
                { 5940, "Trail Cookie" },
                { 6567, "Tropical Crepe" },
                { 5231, "Truelove Choco." },
                { 5615, "Uberkuchen" },
                { 5158, "Vermillion Jelly" },
                { 5922, "Walnut Cookie" },
                { 4577, "Wild Cookie" },
                { 5645, "Witch Nougat" },
                { 4576, "Wizard Cookie" },
                { 5627, "Yogurt Cake" },
            },
            {
                { 4300, "Apple Au lait" },
                { 4423, "Apple Juice" },
                { 5576, "Ayran" },
                { 5927, "Caravan Tea" },
                { 5570, "Chai" },
                { 5594, "Chai +1" },
                { 4603, "Chamomile Tea" },
                { 4283, "Choco-delight" },
                { 4498, "Chocomilk" },
                { 5933, "D. Fruit au lait" },
                { 5926, "Date Tea" },
                { 5944, "Frontier Soda" },
                { 4541, "Goblin Drink" },
                { 4441, "Grape Juice" },
                { 4286, "Healing Tea" },
                { 5592, "Imperial Coffee" },
                { 5593, "Imperial Coffee +1" },
                { 6257, "Jungle Nectar" },
                { 5932, "Kitron Juice" },
                { 4424, "Melon Juice" },
                { 4299, "Orange Au lait" },
                { 4422, "Orange Juice" },
                { 4302, "Pamama Au lait" },
                { 4301, "Pear Au lait" },
                { 4303, "Persikos Au lait" },
                { 4442, "Pineapple Juice" },
                { 4524, "Royal Tea" },
                { 4494, "San Dorian tea" },
                { 4425, "Tomato Juice" },
                { 5976, "Ulbuconut Milk" },
                { 5977, "Ulbuconut Milk +1" },
                { 4512, "Vampire Juice" },
                { 4493, "Windurstian Tea" },
                { 4558, "Yagudo Drink" },
            },
        },
    },

    Incursion =
    {
        condition = "[EB]INCURSION",
        category =
        {
            "Currencies",
            "Materials",
            "Weapons",
        },
        list =
        {
            {
                { 3951, "Orcish Steel"   },
                { 3952, "Quadav Brass"   },
                { 3953, "Yagudo Silver"  },
            },
            {
                { 3954, "Orcish Leather" },
                { 3955, "Quadav Thread"  },
                { 3956, "Yagudo Cloth"   },
            },
            {
                { 2984, "Worn Knuckles"  },
                { 2985, "Worn Sword"     },
                { 2986, "Worn Axe"       },
                { 2987, "Worn Chopper"   },
                { 2988, "Worn Lance"     },
                { 2989, "Worn Shield"    },

                { 2978, "Worn Rapier"    },
                { 2979, "Worn Blade"     },
                { 2980, "Worn Scythe"    },
                { 2981, "Worn Hammer"    },
                { 2982, "Worn Staff"     },
                { 2983, "Worn Musket"    },

                { 2990, "Worn Knife"     },
                { 2991, "Worn Katana"    },
                { 2992, "Worn Tachi"     },
                { 2993, "Worn Pole"      },
                { 2994, "Worn Longbow"   },
                { 2995, "Worn Fife"      },
            },
        },
    },

    Spawners =
    {
        category =
        {
            "Tu'Lia",
            "Lumoria",
            "Goblin Brew",
        },
        list =
        {
            {
                {  1404, "Seal of Genbu",    1 },
                {  1405, "Seal of Seiryu",   1 },
                {  1406, "Seal of Byakko",   1 },
                {  1407, "Seal of Suzaku",   1 },

                {  3275, "Genbu Scrap"         },
                {  3276, "Suzaku Scrap"        },
                {  3277, "Seiryu Scrap"        },
                {  3278, "Byakko Scrap"        },

                {  1418, "Gem of the East",  1 },
                {  1419, "Springstone",      1 },
                {  1420, "Gem of the South", 1 },
                {  1421, "Summerstone",      1 },

                {  1422, "Gem of the West",  1 },
                {  1423, "Autumnstone",      1 },
                {  1424, "Gem of the North", 1 },
                {  1425, "Winterstone",      1 },

                { 16575, "Curtana",          1 },
                {  2388, "Chunk of Diorite", 1 },
            },
            {
                { 1851, "Deed of Placidity" },
                { 1854, "Deed of Moder."    },
                { 1870, "Deed of Sensib."   },
                { 1872, "Ghrah M Chip"      },

                { 1850, "First Virtue"      },
                { 1853, "Second Virtue"     },
                { 1856, "Third Virtue"      },
                { 1848, "Fourth Virtue"     },

                { 1847, "Fifth Virtue"      },
                { 1849, "Sixth Virtue"      },
            },
            {
                { xi.item.GOBLIN_BREW,    "Goblin Brew"    },
                { xi.item.GOBLIN_BREW_P1, "Goblin Brew +1" },
                { xi.item.GOBLIN_BREW_P2, "Goblin Brew +2" },
                { xi.item.GOBLIN_BREW_P3, "Goblin Brew +3" },
            },
        },
    },

    Other =
    {
        category =
        {
            "Crystals",
            "Currencies",
            "Beast-made",
            "Limbus",
            "Bundling",
        },
        list =
        {
            {
                {  4096, "Fire Crystal"     },
                {  4097, "Ice Crystal"      },
                {  4098, "Wind Crystal"     },
                {  4099, "Earth Crystal"    },
                {  4100, "Lightng. Crystal" },
                {  4101, "Water Crystal"    },
                {  4102, "Light Crystal"    },
                {  4103, "Dark Crystal"     },
                {  4238, "Inferno Crystal"  },
                {  4239, "Glacier Crystal"  },
                {  4240, "Cyclone Crystal"  },
                {  4241, "Terra Crystal"    },
                {  4242, "Plasma Crystal"   },
                {  4243, "Torrent Crystal"  },
                {  4244, "Aurora Crystal"   },
                {  4245, "Twilight Crystal" },
            },
            {
                {   656, "Beastcoin"        },
                {   750, "Silver Beastcoin" },
                {   749, "Mtl. Beastcoin"   },
                {   748, "Gold Beastcoin"   },

                {   751, "Plt. Beastcoin"   },
                {  8966, "Crystal Frag."    },
                {  1452, "O. Bronzepiece"   },
                {  1455, "1 Byne Bill"      },

                {  1449, "T. Whiteshell"    },
                {  1474, "Infinity Core"    },
                {  1453, "M. Silverpiece"   },
                {  1456, "100 Byne Bill"    },

                {  1450, "L. Jadeshell"     },
                {  2488, "Alexandrite"      },
                {  8798, "H-P Bayld"        },
                {  3493, "Frgtn. Thought"   },

                {  3494, "Forgotten Hope"   },
                {  3495, "Forgotten Touch"  },
                {  3496, "Frgtn. Journey"   },
                {  3497, "Forgotten Step"   },

                {  2184, "Imp. Brz. Piece"  },
                {  2185, "Imp. Slv. Piece"  },
                {  2186, "Imp. Mtl. Piece"  },
                {  2187, "Imp. Gold Piece"  },
            },
            {
                {  1118, "Antican Pauldron"   },
                {  1121, "Antican Robe"       },
                {  1624, "Bugbear Mask"       },
                {  1614, "Corse Bracelet"     },
                {  1639, "Corse Robe"         },
                {  2653, "Gigas Gauntlets"    },
                {  2652, "Gigas Helm"         },
                {   499, "Gigas Necklace"     },
                {   497, "Gigas Socks"        },
                {   510, "Goblin Armor"       },
                {   508, "Goblin Helm"        },
                {   507, "Goblin Mail"        },
                {   511, "Goblin Mask"        },
                {  2542, "Goblin Mess Tin"    },
                {  2543, "Goblin Weel"        },
                {   554, "Gold Orcmask"       },
                {  2505, "H. Qdv. Backplate"  },
                {  2504, "H. Qdv. Chestplate" },
                {  1980, "Antican Acid"       },
                {  2167, "Lamian Armlet"      },
                {  2227, "Mamool Ja Collar"   },
                {  2162, "Mamool Ja Helmet"   },
                {  1631, "Moblin Armor"       },
                {  1625, "Moblin Helm"        },
                {  1632, "Moblin Mail"        },
                {  1638, "Moblin Mask"        },
                {  2510, "Orc Helmet"         },
                {  2511, "Orc Pauldron"       },
                {  2334, "Poroggo Hat"        },
                {  1196, "Qiqirn Cape"        },
                {  2153, "Qiqirn Sandbag"     },
                {   596, "Quadav Backplate"   },
                {   501, "Quadav Helm"        },
                {  2159, "Qutrub Bandage"     },
                {  2165, "Qutrub Gorget"      },
                {  1724, "Soulflayer Robe"    },
                {  2336, "Soulflayer Staff"   },
                {  1119, "Tonberry Coat"      },
                {  1162, "Tonberry Lantern"   },
                {  2160, "Troll Pauldron"     },
                {  2161, "Troll Vambrace"     },
                {   498, "Yagudo Necklace"    },
                {  2520, "Yagudo Kote"        },
                {  2519, "Yagudo Osode"       },
            },
            {
                { 1930, "Ecarlate Cloth"      },
                { 1931, "Argyro Rivet"        },
                { 1932, "Ut. Gold Thread"     },
                { 1933, "Ancient Brass"       },
                { 1934, "Benedict Silk"       },
                { 1935, "Benedict Yarn"       },
                { 1936, "Diabolic Silk"       },
                { 1937, "Diabolic Yarn"       },
                { 1938, "Rby. Silk Thread"    },
                { 1939, "Cardinal Cloth"      },
                { 1940, "Supple Skin"         },
                { 1941, "Light Filament"      },
                { 1942, "Snowy Cermet"        },
                { 1943, "White Rivet"         },
                { 1944, "Dark Orichalcum"     },
                { 1945, "Black Rivet"         },
                { 1946, "Smalt Leather"       },
                { 1947, "Fetid Lanolin"       },
                { 1948, "Coiled Yarn"         },
                { 1949, "Brown Doeskin"       },
                { 1950, "Chameleon Yarn"      },
                { 1951, "Charcoal Cotton"     },
                { 1952, "Scarlet Odoshi"      },
                { 1953, "Kurogane"            },
                { 1954, "Plaited Cord"        },
                { 1955, "Ebony Lacquer"       },
                { 1956, "Cbl. Myth. Sheet"    },
                { 1957, "Blue Rivet"          },
                { 1958, "Glittering Yarn"     },
                { 1959, "Astral Leather"      },
                { 2656, "Luminian Thread"     },
                { 2657, "Flameshun Cloth"     },
                { 2658, "Silkworm Thread"     },
                { 2659, "Canvas Toile"        },
                { 2660, "Pantin Wire"         },
                { 2661, "Corduroy Cloth"      },
                { 2714, "Filet Lace"          },
                { 2715, "Gold Stud"           },
                { 2716, "Brilliantine"        },
                { 2717, "Electrum Stud"       },
            },
            {
                {  1657, "Bundling Twine"     },
                {  2143, "Mandrel"            },
                {  2130, "Shagreen File"      },
                {  2128, "Spindle"            },
                {  2129, "Tanning Vat"        },
                {  2131, "Triturator"         },
                {  2144, "Workshop Anvil"     },
            },
        },
    },
}

for craftName, craftType in pairs(cexi.crystal_warrior.ephemeral_box.list) do
    if craftType.condition ~= nil then
        for matTypeID, matType in pairs(craftType.list) do
            for _, material in pairs(matType) do
                cexi.crystal_warrior.ephemeral_box.conditional[material[1]] = { craftType.condition, material[2], craftName, craftType.category[matTypeID] }
            end
        end
    else
        for matTypeID, matType in pairs(craftType.list) do
            for _, material in pairs(matType) do
                cexi.crystal_warrior.ephemeral_box.tradeable[material[1]] = { material[2], craftName, craftType.category[matTypeID], material[3] }
            end
        end
    end
end

for convertable, convertInfo in pairs(cexi.crystal_warrior.ephemeral_box.conversion) do
    cexi.crystal_warrior.ephemeral_box.tradeable[convertable] = convertInfo[3]
end

for itemID, itemInfo in pairs(cexi.crystal_warrior.ephemeral_box.seals) do
    cexi.crystal_warrior.ephemeral_box.tradeable[itemID] = { itemInfo[2], "Other", "N/A" }
end

cexi.crystal_warrior.ephemeral_box.tradeable[xi.item.ANCIENT_BEASTCOIN] = { "Ancient Beastcoin", "Other", "N/A" }

for itemID, _ in pairs(cexi.crystal_warrior.ephemeral_box.organs) do
    cexi.crystal_warrior.ephemeral_box.tradeable[itemID] = { cexi.itemName[itemID], "Other", "N/A" }
end

local function delayMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local EB_PAGE  = "[EB]PAGE"
local EB_ITEM  = "[EB]%u"

cexi.crystal_warrior.ephemeral_box.qtyList  =
{
    {  "x1",  1 },
    {  "x2",  2 },
    {  "x3",  3 },
    {  "x6",  6 },
    { "x12", 12 },
    { "x24", 24 },
    { "x36", 36 },
    { "x99", 99 },
}

cexi.crystal_warrior.ephemeral_box.boxGiveItem = function(player, item, qty)
    local ID = zones[player:getZoneID()]
    local givenItems = { { item, qty } }

    if player:getFreeSlotsCount() < #givenItems then
        player:messageSpecial(ID.text.ITEM_CANNOT_BE_OBTAINED, givenItems[1][1])
        return false
    end

    local messagedItems = {}
    for _, v in pairs(givenItems) do
        if player:addItem(v[1], v[2], true) then
            if not messagedItems[v[1]] then
                player:messageSpecial(ID.text.ITEM_OBTAINED + 9, v[1], v[2])
            end

            messagedItems[v[1]] = true
        elseif #givenItems == 1 then
            player:messageSpecial(ID.text.ITEM_CANNOT_BE_OBTAINED, givenItems[1][1])
            return false
        end
    end

    return true
end

cexi.crystal_warrior.ephemeral_box.giveQuantity = function(player, npc, item, qty)
    local curr = player:getCharVar(string.format(EB_ITEM, item))

    if qty > curr then
        player:sys("You cannot remove {} items when only {} are stored.", qty, curr)
        return
    end

    if
        cexi.crystal_warrior.ephemeral_box.tradeable[item] ~= nil and
        cexi.crystal_warrior.ephemeral_box.tradeable[item][4] ~= nil and
        qty > cexi.crystal_warrior.ephemeral_box.tradeable[item][4]
    then
        player:sys("You can only remove {} of that item at a time.", cexi.crystal_warrior.ephemeral_box.tradeable[item][4])
        return
    end

    npc:ceAnimate(player, player, 75, 4)

    player:timer(500, function()
        if cexi.crystal_warrior.ephemeral_box.boxGiveItem(player, item, qty) then
            player:setCharVar(string.format(EB_ITEM, item), curr - qty)
        end
    end)
end

cexi.crystal_warrior.ephemeral_box.quantityPage = function(player, npc, material)
    if player:getLocalVar("[EB]OPEN") == 1 then
        return
    end

    player:setLocalVar("[EB]OPEN", 1)

    local tbl = {}
    local curr = player:getCharVar(string.format(EB_ITEM, material[1]))

    if
        cexi.crystal_warrior.ephemeral_box.tradeable[material[1]] ~= nil and
        cexi.crystal_warrior.ephemeral_box.tradeable[material[1]][4] ~= nil and
        curr >= cexi.crystal_warrior.ephemeral_box.tradeable[material[1]][4]
    then
        if curr > 0 then
            delayMenu(player, {
                title   = "Select a quantity:",
                options =
                {
                    {
                        "x1",
                        function()
                            npc:ceAnimate(player, player, 75, 4)

                            player:timer(500, function()
                                if boxGiveItem(player, material[1], 1) then
                                    player:setLocalVar("[EB]OPEN", 0)
                                    player:setCharVar(string.format(EB_ITEM, material[1]), curr - 1)

                                    if (curr - 1) > 0 then
                                        cexi.crystal_warrior.ephemeral_box.quantityPage(player, npc, material)
                                    end
                                end
                            end)
                        end,
                    },
                },
                onCancelled = function(player)
                    player:setLocalVar("[EB]OPEN", 0)
                end,
            })
        end

        return
    end

    for k, v in pairs(cexi.crystal_warrior.ephemeral_box.qtyList) do
        if v[2] <= curr then
            table.insert(tbl, {
                v[1],
                function()
                    npc:ceAnimate(player, player, 75, 4)

                    player:timer(500, function()
                        if cexi.crystal_warrior.ephemeral_box.boxGiveItem(player, material[1], v[2]) then
                            player:setLocalVar("[EB]OPEN", 0)
                            player:setCharVar(string.format(EB_ITEM, material[1]), curr - v[2])

                            if (curr - v[2]) > 0 then
                                cexi.crystal_warrior.ephemeral_box.quantityPage(player, npc, material)
                            end
                        end
                    end)
                end,
            })
        end
    end

    delayMenu(player, {
        title       = "Select a quantity:",
        options     = tbl,
        onCancelled = function(player)
            player:setLocalVar("[EB]OPEN", 0)
        end,
    })
end

return m
